/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.cli.common.CodeAnalysisMeasurement;
import org.jetbrains.kotlin.cli.common.CodeGenerationMeasurement;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CompilerInitializationMeasurement;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.IRMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.MessageCollectorToOutputItemsCollectorAdapter;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItemKt;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.AbiSnapshotImpl;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.BaseCompilationTransaction;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.BuildDiffsStorage;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.CachesManagerCloseException;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.DirtyFilesContainer;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.FragmentContext;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalCachesManager;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.NonRecoverableCompilationTransaction;
import org.jetbrains.kotlin.incremental.RecoverableCompilationTransaction;
import org.jetbrains.kotlin.incremental.RequireRebuildForCorrectnessInKMPException;
import org.jetbrains.kotlin.incremental.TransactionOutputsRegistrar;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.incremental.storage.BasicFileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.FileLocations;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.util.BufferingMessageCollector;
import org.jetbrains.kotlin.incremental.util.ExceptionLocation;
import org.jetbrains.kotlin.incremental.util.MessageCollectorUtilKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.util.UtilKt;
import org.jetbrains.kotlin.utils.MetadataHelpersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \u00a0\u0001*\b\b\u0000\u0010\u0001*\u00020\u0002*\f\b\u0001\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042\u00020\u0005:\n\u009d\u0001\u009e\u0001\u009f\u0001\u00a0\u0001\u00a1\u0001BM\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J&\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u001d\u00103\u001a\u00028\u00012\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00106J\u0015\u00107\u001a\u00020\u00072\u0006\u00105\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00108J?\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u00105\u001a\u00028\u00002\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(\u00a2\u0006\u0002\u0010AJ\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J?\u0010F\u001a\u00020C2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u00105\u001a\u00028\u00002\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010=\u001a\u00020>H\u0002\u00a2\u0006\u0002\u0010GJE\u0010H\u001a\u00020:2\u0006\u0010I\u001a\u00020J2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u00105\u001a\u00028\u00002\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010K\u001a\u00020.2\u0006\u0010=\u001a\u00020>H\u0002\u00a2\u0006\u0002\u0010LJ!\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020O0N2\u0006\u00105\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010PJ\u0016\u0010Q\u001a\u00020R2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J-\u0010S\u001a\u00020T2\b\u0010?\u001a\u0004\u0018\u00010T2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u0010U\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010VJA\u0010W\u001a\u00020X2\u0006\u0010U\u001a\u00028\u00012\u0006\u0010?\u001a\u00020T2\u0006\u00105\u001a\u00028\u00002\u0006\u0010=\u001a\u00020>2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020O0NH$\u00a2\u0006\u0002\u0010ZJ5\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020O0N2\u0006\u00105\u001a\u00028\u00002\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0014\u00a2\u0006\u0002\u0010\\J\u0018\u0010]\u001a\u00020R2\u0006\u0010^\u001a\u00020_2\u0006\u0010?\u001a\u00020TH\u0004J3\u0010`\u001a\u00020R2\u0006\u0010a\u001a\u00020b2\u0006\u0010U\u001a\u00028\u00012\f\u0010c\u001a\b\u0012\u0004\u0012\u00020d0<2\u0006\u0010e\u001a\u00020fH$\u00a2\u0006\u0002\u0010gJ1\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00070i2\u0006\u0010U\u001a\u00028\u00012\f\u0010c\u001a\b\u0012\u0004\u0012\u00020d0<2\u0006\u0010a\u001a\u00020bH\u0014\u00a2\u0006\u0002\u0010jJ\u000e\u0010k\u001a\b\u0012\u0004\u0012\u00020l0iH\u0014JC\u0010m\u001a\u00020n2\u0006\u00105\u001a\u00028\u00002\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020r2\u0006\u0010U\u001a\u00028\u00012\f\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00070\"2\u0006\u0010t\u001a\u00020.H\u0014\u00a2\u0006\u0002\u0010uJc\u0010v\u001a\u0014\u0012\u0004\u0012\u00020:\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00100w2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u00105\u001a\u00028\u00002\u0006\u0010U\u001a\u00028\u00012\u0006\u0010a\u001a\u00020b2\u0006\u0010=\u001a\u00020>2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u0010t\u001a\u00020.H$\u00a2\u0006\u0002\u0010zJM\u0010{\u001a\u00020:2\u0006\u00104\u001a\u00020&2\u0006\u0010|\u001a\u00020X2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u00105\u001a\u00028\u00002\u0006\u0010U\u001a\u00028\u00012\b\u0010}\u001a\u0004\u0018\u00010~2\u0006\u0010=\u001a\u00020>H\u0002\u00a2\u0006\u0002\u0010\u007fJ\n\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0002J\u001f\u0010\u0082\u0001\u001a\u00020R2\u0006\u0010|\u001a\u00020X2\u0006\u00105\u001a\u00028\u0000H\u0014\u00a2\u0006\u0003\u0010\u0083\u0001J(\u0010\u0084\u0001\u001a\u00020R2\u0006\u0010|\u001a\u00020X2\u0007\u0010\u0085\u0001\u001a\u00020:2\u0006\u0010U\u001a\u00028\u0001H\u0014\u00a2\u0006\u0003\u0010\u0086\u0001J\t\u0010\u0087\u0001\u001a\u00020RH\u0002JQ\u0010\u0088\u0001\u001a\u00020:2\u0006\u00104\u001a\u00020&2\u0006\u0010U\u001a\u00028\u00012\u0006\u0010|\u001a\u00020X2\r\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u00105\u001a\u00028\u00002\b\u0010}\u001a\u0004\u0018\u00010~2\u0007\u0010\u008a\u0001\u001a\u00020>H\u0002\u00a2\u0006\u0003\u0010\u008b\u0001J\t\u0010\u008c\u0001\u001a\u00020pH\u0016J\u001e\u0010\u008d\u0001\u001a\u00030\u008e\u00012\n\u0010U\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010?\u001a\u00020TH\u0004J\u0017\u0010\u008f\u0001\u001a\u00020.2\u0006\u0010U\u001a\u00028\u0001H\u0016\u00a2\u0006\u0003\u0010\u0090\u0001J-\u0010\u0091\u0001\u001a\u00020R2\u0006\u00104\u001a\u00020&2\u0006\u0010|\u001a\u00020X2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010\u0094\u0001\u001a\u00030\u008e\u0001H\u0002J\u0013\u0010\u0095\u0001\u001a\u00020R2\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0004J%\u0010\u0098\u0001\u001a\u00020R2\b\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u00020\f2\u0007\u0010\u009c\u0001\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u000e\u0010 \u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0012\u0010-\u001a\u00020.X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0012\u00101\u001a\u00020.X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00100\u00a8\u0006\u00a2\u0001"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner;", "Args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "CacheManager", "Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "", "workingDir", "Ljava/io/File;", "cacheDirName", "", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "buildHistoryFile", "outputDirs", "", "icFeatures", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationFeatures;", "<init>", "(Ljava/io/File;Ljava/lang/String;Lorg/jetbrains/kotlin/build/report/BuildReporter;Ljava/io/File;Ljava/util/Collection;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationFeatures;)V", "getReporter", "()Lorg/jetbrains/kotlin/build/report/BuildReporter;", "getBuildHistoryFile", "()Ljava/io/File;", "getIcFeatures", "()Lorg/jetbrains/kotlin/incremental/IncrementalCompilationFeatures;", "cacheDirectory", "getCacheDirectory", "dirtySourcesSinceLastTimeFile", "lastBuildInfoFile", "getLastBuildInfoFile", "abiSnapshotFile", "kotlinSourceFilesExtensions", "", "getKotlinSourceFilesExtensions", "()Ljava/util/Set;", "createIncrementalCompilationContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "fileLocations", "Lorg/jetbrains/kotlin/incremental/storage/FileLocations;", "transaction", "Lorg/jetbrains/kotlin/incremental/CompilationTransaction;", "fragmentContext", "Lorg/jetbrains/kotlin/incremental/FragmentContext;", "shouldTrackChangesInLookupCache", "", "getShouldTrackChangesInLookupCache", "()Z", "shouldStoreFullFqNamesInLookupCache", "getShouldStoreFullFqNamesInLookupCache", "createCacheManager", "icContext", "args", "(Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "destinationDir", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Ljava/io/File;", "compile", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "allSourceFiles", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles;", "(Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/incremental/ChangedFiles;Lorg/jetbrains/kotlin/incremental/storage/FileLocations;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "incrementalCompilationExceptionTransformer", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult;", "t", "", "tryCompileIncrementally", "(Ljava/util/List;Lorg/jetbrains/kotlin/incremental/ChangedFiles;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/incremental/storage/FileLocations;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult;", "compileNonIncrementally", "rebuildReason", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "trackChangedFiles", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/incremental/storage/FileLocations;ZLorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "getClasspathAbiSnapshot", "", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Ljava/util/Map;", "cleanOrCreateDirectories", "", "getChangedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "caches", "(Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;Ljava/util/List;Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;)Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "calculateSourcesToCompile", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "classpathAbiSnapshots", "(Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/Map;)Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "setupJarDependencies", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/build/report/BuildReporter;)Ljava/util/Map;", "initDirtyFiles", "dirtyFiles", "Lorg/jetbrains/kotlin/incremental/DirtyFilesContainer;", "updateCaches", "services", "Lorg/jetbrains/kotlin/config/Services;", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "(Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Ljava/util/List;Lorg/jetbrains/kotlin/incremental/ChangesCollector;)V", "additionalDirtyFiles", "", "(Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Ljava/util/List;Lorg/jetbrains/kotlin/config/Services;)Ljava/lang/Iterable;", "additionalDirtyLookupSymbols", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "makeServices", "Lorg/jetbrains/kotlin/config/Services$Builder;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "dirtySources", "isIncremental", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/incremental/components/LookupTracker;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Ljava/util/Set;Z)Lorg/jetbrains/kotlin/config/Services$Builder;", "runCompiler", "Lkotlin/Pair;", "sourcesToCompile", "allSources", "(Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Z)Lkotlin/Pair;", "compileImpl", "compilationMode", "abiSnapshotData", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$AbiSnapshotData;", "(Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$AbiSnapshotData;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "createTransaction", "Lorg/jetbrains/kotlin/incremental/BaseCompilationTransaction;", "performWorkBeforeCompilation", "(Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)V", "performWorkAfterCompilation", "exitCode", "(Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;Lorg/jetbrains/kotlin/cli/common/ExitCode;Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;)V", "collectSizeMetrics", "doCompile", "allKotlinSources", "originalMessageCollector", "(Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$AbiSnapshotData;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "getLookupTrackerDelegate", "getRemovedClassesChanges", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "runWithNoDirtyKotlinSources", "(Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;)Z", "processChangesAfterBuild", "currentBuildInfo", "Lorg/jetbrains/kotlin/incremental/BuildInfo;", "dirtyData", "reportPerformanceData", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "reportIrMeasurements", "it", "Lorg/jetbrains/kotlin/cli/common/IRMeasurement;", "timeMetric", "lineMetric", "ICResult", "AbiSnapshotData", "CompilationMode", "Companion", "EmptyCompilationCanceledStatus", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nIncrementalCompilerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalCompilerRunner\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n+ 3 CompilationTransaction.kt\norg/jetbrains/kotlin/incremental/CompilationTransactionKt\n+ 4 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,729:1\n31#2,5:730\n31#2,3:758\n35#2:762\n31#2,5:763\n31#2,5:777\n31#2,5:792\n31#2,5:806\n31#2,5:813\n31#2,5:828\n31#2,5:835\n76#3,2:735\n78#3,6:740\n84#3,2:755\n212#4,3:737\n223#4,2:746\n215#4,7:748\n1#5:757\n1#5:761\n1863#6,2:768\n1557#6:770\n1628#6,3:771\n774#6:774\n865#6,2:775\n3193#6,10:782\n1557#6:797\n1628#6,3:798\n774#6:801\n865#6,2:802\n1863#6,2:804\n1863#6,2:811\n865#6,2:818\n865#6,2:820\n1557#6:822\n1628#6,3:823\n1863#6,2:826\n1863#6,2:833\n*S KotlinDebug\n*F\n+ 1 IncrementalCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalCompilerRunner\n*L\n119#1:730,5\n283#1:758,3\n283#1:762\n308#1:763,5\n440#1:777,5\n505#1:792,5\n542#1:806,5\n590#1:813,5\n645#1:828,5\n224#1:835,5\n201#1:735,2\n201#1:740,6\n201#1:755,2\n201#1:737,3\n201#1:746,2\n201#1:748,7\n201#1:757\n319#1:768,2\n364#1:770\n364#1:771,3\n422#1:774\n422#1:775,2\n485#1:782,10\n520#1:797\n520#1:798,3\n526#1:801\n526#1:802,2\n529#1:804,2\n584#1:811,2\n617#1:818,2\n618#1:820,2\n623#1:822\n623#1:823,3\n632#1:826,2\n670#1:833,2\n*E\n"})
public abstract class IncrementalCompilerRunner<Args extends CommonCompilerArguments, CacheManager extends IncrementalCachesManager<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File workingDir;
    @NotNull
    private final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter;
    @Nullable
    private final File buildHistoryFile;
    @Nullable
    private final Collection<File> outputDirs;
    @NotNull
    private final IncrementalCompilationFeatures icFeatures;
    @NotNull
    private final File cacheDirectory;
    @NotNull
    private final File dirtySourcesSinceLastTimeFile;
    @NotNull
    private final File lastBuildInfoFile;
    @NotNull
    private final File abiSnapshotFile;
    @NotNull
    private final Set<String> kotlinSourceFilesExtensions;
    @NotNull
    public static final String DIRTY_SOURCES_FILE_NAME = "dirty-sources.txt";
    @NotNull
    public static final String LAST_BUILD_INFO_FILE_NAME = "last-build.bin";
    @NotNull
    public static final String ABI_SNAPSHOT_FILE_NAME = "abi-snapshot.bin";

    public IncrementalCompilerRunner(@NotNull File workingDir, @NotNull String cacheDirName, @NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter, @Nullable File buildHistoryFile, @Nullable Collection<? extends File> outputDirs, @NotNull IncrementalCompilationFeatures icFeatures) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)cacheDirName, (String)"cacheDirName");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)icFeatures, (String)"icFeatures");
        this.workingDir = workingDir;
        this.reporter = reporter;
        this.buildHistoryFile = buildHistoryFile;
        this.outputDirs = outputDirs;
        this.icFeatures = icFeatures;
        this.cacheDirectory = new File(this.workingDir, cacheDirName);
        this.dirtySourcesSinceLastTimeFile = new File(this.workingDir, DIRTY_SOURCES_FILE_NAME);
        this.lastBuildInfoFile = new File(this.workingDir, LAST_BUILD_INFO_FILE_NAME);
        this.abiSnapshotFile = new File(this.workingDir, ABI_SNAPSHOT_FILE_NAME);
        this.kotlinSourceFilesExtensions = SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS();
    }

    @NotNull
    protected final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> getReporter() {
        return this.reporter;
    }

    @Nullable
    protected final File getBuildHistoryFile() {
        return this.buildHistoryFile;
    }

    @NotNull
    protected final IncrementalCompilationFeatures getIcFeatures() {
        return this.icFeatures;
    }

    @NotNull
    protected final File getCacheDirectory() {
        return this.cacheDirectory;
    }

    @NotNull
    protected final File getLastBuildInfoFile() {
        return this.lastBuildInfoFile;
    }

    @NotNull
    protected Set<String> getKotlinSourceFilesExtensions() {
        return this.kotlinSourceFilesExtensions;
    }

    private final IncrementalCompilationContext createIncrementalCompilationContext(FileLocations fileLocations, CompilationTransaction transaction, FragmentContext fragmentContext) {
        Object object = fileLocations;
        FileToPathConverter fileToPathConverter = object != null && (object = ((FileLocations)object).getRelocatablePathConverterForSourceFiles()) != null ? (FileToPathConverter)object : (FileToPathConverter)BasicFileToPathConverter.INSTANCE;
        Object object2 = fileLocations;
        FileToPathConverter fileToPathConverter2 = object2 != null && (object2 = ((FileLocations)object2).getRelocatablePathConverterForOutputFiles()) != null ? (FileToPathConverter)object2 : (FileToPathConverter)BasicFileToPathConverter.INSTANCE;
        BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter = this.reporter;
        boolean bl = this.getShouldTrackChangesInLookupCache();
        boolean bl2 = this.getShouldStoreFullFqNamesInLookupCache();
        IncrementalCompilationFeatures incrementalCompilationFeatures = this.icFeatures;
        return new IncrementalCompilationContext(fileToPathConverter, fileToPathConverter2, bl2, transaction, buildReporter, bl, incrementalCompilationFeatures, fragmentContext, false, 256, null);
    }

    static /* synthetic */ IncrementalCompilationContext createIncrementalCompilationContext$default(IncrementalCompilerRunner incrementalCompilerRunner, FileLocations fileLocations, CompilationTransaction compilationTransaction, FragmentContext fragmentContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createIncrementalCompilationContext");
        }
        if ((n & 4) != 0) {
            fragmentContext = null;
        }
        return incrementalCompilerRunner.createIncrementalCompilationContext(fileLocations, compilationTransaction, fragmentContext);
    }

    protected abstract boolean getShouldTrackChangesInLookupCache();

    protected abstract boolean getShouldStoreFullFqNamesInLookupCache();

    @NotNull
    protected abstract CacheManager createCacheManager(@NotNull IncrementalCompilationContext var1, @NotNull Args var2);

    @NotNull
    protected abstract File destinationDir(@NotNull Args var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ExitCode compile(@NotNull List<? extends File> allSourceFiles, @NotNull Args args, @NotNull MessageCollector messageCollector, @Nullable ChangedFiles changedFiles, @Nullable FileLocations fileLocations) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter(allSourceFiles, (String)"allSourceFiles");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = GradleBuildTime.INCREMENTAL_COMPILATION_DAEMON;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            ExitCode exitCode;
            boolean bl = false;
            ICResult result2 = this.tryCompileIncrementally(allSourceFiles, changedFiles, args, fileLocations, messageCollector);
            if (result2 instanceof ICResult.Completed) {
                ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)IncrementalCompilerRunner::compile$lambda$3$lambda$0));
                exitCode = ((ICResult.Completed)result2).getExitCode();
            } else if (result2 instanceof ICResult.RequiresRebuild) {
                ICReporterKt.info(this.reporter, (Function0<String>)((Function0)() -> IncrementalCompilerRunner.compile$lambda$3$lambda$1(result2)));
                this.reporter.addAttribute(((ICResult.RequiresRebuild)result2).getReason());
                exitCode = this.compileNonIncrementally(((ICResult.RequiresRebuild)result2).getReason(), allSourceFiles, args, fileLocations, changedFiles == null, messageCollector);
            } else if (result2 instanceof ICResult.Failed) {
                MessageCollectorUtilKt.reportException(messageCollector, ((ICResult.Failed)result2).getCause(), ExceptionLocation.INCREMENTAL_COMPILATION);
                ICReporterKt.warn(this.reporter, (Function0<String>)((Function0)() -> IncrementalCompilerRunner.compile$lambda$3$lambda$2(result2)));
                this.reporter.addAttribute(((ICResult.Failed)result2).getReason());
                exitCode = this.compileNonIncrementally(((ICResult.Failed)result2).getReason(), allSourceFiles, args, fileLocations, changedFiles == null, messageCollector);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ExitCode result3 = exitCode;
            this.collectSizeMetrics();
            ExitCode exitCode2 = result3;
            return exitCode2;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    public static /* synthetic */ ExitCode compile$default(IncrementalCompilerRunner incrementalCompilerRunner, List list, CommonCompilerArguments commonCompilerArguments, MessageCollector messageCollector, ChangedFiles changedFiles, FileLocations fileLocations, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: compile");
        }
        if ((n & 0x10) != 0) {
            fileLocations = null;
        }
        return incrementalCompilerRunner.compile(list, commonCompilerArguments, messageCollector, changedFiles, fileLocations);
    }

    private final ICResult incrementalCompilationExceptionTransformer(Throwable t) {
        if (!(t instanceof CachesManagerCloseException)) {
            throw t;
        }
        return new ICResult.Failed(BuildAttribute.IC_FAILED_TO_CLOSE_CACHES, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ICResult tryCompileIncrementally(List<? extends File> allSourceFiles, ChangedFiles changedFiles, Args args, FileLocations fileLocations, MessageCollector messageCollector) {
        Object object;
        Object object2;
        if (changedFiles instanceof ChangedFiles.Unknown) {
            return new ICResult.RequiresRebuild(BuildAttribute.UNKNOWN_CHANGES_IN_GRADLE_INPUTS);
        }
        FragmentContext fragmentContext = !this.icFeatures.getEnableUnsafeIncrementalCompilationForMultiplatform() ? FragmentContext.Companion.fromCompilerArguments((CommonCompilerArguments)args) : null;
        CompilationTransaction $this$runWithin$iv = this.createTransaction();
        boolean $i$f$runWithin = false;
        Object object3 = $this$runWithin$iv;
        try {
            Object object4;
            CompilationTransaction $this$runWithin_u24lambda_u242$iv = object3;
            boolean bl = false;
            AutoCloseable $this$use$iv$iv = $this$runWithin_u24lambda_u242$iv;
            boolean $i$f$use = false;
            boolean closed$iv$iv = false;
            try {
                Object object5;
                CompilationTransaction it$iv = (CompilationTransaction)$this$use$iv$iv;
                boolean bl2 = false;
                try {
                    Object object6;
                    CompilationTransaction transaction = $this$runWithin_u24lambda_u242$iv;
                    boolean bl3 = false;
                    IncrementalCompilationContext icContext = this.createIncrementalCompilationContext(fileLocations, transaction, fragmentContext);
                    CacheManager it = object6 = this.createCacheManager(icContext, args);
                    boolean bl4 = false;
                    transaction.setCachesManager((Closeable)it);
                    CacheManager caches = object6;
                    Object icResult = object6 = IncrementalCompilerRunner.tryCompileIncrementally$lambda$9$compile(this, changedFiles, allSourceFiles, caches, args, icContext, messageCollector);
                    boolean bl5 = false;
                    if (icResult instanceof ICResult.Completed && ((ICResult.Completed)icResult).getExitCode() == ExitCode.OK) {
                        transaction.markAsSuccessful();
                    }
                    object5 = object6;
                }
                catch (Throwable t$iv) {
                    $this$runWithin_u24lambda_u242$iv.setExecutionThrowable(t$iv);
                    throw t$iv;
                }
                object4 = object5;
            }
            catch (Exception e$iv$iv) {
                try {
                    closed$iv$iv = true;
                    try {
                        $this$use$iv$iv.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv$iv) {
                        $this$use$iv$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv$iv.close();
            object2 = Result.constructor-impl(object4);
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = object2;
        object2 = Result.exceptionOrNull-impl((Object)object3);
        if (object2 == null) {
            object = object3;
        } else {
            Object it$iv = object2;
            boolean bl = false;
            Object p0 = it$iv;
            boolean bl6 = false;
            object = Result.constructor-impl((Object)this.incrementalCompilationExceptionTransformer((Throwable)p0));
        }
        object3 = object;
        ResultKt.throwOnFailure((Object)object3);
        return (ICResult)object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExitCode compileNonIncrementally(BuildAttribute rebuildReason, List<? extends File> allSourceFiles, Args args, FileLocations fileLocations, boolean trackChangedFiles, MessageCollector messageCollector) {
        ExitCode exitCode;
        void $this$measure$iv;
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = GradleBuildTime.CLEAR_OUTPUT_ON_REBUILD;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            Collection collection;
            block16: {
                Set mainOutputDirs;
                block15: {
                    Collection collection2;
                    boolean bl = false;
                    Object[] objectArray = new File[]{this.destinationDir(args), this.workingDir};
                    mainOutputDirs = SetsKt.setOf((Object[])objectArray);
                    collection = this.outputDirs;
                    if (collection == null) break block15;
                    Collection it = collection2 = collection;
                    boolean bl2 = false;
                    if (!it.containsAll(mainOutputDirs)) {
                        boolean bl3 = false;
                        String string2 = "outputDirs is missing classesDir and workingDir: " + it;
                        throw new IllegalStateException(string2.toString());
                    }
                    collection = collection2;
                    if (collection != null) break block16;
                }
                collection = mainOutputDirs;
            }
            Collection outputDirsToClean = collection;
            ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)() -> IncrementalCompilerRunner.compileNonIncrementally$lambda$13$lambda$12(outputDirsToClean)));
            this.cleanOrCreateDirectories(outputDirsToClean);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
        IncrementalCompilationContext icContext = IncrementalCompilerRunner.createIncrementalCompilationContext$default(this, fileLocations, new NonRecoverableCompilationTransaction(), null, 4, null);
        Closeable closeable = (Closeable)this.createCacheManager(icContext, args);
        Throwable throwable = null;
        try {
            IncrementalCachesManager caches = (IncrementalCachesManager)closeable;
            boolean bl = false;
            if (trackChangedFiles) {
                caches.getInputsCache().getSourceSnapshotMap$incremental_compilation_impl().compareAndUpdate((Iterable<? extends File>)allSourceFiles);
            }
            AbiSnapshotData abiSnapshotData = this.icFeatures.getWithAbiSnapshot() ? new AbiSnapshotData(new AbiSnapshotImpl(new LinkedHashMap()), this.getClasspathAbiSnapshot(args)) : null;
            exitCode = this.compileImpl(icContext, new CompilationMode.Rebuild(rebuildReason), allSourceFiles, args, caches, abiSnapshotData, messageCollector);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, AbiSnapshot> getClasspathAbiSnapshot(Args args) {
        Map<String, AbiSnapshot> map;
        void $this$measure$iv;
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = GradleBuildTime.SET_UP_ABI_SNAPSHOTS;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            map = this.setupJarDependencies(args, this.reporter);
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
        return map;
    }

    private final void cleanOrCreateDirectories(Collection<? extends File> outputDirs) {
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)outputDirs);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                FileUtilsKt.deleteDirectoryContents(it);
                continue;
            }
            if (it.isFile()) {
                String cfr_ignored_0 = "Expected a directory but found a regular file: " + it.getPath();
                continue;
            }
            FileUtilsKt.createDirectory(it);
        }
    }

    private final ChangedFiles.Known getChangedFiles(ChangedFiles.Known changedFiles, List<? extends File> allSourceFiles, CacheManager caches) {
        ChangedFiles.Known known;
        if (changedFiles == null) {
            known = ((IncrementalCachesManager)caches).getInputsCache().getSourceSnapshotMap$incremental_compilation_impl().compareAndUpdate((Iterable<? extends File>)allSourceFiles);
        } else if (changedFiles.getForDependencies()) {
            ChangedFiles.Known moreChangedFiles = ((IncrementalCachesManager)caches).getInputsCache().getSourceSnapshotMap$incremental_compilation_impl().compareAndUpdate((Iterable<? extends File>)allSourceFiles);
            known = new ChangedFiles.Known(CollectionsKt.plus((Collection)changedFiles.getModified(), (Iterable)moreChangedFiles.getModified()), CollectionsKt.plus((Collection)changedFiles.getRemoved(), (Iterable)moreChangedFiles.getRemoved()), false, 4, null);
        } else {
            known = changedFiles;
        }
        return known;
    }

    @NotNull
    protected abstract CompilationMode calculateSourcesToCompile(@NotNull CacheManager var1, @NotNull ChangedFiles.Known var2, @NotNull Args var3, @NotNull MessageCollector var4, @NotNull Map<String, ? extends AbiSnapshot> var5);

    @NotNull
    protected Map<String, AbiSnapshot> setupJarDependencies(@NotNull Args args, @NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    protected final void initDirtyFiles(@NotNull DirtyFilesContainer dirtyFiles, @NotNull ChangedFiles.Known changedFiles) {
        Intrinsics.checkNotNullParameter((Object)dirtyFiles, (String)"dirtyFiles");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        dirtyFiles.add((Iterable<? extends File>)changedFiles.getModified(), "was modified since last time");
        dirtyFiles.add((Iterable<? extends File>)changedFiles.getRemoved(), "was removed since last time");
        if (this.dirtySourcesSinceLastTimeFile.exists()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = FilesKt.readLines$default((File)this.dirtySourcesSinceLastTimeFile, null, (int)1, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            List files2 = (List)destination$iv$iv;
            dirtyFiles.add(files2, "was not compiled last time");
        }
    }

    protected abstract void updateCaches(@NotNull Services var1, @NotNull CacheManager var2, @NotNull List<? extends GeneratedFile> var3, @NotNull ChangesCollector var4);

    @NotNull
    protected Iterable<File> additionalDirtyFiles(@NotNull CacheManager caches, @NotNull List<? extends GeneratedFile> generatedFiles, @NotNull Services services) {
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected Iterable<LookupSymbol> additionalDirtyLookupSymbols() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected Services.Builder makeServices(@NotNull Args args, @NotNull LookupTracker lookupTracker, @NotNull ExpectActualTracker expectActualTracker, @NotNull CacheManager caches, @NotNull Set<? extends File> dirtySources, boolean isIncremental) {
        Services.Builder builder;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter((Object)expectActualTracker, (String)"expectActualTracker");
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        Intrinsics.checkNotNullParameter(dirtySources, (String)"dirtySources");
        Services.Builder $this$makeServices_u24lambda_u2418 = builder = new Services.Builder();
        boolean bl = false;
        $this$makeServices_u24lambda_u2418.register(LookupTracker.class, lookupTracker);
        $this$makeServices_u24lambda_u2418.register(ExpectActualTracker.class, expectActualTracker);
        $this$makeServices_u24lambda_u2418.register(CompilationCanceledStatus.class, EmptyCompilationCanceledStatus.INSTANCE);
        return builder;
    }

    @NotNull
    protected abstract Pair<ExitCode, Collection<File>> runCompiler(@NotNull List<? extends File> var1, @NotNull Args var2, @NotNull CacheManager var3, @NotNull Services var4, @NotNull MessageCollector var5, @NotNull List<? extends File> var6, boolean var7);

    /*
     * WARNING - void declaration
     */
    private final ExitCode compileImpl(IncrementalCompilationContext icContext, CompilationMode compilationMode, List<? extends File> allSourceFiles, Args args, CacheManager caches, AbiSnapshotData abiSnapshotData, MessageCollector messageCollector) {
        void $this$filterTo$iv$iv;
        this.performWorkBeforeCompilation(compilationMode, args);
        Iterable $this$filter$iv = allSourceFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isKotlinFile(it, (Collection<String>)this.getKotlinSourceFilesExtensions())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allKotlinFiles = (List)destination$iv$iv;
        ExitCode exitCode = this.doCompile(icContext, caches, compilationMode, allKotlinFiles, args, abiSnapshotData, messageCollector);
        this.performWorkAfterCompilation(compilationMode, exitCode, caches);
        return exitCode;
    }

    private final BaseCompilationTransaction createTransaction() {
        BaseCompilationTransaction baseCompilationTransaction;
        if (this.icFeatures.getPreciseCompilationResultsBackup()) {
            Path path = Files.createTempDirectory("kotlin-backups", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
            baseCompilationTransaction = new RecoverableCompilationTransaction(this.reporter, path);
        } else {
            baseCompilationTransaction = new NonRecoverableCompilationTransaction();
        }
        return baseCompilationTransaction;
    }

    protected void performWorkBeforeCompilation(@NotNull CompilationMode compilationMode, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)compilationMode, (String)"compilationMode");
        Intrinsics.checkNotNullParameter(args, (String)"args");
    }

    protected void performWorkAfterCompilation(@NotNull CompilationMode compilationMode, @NotNull ExitCode exitCode, @NotNull CacheManager caches) {
        Intrinsics.checkNotNullParameter((Object)compilationMode, (String)"compilationMode");
        Intrinsics.checkNotNullParameter((Object)((Object)exitCode), (String)"exitCode");
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void collectSizeMetrics() {
        void $this$measure$iv;
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = GradleBuildTime.CALCULATE_OUTPUT_SIZE;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            long l;
            boolean bl = false;
            File file2 = this.buildHistoryFile;
            this.reporter.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.SNAPSHOT_SIZE), (file2 != null ? file2.length() : 0L) + this.lastBuildInfoFile.length() + this.abiSnapshotFile.length());
            Sequence sequence2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)this.cacheDirectory, null, (int)1, null)), IncrementalCompilerRunner::collectSizeMetrics$lambda$22$lambda$20);
            BuildPerformanceMetric buildPerformanceMetric = GradleBuildPerformanceMetric.CACHE_DIRECTORY_SIZE;
            BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter = this.reporter;
            long l2 = 0L;
            for (Object e : sequence2) {
                void it;
                File file3 = (File)e;
                l = l2;
                boolean bl2 = false;
                long l3 = it.length();
                l2 = l + l3;
            }
            l = l2;
            buildReporter.addMetric((GradleBuildPerformanceMetric)buildPerformanceMetric, l);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExitCode doCompile(IncrementalCompilationContext icContext, CacheManager caches, CompilationMode compilationMode, List<? extends File> allKotlinSources, Args args, AbiSnapshotData abiSnapshotData, MessageCollector originalMessageCollector) {
        Object complementaryFiles;
        Object jvmMetadataVersionFromLanguageVersion;
        LinkedHashSet<File> linkedHashSet;
        CompilationMode compilationMode2 = compilationMode;
        if (compilationMode2 instanceof CompilationMode.Incremental) {
            linkedHashSet = ((CompilationMode.Incremental)compilationMode).getDirtyFiles().toMutableLinkedSet();
        } else if (compilationMode2 instanceof CompilationMode.Rebuild) {
            linkedHashSet = new LinkedHashSet<File>((Collection)allKotlinSources);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LinkedHashSet<File> dirtySources = linkedHashSet;
        long l = System.currentTimeMillis();
        Object object = abiSnapshotData;
        if (object == null || (object = ((AbiSnapshotData)object).getClasspathAbiSnapshot()) == null) {
            object = MapsKt.emptyMap();
        }
        BuildInfo currentBuildInfo = new BuildInfo(l, (Map<String, ? extends AbiSnapshot>)object);
        HashSet<LookupSymbol> buildDirtyLookupSymbols = new HashSet<LookupSymbol>();
        HashSet<FqName> buildDirtyFqNames = new HashSet<FqName>();
        HashSet allDirtySources = new HashSet();
        CompilationTransaction transaction = icContext.getTransaction();
        ExitCode exitCode = null;
        exitCode = ExitCode.OK;
        Object object2 = LanguageVersion.Companion.fromVersionString(((CommonCompilerArguments)args).getLanguageVersion());
        if (object2 == null || (object2 = MetadataHelpersKt.toMetadataVersion((LanguageVersion)object2)) == null) {
            object2 = jvmMetadataVersionFromLanguageVersion = JvmMetadataVersion.INSTANCE;
        }
        while (CollectionsKt.any((Iterable)dirtySources) || this.runWithNoDirtyKotlinSources(caches)) {
            void $this$measure$iv;
            Object element$iv;
            Object additionalDirtyFiles;
            Iterator it;
            void $this$mapTo$iv$iv;
            Pair<ExitCode, Collection<File>> pair;
            void $this$measure$iv2;
            complementaryFiles = ((AbstractIncrementalCache)((IncrementalCachesManager)caches).getPlatformCache()).getComplementaryFilesRecursive((Collection<File>)dirtySources);
            dirtySources.addAll((Collection<File>)complementaryFiles);
            ((AbstractIncrementalCache)((IncrementalCachesManager)caches).getPlatformCache()).markDirty((Collection)dirtySources);
            ((IncrementalCachesManager)caches).getInputsCache().removeOutputForSourceFiles((Iterable<? extends File>)dirtySources);
            LookupTrackerImpl lookupTracker = new LookupTrackerImpl(this.getLookupTrackerDelegate());
            ExpectActualTrackerImpl expectActualTracker = new ExpectActualTrackerImpl();
            Iterable $this$partition$iv = dirtySources;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                File it2 = (File)element$iv2;
                boolean bl = false;
                if (it2.exists() && allKotlinSources.contains(it2)) {
                    first$iv.add(element$iv2);
                    continue;
                }
                second$iv.add(element$iv2);
            }
            Pair pair2 = new Pair(first$iv, second$iv);
            List sourcesToCompile = (List)pair2.component1();
            List removedKotlinSources = (List)pair2.component2();
            if (icContext.getFragmentContext() != null) {
                FragmentContext it3;
                boolean bl = false;
                if (it3.dirtySetTouchesNonLeafFragments(sourcesToCompile)) {
                    throw new RequireRebuildForCorrectnessInKMPException();
                }
            }
            Services services = this.makeServices(args, lookupTracker, expectActualTracker, caches, CollectionsKt.toSet((Iterable)dirtySources), compilationMode instanceof CompilationMode.Incremental).build();
            ((CommonCompilerArguments)args).setReportOutputFiles(true);
            OutputItemsCollectorImpl outputItemsCollector = new OutputItemsCollectorImpl();
            TransactionOutputsRegistrar transactionOutputsRegistrar = new TransactionOutputsRegistrar(transaction, outputItemsCollector);
            BufferingMessageCollector bufferingMessageCollector = new BufferingMessageCollector();
            MessageCollectorToOutputItemsCollectorAdapter messageCollectorAdapter = new MessageCollectorToOutputItemsCollectorAdapter(bufferingMessageCollector, transactionOutputsRegistrar);
            BuildMetricsReporter buildMetricsReporter = this.reporter;
            Pair<ExitCode, Collection<File>> time$iv = (Pair<ExitCode, Collection<File>>)GradleBuildTime.COMPILATION_ROUND;
            boolean $i$f$measure = false;
            $this$measure$iv2.startMeasure(time$iv);
            try {
                boolean bl = false;
                pair = this.runCompiler(sourcesToCompile, args, caches, services, messageCollectorAdapter, allKotlinSources, compilationMode instanceof CompilationMode.Incremental);
            }
            finally {
                $this$measure$iv2.endMeasure(time$iv);
            }
            time$iv = pair;
            boolean bl = false;
            ExitCode ec = (ExitCode)((Object)time$iv.component1());
            Iterable compiled = (Collection)time$iv.component2();
            exitCode = ec;
            Collection compiledSources = compiled;
            dirtySources.addAll(compiledSources);
            allDirtySources.addAll(dirtySources);
            Iterable iterable = allDirtySources;
            String string2 = System.getProperty("line.separator");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            String text = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, IncrementalCompilerRunner::doCompile$lambda$27, (int)30, null);
            Path path = this.dirtySourcesSinceLastTimeFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            CompilationTransactionKt.writeText(transaction, path, text);
            List<SimpleOutputItem> list = outputItemsCollector.getOutputs();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getOutputs(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            compiled = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SimpleOutputItem simpleOutputItem = (SimpleOutputItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(SimpleOutputItemKt.toGeneratedFile((SimpleOutputItem)((Object)it), (JvmMetadataVersion)jvmMetadataVersionFromLanguageVersion));
            }
            List generatedFiles = (List)destination$iv$iv;
            if (compilationMode instanceof CompilationMode.Incremental) {
                Iterator $this$filterTo$iv$iv;
                HashSet dirtySourcesSet = CollectionsKt.toHashSet((Iterable)dirtySources);
                Iterable<File> $this$filter$iv = this.additionalDirtyFiles(caches, generatedFiles, services);
                boolean $i$f$filter = false;
                Iterable<File> $i$f$mapTo2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                it = $this$filterTo$iv$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv$iv = it.next();
                    File it4 = (File)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!dirtySourcesSet.contains(it4))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                additionalDirtyFiles = (List)destination$iv$iv2;
                if (!((Collection)additionalDirtyFiles).isEmpty()) {
                    dirtySources.addAll((Collection)additionalDirtyFiles);
                    Iterable $this$forEach$iv = generatedFiles;
                    boolean $i$f$forEach = false;
                    $this$filterTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$filterTo$iv$iv.hasNext()) {
                        element$iv = $this$filterTo$iv$iv.next();
                        GeneratedFile it5 = (GeneratedFile)element$iv;
                        boolean bl4 = false;
                        Path path2 = it5.getOutputFile().toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                        transaction.deleteFile(path2);
                    }
                    continue;
                }
            }
            this.reporter.reportCompileIteration(compilationMode instanceof CompilationMode.Incremental, compiledSources, exitCode);
            bufferingMessageCollector.flush(originalMessageCollector);
            if (exitCode != ExitCode.OK) break;
            Path path3 = this.dirtySourcesSinceLastTimeFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
            transaction.deleteFile(path3);
            ChangesCollector changesCollector = new ChangesCollector();
            additionalDirtyFiles = this.reporter;
            BuildTime time$iv2 = GradleBuildTime.IC_UPDATE_CACHES;
            boolean $i$f$measure2 = false;
            $this$measure$iv.startMeasure(time$iv2);
            try {
                boolean bl5 = false;
                ((AbstractIncrementalCache)((IncrementalCachesManager)caches).getPlatformCache()).updateComplementaryFiles((Collection<File>)dirtySources, expectActualTracker);
                ((IncrementalCachesManager)caches).getInputsCache().registerOutputForSourceFiles(generatedFiles);
                BuildUtilKt.update(((IncrementalCachesManager)caches).getLookupCache(), lookupTracker, sourcesToCompile, removedKotlinSources);
                this.updateCaches(services, caches, generatedFiles, changesCollector);
                element$iv = Unit.INSTANCE;
            }
            finally {
                $this$measure$iv.endMeasure(time$iv2);
            }
            if (compilationMode instanceof CompilationMode.Rebuild) {
                if (!this.icFeatures.getWithAbiSnapshot()) break;
                AbiSnapshotData abiSnapshotData2 = abiSnapshotData;
                Intrinsics.checkNotNull((Object)abiSnapshotData2);
                abiSnapshotData2.getSnapshot().getProtos().putAll(changesCollector.protoDataChanges());
                break;
            }
            DirtyData dirtyData = BuildUtilKt.getChangedAndImpactedSymbols(changesCollector, (Iterable<? extends IncrementalCacheCommon>)CollectionsKt.listOf(((IncrementalCachesManager)caches).getPlatformCache()), (ICReporter)this.reporter);
            Collection<LookupSymbol> dirtyLookupSymbols = dirtyData.component1();
            Collection<FqName> dirtyClassFqNames = dirtyData.component2();
            Collection<FqName> forceRecompile = dirtyData.component3();
            HashSet compiledInThisIterationSet = CollectionsKt.toHashSet((Iterable)sourcesToCompile);
            Set forceToRecompileFiles = BuildUtilKt.mapClassesFqNamesToFiles$default(CollectionsKt.listOf(((IncrementalCachesManager)caches).getPlatformCache()), forceRecompile, this.reporter, null, 8, null);
            LinkedHashSet<File> $this$doCompile_u24lambda_u2432 = dirtySources;
            boolean bl6 = false;
            $this$doCompile_u24lambda_u2432.clear();
            $this$doCompile_u24lambda_u2432.addAll((Collection)BuildUtilKt.mapLookupSymbolsToFiles(((IncrementalCachesManager)caches).getLookupCache(), (Iterable<LookupSymbol>)dirtyLookupSymbols, this.reporter, compiledInThisIterationSet));
            $this$doCompile_u24lambda_u2432.addAll((Collection)BuildUtilKt.mapClassesFqNamesToFiles(CollectionsKt.listOf(((IncrementalCachesManager)caches).getPlatformCache()), (Iterable<FqName>)dirtyClassFqNames, this.reporter, compiledInThisIterationSet));
            if (!compiledInThisIterationSet.containsAll(forceToRecompileFiles)) {
                $this$doCompile_u24lambda_u2432.addAll(forceToRecompileFiles);
            }
            buildDirtyLookupSymbols.addAll(dirtyLookupSymbols);
            buildDirtyFqNames.addAll(dirtyClassFqNames);
            if (!this.icFeatures.getWithAbiSnapshot()) continue;
            Iterable $this$forEach$iv = changesCollector.protoDataRemoved();
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                FqName it6 = (FqName)element$iv3;
                boolean bl7 = false;
                AbiSnapshotData abiSnapshotData3 = abiSnapshotData;
                Intrinsics.checkNotNull((Object)abiSnapshotData3);
                abiSnapshotData3.getSnapshot().getProtos().remove(it6);
            }
            AbiSnapshotData abiSnapshotData4 = abiSnapshotData;
            Intrinsics.checkNotNull((Object)abiSnapshotData4);
            abiSnapshotData4.getSnapshot().getProtos().putAll(changesCollector.protoDataChanges());
        }
        if (exitCode == ExitCode.OK) {
            void $this$measure$iv;
            complementaryFiles = this.reporter;
            BuildTime time$iv = GradleBuildTime.STORE_BUILD_INFO;
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv);
            try {
                boolean bl = false;
                BuildInfo.Companion.write(icContext, currentBuildInfo, this.lastBuildInfoFile);
                if (this.icFeatures.getWithAbiSnapshot()) {
                    AbiSnapshotData abiSnapshotData5 = abiSnapshotData;
                    Intrinsics.checkNotNull((Object)abiSnapshotData5);
                    AbiSnapshotImpl.Companion.write(icContext, abiSnapshotData5.getSnapshot(), this.abiSnapshotFile);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$measure$iv.endMeasure(time$iv);
            }
        }
        if (exitCode == ExitCode.OK && compilationMode instanceof CompilationMode.Incremental) {
            CollectionsKt.addAll((Collection)buildDirtyLookupSymbols, this.additionalDirtyLookupSymbols());
        }
        DirtyData dirtyData = new DirtyData(buildDirtyLookupSymbols, buildDirtyFqNames, null, 4, null);
        this.processChangesAfterBuild(icContext, compilationMode, currentBuildInfo, dirtyData);
        return exitCode;
    }

    @NotNull
    public LookupTracker getLookupTrackerDelegate() {
        return LookupTracker.DO_NOTHING.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final DirtyData getRemovedClassesChanges(@NotNull IncrementalCachesManager<?> caches, @NotNull ChangedFiles.Known changedFiles) {
        void $this$mapTo$iv$iv;
        Iterator $this$map$iv;
        Object element$iv3;
        void $this$filterTo$iv;
        void $this$filterTo$iv2;
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        HashSet<String> removedClasses = new HashSet<String>();
        Iterable iterable = changedFiles.getModified();
        Iterable destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv2 : $this$filterTo$iv2) {
            File it = (File)element$iv2;
            boolean bl = false;
            if (!FileUtilsKt.isKotlinFile(it, (Collection<String>)this.getKotlinSourceFilesExtensions())) continue;
            destination$iv.add(element$iv2);
        }
        HashSet dirtyFiles = (HashSet)destination$iv;
        destination$iv = changedFiles.getRemoved();
        Collection destination$iv2 = new HashSet();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            File it = (File)element$iv3;
            boolean bl = false;
            if (!FileUtilsKt.isKotlinFile(it, (Collection<String>)this.getKotlinSourceFilesExtensions())) continue;
            destination$iv2.add(element$iv3);
        }
        HashSet removedFiles = (HashSet)destination$iv2;
        Set<String> existingClasses = ParseFileUtilsKt.classesFqNames(dirtyFiles);
        Iterable $i$f$filterTo22 = ((AbstractIncrementalCache)caches.getPlatformCache()).classesFqNamesBySources(SetsKt.plus((Set)dirtyFiles, (Iterable)removedFiles));
        boolean $i$f$map = false;
        element$iv3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        List previousClasses = (List)destination$iv$iv;
        for (Object e : previousClasses) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String fqName = (String)e;
            if (existingClasses.contains(fqName)) continue;
            removedClasses.add(fqName);
        }
        ChangesCollector changesCollector = new ChangesCollector();
        Iterable $this$forEach$iv = removedClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv4 : $this$forEach$iv) {
            String it = (String)element$iv4;
            boolean bl = false;
            changesCollector.collectSignature(new FqName(it), true);
        }
        return BuildUtilKt.getChangedAndImpactedSymbols(changesCollector, (Iterable<? extends IncrementalCacheCommon>)CollectionsKt.listOf(caches.getPlatformCache()), (ICReporter)this.reporter);
    }

    public boolean runWithNoDirtyKotlinSources(@NotNull CacheManager caches) {
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void processChangesAfterBuild(IncrementalCompilationContext icContext, CompilationMode compilationMode, BuildInfo currentBuildInfo, DirtyData dirtyData) {
        void $this$measure$iv;
        if (this.buildHistoryFile == null) {
            return;
        }
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = GradleBuildTime.IC_WRITE_HISTORY_FILE;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            BuildDifference buildDifference;
            Object prevDiffs;
            boolean bl = false;
            Object object = BuildDiffsStorage.Companion.readFromFile(this.buildHistoryFile, this.reporter);
            if (object == null || (object = ((BuildDiffsStorage)object).getBuildDiffs()) == null) {
                object = prevDiffs = CollectionsKt.emptyList();
            }
            if (compilationMode instanceof CompilationMode.Incremental) {
                buildDifference = new BuildDifference(currentBuildInfo.getStartTS(), true, dirtyData);
            } else {
                DirtyData emptyDirtyData = new DirtyData(null, null, null, 7, null);
                buildDifference = new BuildDifference(currentBuildInfo.getStartTS(), false, emptyDirtyData);
            }
            BuildDifference newDiff = buildDifference;
            BuildDiffsStorage.Companion.writeToFile(icContext, this.buildHistoryFile, new BuildDiffsStorage(CollectionsKt.plus((Collection)((Collection)prevDiffs), (Object)newDiff)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    protected final void reportPerformanceData(@NotNull CommonCompilerPerformanceManager defaultPerformanceManager) {
        Intrinsics.checkNotNullParameter((Object)defaultPerformanceManager, (String)"defaultPerformanceManager");
        Iterable $this$forEach$iv = defaultPerformanceManager.getMeasurementResults();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Integer n;
            PerformanceMeasurement it = (PerformanceMeasurement)element$iv;
            boolean bl = false;
            PerformanceMeasurement performanceMeasurement = it;
            if (performanceMeasurement instanceof CompilerInitializationMeasurement) {
                this.reporter.addTimeMetricMs((GradleBuildTime)((BuildTime)GradleBuildTime.COMPILER_INITIALIZATION), ((CompilerInitializationMeasurement)it).getMilliseconds());
                continue;
            }
            if (performanceMeasurement instanceof CodeAnalysisMeasurement) {
                this.reporter.addTimeMetricMs((GradleBuildTime)((BuildTime)GradleBuildTime.CODE_ANALYSIS), ((CodeAnalysisMeasurement)it).getMilliseconds());
                if (((CodeAnalysisMeasurement)it).getLines() != null) {
                    int $this$reportPerformanceData_u24lambda_u2442_u24lambda_u2440 = ((Number)n).intValue();
                    boolean bl2 = false;
                    this.reporter.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.ANALYZED_LINES_NUMBER), $this$reportPerformanceData_u24lambda_u2442_u24lambda_u2440);
                    if (((CodeAnalysisMeasurement)it).getMilliseconds() <= 0L) continue;
                    this.reporter.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.ANALYSIS_LPS), (long)($this$reportPerformanceData_u24lambda_u2442_u24lambda_u2440 * 1000) / ((CodeAnalysisMeasurement)it).getMilliseconds());
                }
                continue;
            }
            if (performanceMeasurement instanceof CodeGenerationMeasurement) {
                this.reporter.addTimeMetricMs((GradleBuildTime)((BuildTime)GradleBuildTime.CODE_GENERATION), ((CodeGenerationMeasurement)it).getMilliseconds());
                if (((CodeGenerationMeasurement)it).getLines() != null) {
                    int $this$reportPerformanceData_u24lambda_u2442_u24lambda_u2441 = ((Number)n).intValue();
                    boolean bl3 = false;
                    this.reporter.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.CODE_GENERATED_LINES_NUMBER), $this$reportPerformanceData_u24lambda_u2442_u24lambda_u2441);
                    if (((CodeGenerationMeasurement)it).getMilliseconds() <= 0L) continue;
                    this.reporter.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.CODE_GENERATION_LPS), (long)($this$reportPerformanceData_u24lambda_u2442_u24lambda_u2441 * 1000) / ((CodeGenerationMeasurement)it).getMilliseconds());
                }
                continue;
            }
            if (!(performanceMeasurement instanceof IRMeasurement)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[((IRMeasurement)it).getKind().ordinal()]) {
                case 1: {
                    this.reportIrMeasurements((IRMeasurement)it, GradleBuildTime.IR_TRANSLATION, GradleBuildPerformanceMetric.IR_TRANSLATION_LINES_NUMBER);
                    break;
                }
                case 2: {
                    this.reportIrMeasurements((IRMeasurement)it, GradleBuildTime.IR_LOWERING, GradleBuildPerformanceMetric.IR_LOWERING_LINES_NUMBER);
                    break;
                }
                case 3: {
                    this.reportIrMeasurements((IRMeasurement)it, GradleBuildTime.IR_GENERATION, GradleBuildPerformanceMetric.IR_GENERATION_LINES_NUMBER);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void reportIrMeasurements(IRMeasurement it, GradleBuildTime timeMetric, GradleBuildPerformanceMetric lineMetric) {
        block0: {
            this.reporter.addTimeMetricMs((GradleBuildTime)((BuildTime)timeMetric), it.getMilliseconds());
            Integer n = it.getLines();
            if (n == null) break block0;
            Integer n2 = n;
            int it2 = ((Number)n2).intValue();
            boolean bl = false;
            this.reporter.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)lineMetric), it2);
        }
    }

    private static final String compile$lambda$3$lambda$0() {
        return "Incremental compilation completed";
    }

    private static final String compile$lambda$3$lambda$1(ICResult $result) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        return "Non-incremental compilation will be performed: " + ((ICResult.RequiresRebuild)$result).getReason();
    }

    private static final String compile$lambda$3$lambda$2(ICResult $result) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        return StringsKt.trimMargin$default((String)("\n                    |Incremental compilation was attempted but failed:\n                    |    " + ((ICResult.Failed)$result).getReason().getReadableString() + ": " + UtilKt.removeSuffixIfPresent(ExceptionsKt.stackTraceToString((Throwable)((ICResult.Failed)$result).getCause()), "\n") + "\n                    |    Falling back to non-incremental compilation (reason = " + ((ICResult.Failed)$result).getReason() + ")\n                    |    To help us fix this issue, please file a bug at https://youtrack.jetbrains.com/issues/KT with the above stack trace.\n                    |    (Be sure to search for the above exception in existing issues first to avoid filing duplicated bugs.)             \n                    "), null, (int)1, null);
    }

    private static final String tryCompileIncrementally$lambda$9$compile$lambda$6(IncrementalCompilerRunner this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Jar snapshot file does not exist: " + this$0.abiSnapshotFile.getPath();
    }

    private static final String tryCompileIncrementally$lambda$9$compile$lambda$7() {
        return "Incremental compilation with ABI snapshot enabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <Args extends CommonCompilerArguments, CacheManager extends IncrementalCachesManager<?>> ICResult tryCompileIncrementally$lambda$9$compile(IncrementalCompilerRunner<Args, CacheManager> this$0, ChangedFiles $changedFiles, List<? extends File> $allSourceFiles, CacheManager caches, Args $args, IncrementalCompilationContext icContext, MessageCollector $messageCollector) {
        ExitCode exitCode;
        AbiSnapshotData abiSnapshotData;
        CompilationMode $this$measure$iv;
        ChangedFiles.Known known;
        try {
            known = super.getChangedFiles((ChangedFiles.Known)$changedFiles, $allSourceFiles, caches);
        }
        catch (Throwable e) {
            return new ICResult.Failed(BuildAttribute.IC_FAILED_TO_GET_CHANGED_FILES, e);
        }
        ChangedFiles.Known knownChangedFiles = known;
        Map classpathAbiSnapshot = this$0.icFeatures.getWithAbiSnapshot() ? super.getClasspathAbiSnapshot($args) : null;
        try {
            CompilationMode compilationMode;
            BuildMetricsReporter buildMetricsReporter = this$0.reporter;
            BuildTime time$iv = GradleBuildTime.IC_CALCULATE_INITIAL_DIRTY_SET;
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv);
            try {
                boolean bl = false;
                Map map = classpathAbiSnapshot;
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                compilationMode = this$0.calculateSourcesToCompile(caches, knownChangedFiles, $args, $messageCollector, map);
            }
            finally {
                $this$measure$iv.endMeasure(time$iv);
            }
            $this$measure$iv = compilationMode;
        }
        catch (Throwable e) {
            return new ICResult.Failed(BuildAttribute.IC_FAILED_TO_COMPUTE_FILES_TO_RECOMPILE, e);
        }
        CompilationMode compilationMode = $this$measure$iv;
        if (compilationMode instanceof CompilationMode.Rebuild) {
            return new ICResult.RequiresRebuild(((CompilationMode.Rebuild)compilationMode).getReason());
        }
        if (this$0.icFeatures.getWithAbiSnapshot()) {
            if (!this$0.abiSnapshotFile.exists()) {
                ICReporterKt.debug(this$0.reporter, (Function0<String>)((Function0)() -> IncrementalCompilerRunner.tryCompileIncrementally$lambda$9$compile$lambda$6(this$0)));
                return new ICResult.RequiresRebuild(BuildAttribute.NO_ABI_SNAPSHOT);
            }
            ICReporterKt.info(this$0.reporter, (Function0<String>)((Function0)IncrementalCompilerRunner::tryCompileIncrementally$lambda$9$compile$lambda$7));
            AbiSnapshot abiSnapshot2 = AbiSnapshotImpl.Companion.read(this$0.abiSnapshotFile);
            Map map = classpathAbiSnapshot;
            Intrinsics.checkNotNull((Object)map);
            abiSnapshotData = new AbiSnapshotData(abiSnapshot2, map);
        } else {
            abiSnapshotData = null;
        }
        AbiSnapshotData abiSnapshotData2 = abiSnapshotData;
        try {
            Intrinsics.checkNotNull((Object)compilationMode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.IncrementalCompilerRunner.CompilationMode.Incremental");
            exitCode = super.compileImpl(icContext, (CompilationMode.Incremental)compilationMode, $allSourceFiles, $args, caches, abiSnapshotData2, $messageCollector);
        }
        catch (RequireRebuildForCorrectnessInKMPException e) {
            return new ICResult.RequiresRebuild(BuildAttribute.UNSAFE_INCREMENTAL_CHANGE_KT_62686);
        }
        catch (Throwable e) {
            return new ICResult.Failed(BuildAttribute.IC_FAILED_TO_COMPILE_INCREMENTALLY, e);
        }
        ExitCode exitCode2 = exitCode;
        return new ICResult.Completed(exitCode2);
    }

    private static final String compileNonIncrementally$lambda$13$lambda$12(Collection $outputDirsToClean) {
        Intrinsics.checkNotNullParameter((Object)$outputDirsToClean, (String)"$outputDirsToClean");
        return "Cleaning " + $outputDirsToClean.size() + " output directories";
    }

    private static final boolean collectSizeMetrics$lambda$22$lambda$20(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final CharSequence doCompile$lambda$27(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = FilesKt.normalize((File)it).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$AbiSnapshotData;", "", "snapshot", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "classpathAbiSnapshot", "", "", "<init>", "(Lorg/jetbrains/kotlin/incremental/AbiSnapshot;Ljava/util/Map;)V", "getSnapshot", "()Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "getClasspathAbiSnapshot", "()Ljava/util/Map;", "incremental-compilation-impl"})
    private static final class AbiSnapshotData {
        @NotNull
        private final AbiSnapshot snapshot;
        @NotNull
        private final Map<String, AbiSnapshot> classpathAbiSnapshot;

        public AbiSnapshotData(@NotNull AbiSnapshot snapshot2, @NotNull Map<String, ? extends AbiSnapshot> classpathAbiSnapshot) {
            Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
            Intrinsics.checkNotNullParameter(classpathAbiSnapshot, (String)"classpathAbiSnapshot");
            this.snapshot = snapshot2;
            this.classpathAbiSnapshot = classpathAbiSnapshot;
        }

        @NotNull
        public final AbiSnapshot getSnapshot() {
            return this.snapshot;
        }

        @NotNull
        public final Map<String, AbiSnapshot> getClasspathAbiSnapshot() {
            return this.classpathAbiSnapshot;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$Companion;", "", "<init>", "()V", "DIRTY_SOURCES_FILE_NAME", "", "LAST_BUILD_INFO_FILE_NAME", "ABI_SNAPSHOT_FILE_NAME", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "", "<init>", "()V", "Incremental", "Rebuild", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode$Incremental;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode$Rebuild;", "incremental-compilation-impl"})
    protected static abstract class CompilationMode {
        private CompilationMode() {
        }

        public /* synthetic */ CompilationMode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode$Incremental;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "dirtyFiles", "Lorg/jetbrains/kotlin/incremental/DirtyFilesContainer;", "<init>", "(Lorg/jetbrains/kotlin/incremental/DirtyFilesContainer;)V", "getDirtyFiles", "()Lorg/jetbrains/kotlin/incremental/DirtyFilesContainer;", "incremental-compilation-impl"})
        public static final class Incremental
        extends CompilationMode {
            @NotNull
            private final DirtyFilesContainer dirtyFiles;

            public Incremental(@NotNull DirtyFilesContainer dirtyFiles) {
                Intrinsics.checkNotNullParameter((Object)dirtyFiles, (String)"dirtyFiles");
                super(null);
                this.dirtyFiles = dirtyFiles;
            }

            @NotNull
            public final DirtyFilesContainer getDirtyFiles() {
                return this.dirtyFiles;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode$Rebuild;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "reason", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "<init>", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;)V", "getReason", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "incremental-compilation-impl"})
        public static final class Rebuild
        extends CompilationMode {
            @NotNull
            private final BuildAttribute reason;

            public Rebuild(@NotNull BuildAttribute reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final BuildAttribute getReason() {
                return this.reason;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$EmptyCompilationCanceledStatus;", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "<init>", "()V", "checkCanceled", "", "incremental-compilation-impl"})
    private static final class EmptyCompilationCanceledStatus
    implements CompilationCanceledStatus {
        @NotNull
        public static final EmptyCompilationCanceledStatus INSTANCE = new EmptyCompilationCanceledStatus();

        private EmptyCompilationCanceledStatus() {
        }

        @Override
        public void checkCanceled() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult;", "", "Completed", "RequiresRebuild", "Failed", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult$Completed;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult$Failed;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult$RequiresRebuild;", "incremental-compilation-impl"})
    private static interface ICResult {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult$Completed;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult;", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/ExitCode;)V", "getExitCode", "()Lorg/jetbrains/kotlin/cli/common/ExitCode;", "incremental-compilation-impl"})
        public static final class Completed
        implements ICResult {
            @NotNull
            private final ExitCode exitCode;

            public Completed(@NotNull ExitCode exitCode) {
                Intrinsics.checkNotNullParameter((Object)((Object)exitCode), (String)"exitCode");
                this.exitCode = exitCode;
            }

            @NotNull
            public final ExitCode getExitCode() {
                return this.exitCode;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult$Failed;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult;", "reason", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "cause", "", "<init>", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;Ljava/lang/Throwable;)V", "getReason", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "getCause", "()Ljava/lang/Throwable;", "incremental-compilation-impl"})
        public static final class Failed
        implements ICResult {
            @NotNull
            private final BuildAttribute reason;
            @NotNull
            private final Throwable cause;

            public Failed(@NotNull BuildAttribute reason, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.reason = reason;
                this.cause = cause;
            }

            @NotNull
            public final BuildAttribute getReason() {
                return this.reason;
            }

            @NotNull
            public final Throwable getCause() {
                return this.cause;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult$RequiresRebuild;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$ICResult;", "reason", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "<init>", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;)V", "getReason", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "incremental-compilation-impl"})
        public static final class RequiresRebuild
        implements ICResult {
            @NotNull
            private final BuildAttribute reason;

            public RequiresRebuild(@NotNull BuildAttribute reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.reason = reason;
            }

            @NotNull
            public final BuildAttribute getReason() {
                return this.reason;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IRMeasurement.Kind.values().length];
            try {
                nArray[IRMeasurement.Kind.TRANSLATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IRMeasurement.Kind.LOWERING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IRMeasurement.Kind.GENERATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

