/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.mpp.ActualTypealiasToSpecialAnnotationUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypealiasToSpecialAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirActualTypealiasToSpecialAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualTypealiasToSpecialAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypealiasToSpecialAnnotationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,36:1\n33#2:37\n*S KotlinDebug\n*F\n+ 1 FirActualTypealiasToSpecialAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypealiasToSpecialAnnotationChecker\n*L\n25#1:37\n*E\n"})
public final class FirActualTypealiasToSpecialAnnotationChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirActualTypealiasToSpecialAnnotationChecker INSTANCE = new FirActualTypealiasToSpecialAnnotationChecker();

    private FirActualTypealiasToSpecialAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        FirMemberDeclaration $this$isActual$iv = declaration;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        Object object = FirDeclarationUtilKt.getExpandedConeType(declaration);
        if (object == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeType)object, context.getSession())) == null) {
            return;
        }
        Object typealiasedClassSymbol = object;
        if (FirHelpersKt.getClassKind(typealiasedClassSymbol) != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        ClassId classId = ((FirClassLikeSymbol)typealiasedClassSymbol).getClassId();
        if (ActualTypealiasToSpecialAnnotationUtils.INSTANCE.isAnnotationProhibitedInActualTypeAlias(classId)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getACTUAL_TYPEALIAS_TO_SPECIAL_ANNOTATION(), (Object)classId, (DiagnosticContext)context, null, 16, null);
        }
    }
}

