/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0011\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0014J\u0006\u0010\u0015\u001a\u00020\fJ(\u0010\u0016\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bJ'\u0010\u001c\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\n\u0010 \u001a\u00060!R\u00020\"H\u0000\u00a2\u0006\u0002\b#J'\u0010$\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\n\u0010 \u001a\u00060!R\u00020\"H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Ljava/lang/StringBuilder;)V", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "lineBeginning", "", "print", "", "objects", "", "([Ljava/lang/Object;)V", "println", "pushIndent", "pushIndent$tree", "popIndent", "popIndent$tree", "newLine", "renderInBraces", "leftBrace", "", "rightBrace", "f", "Lkotlin/Function0;", "renderSeparated", "elements", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitor", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer;", "renderSeparated$tree", "renderSeparatedWithNewlines", "renderSeparatedWithNewlines$tree", "toString", "tree"})
public class FirPrinter {
    @NotNull
    private final Printer printer;
    private boolean lineBeginning;

    public FirPrinter(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.printer = new Printer(builder, 0, null, 6, null);
        this.lineBeginning = true;
    }

    public final void print(Object ... objects) {
        Printer printer;
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        if (this.lineBeginning) {
            this.lineBeginning = false;
            printer = this.printer.print(Arrays.copyOf(objects, objects.length));
        } else {
            printer = this.printer.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        }
    }

    public final void println(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.print(Arrays.copyOf(objects, objects.length));
        this.printer.printlnWithNoIndent(new Object[0]);
        this.lineBeginning = true;
    }

    public final void pushIndent$tree() {
        this.printer.pushIndent();
    }

    public final void popIndent$tree() {
        this.printer.popIndent();
    }

    public final void newLine() {
        this.println(new Object[0]);
    }

    public final void renderInBraces(@NotNull String leftBrace, @NotNull String rightBrace, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter((Object)leftBrace, (String)"leftBrace");
        Intrinsics.checkNotNullParameter((Object)rightBrace, (String)"rightBrace");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Object[] objectArray = new Object[]{' ' + leftBrace};
        this.println(objectArray);
        this.pushIndent$tree();
        f.invoke();
        this.popIndent$tree();
        objectArray = new Object[]{rightBrace};
        this.println(objectArray);
    }

    public static /* synthetic */ void renderInBraces$default(FirPrinter firPrinter, String string2, String string3, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderInBraces");
        }
        if ((n & 1) != 0) {
            string2 = "{";
        }
        if ((n & 2) != 0) {
            string3 = "}";
        }
        firPrinter.renderInBraces(string2, string3, (Function0<Unit>)function0);
    }

    public final void renderSeparated$tree(@NotNull List<? extends FirElement> elements, @NotNull FirRenderer.Visitor visitor2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Iterator iterator2 = ((Iterable)elements).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            FirElement element = (FirElement)iterator2.next();
            if (index > 0) {
                Object[] objectArray = new Object[]{", "};
                this.print(objectArray);
            }
            element.accept(visitor2);
        }
    }

    public final void renderSeparatedWithNewlines$tree(@NotNull List<? extends FirElement> elements, @NotNull FirRenderer.Visitor visitor2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Iterator iterator2 = ((Iterable)elements).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            FirElement element = (FirElement)iterator2.next();
            if (index > 0) {
                Object[] objectArray = new Object[]{","};
                this.print(objectArray);
                this.newLine();
            }
            element.accept(visitor2);
        }
    }

    @NotNull
    public String toString() {
        return this.printer.toString();
    }
}

