/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.coroutine.CoroutineMetadataPropertiesKt;
import org.jetbrains.kotlin.js.inline.clean.CoroutineStateElimination;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/CoroutineStateElimination;", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "apply", "", "js.translator"})
public final class CoroutineStateElimination {
    @NotNull
    private final JsBlock body;

    public CoroutineStateElimination(@NotNull JsBlock body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this.body = body2;
    }

    public final boolean apply() {
        Ref.BooleanRef changed = new Ref.BooleanRef();
        this.body.accept(new RecursiveJsVisitor(changed){
            final /* synthetic */ Ref.BooleanRef $changed;
            {
                this.$changed = $changed;
            }

            public void visitBlock(JsBlock x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                List<JsStatement> list = x.getStatements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                this.visitStatements(list);
                super.visitBlock(x);
            }

            public void visitCase(JsCase x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                List<JsStatement> list = x.getStatements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                this.visitStatements(list);
                super.visitCase(x);
            }

            private final void visitStatements(List<JsStatement> statements) {
                Set indexesToRemove = new LinkedHashSet<E>();
                @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0015\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"org/jetbrains/kotlin/js/inline/clean/CoroutineStateElimination$apply$1$visitStatements$IndexHolder", "", "<init>", "()V", "value", "", "getValue", "()Ljava/lang/Integer;", "setValue", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "js.translator"})
                public final class IndexHolder {
                    private Integer value;

                    public IndexHolder() {
                    }

                    public final Integer getValue() {
                        return this.value;
                    }

                    public final void setValue(Integer n) {
                        this.value = n;
                    }
                }
                IndexHolder lastTargetBlockIndex = new IndexHolder();
                IndexHolder lastTargetExceptionBlockIndex = new IndexHolder();
                IndexHolder lastFinallyPathIndex = new IndexHolder();
                Iterator<Object> iterator2 = ((Iterable)statements).iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int index = n++;
                    JsStatement statement = (JsStatement)iterator2.next();
                    List indexesToUpdate = new ArrayList<E>();
                    if (statement instanceof JsExpressionStatement) {
                        if (CoroutineMetadataPropertiesKt.getTargetBlock((JsExpressionStatement)statement)) {
                            ((Collection)indexesToUpdate).add(lastTargetBlockIndex);
                        }
                        if (CoroutineMetadataPropertiesKt.getTargetExceptionBlock((JsExpressionStatement)statement)) {
                            ((Collection)indexesToUpdate).add(lastTargetExceptionBlockIndex);
                        }
                        if (CoroutineMetadataPropertiesKt.getFinallyPath((JsExpressionStatement)statement)) {
                            ((Collection)indexesToUpdate).add(lastFinallyPathIndex);
                        }
                    }
                    if (!((Collection)indexesToUpdate).isEmpty()) {
                        for (IndexHolder indexToUpdate : indexesToUpdate) {
                            Integer n2 = indexToUpdate.getValue();
                            if (n2 != null) {
                                int it = ((Number)n2).intValue();
                                boolean bl = false;
                                Integer n3 = it;
                                ((Collection)indexesToRemove).add(n3);
                            }
                            indexToUpdate.setValue(index);
                        }
                        continue;
                    }
                    lastTargetBlockIndex.setValue(null);
                    lastTargetExceptionBlockIndex.setValue(null);
                    lastFinallyPathIndex.setValue(null);
                }
                iterator2 = CollectionsKt.reversed((Iterable)CollectionsKt.sorted((Iterable)indexesToRemove)).iterator();
                while (iterator2.hasNext()) {
                    int index = ((Number)iterator2.next()).intValue();
                    statements.remove(index);
                }
                if (!((Collection)indexesToRemove).isEmpty()) {
                    this.$changed.element = true;
                }
            }
        });
        return changed.element;
    }
}

