/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginOsRequirement;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.HtmlChunk;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0007J\b\u0010O\u001a\u00020!H\u0007J\u0016\u0010P\u001a\u00020!2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0&H\u0002J\u0014\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0@H\u0007J&\u0010T\u001a\u00020L2\b\u0010U\u001a\u0004\u0018\u00010V2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0@H\u0002J\u0016\u0010T\u001a\u00020L2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020R0&H\u0002J\\\u0010Y\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020R0[\u0018\u00010Z2\u0006\u0010\\\u001a\u00020R2\u0006\u0010]\u001a\u00020\u00042\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0Z2\u001a\u0010^\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020R0[\u0018\u00010ZH\u0002J\u001a\u0010_\u001a\u0004\u0018\u00010A2\u0006\u0010\\\u001a\u00020'2\u0006\u0010`\u001a\u00020\u0016H\u0007J\u001c\u0010a\u001a\u00020L2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0@H\u0002J>\u0010b\u001a\u00020L2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0c2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0@2\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A0ZH\u0002J\u0010\u0010e\u001a\u00020!2\u0006\u0010]\u001a\u00020\u0004H\u0007J\u0010\u0010e\u001a\u00020!2\u0006\u0010]\u001a\u00020\u0007H\u0007J\u0010\u0010f\u001a\u00020!2\u0006\u0010]\u001a\u00020\u0004H\u0007J\u0010\u0010f\u001a\u00020!2\u0006\u0010]\u001a\u00020\u0007H\u0007J\u0012\u0010g\u001a\u0004\u0018\u00010R2\u0006\u0010]\u001a\u00020\u0004H\u0007J\u0012\u0010h\u001a\u0004\u0018\u00010R2\u0006\u0010]\u001a\u00020\u0004H\u0007J\u000e\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00040HH\u0002J\u000e\u0010j\u001a\b\u0012\u0004\u0012\u00020>0&H\u0007J\u0014\u0010k\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020R0&0lH\u0007J\u0010\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010\\\u001a\u00020'J\u0010\u0010o\u001a\u0004\u0018\u00010A2\u0006\u0010p\u001a\u00020\u0004J\u0016\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00040H2\u0006\u0010\\\u001a\u00020RH\u0007J\u0014\u0010r\u001a\u0004\u0018\u00010'2\b\u0010]\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010s\u001a\u0004\u0018\u00010\u00042\u0006\u0010t\u001a\u00020\u0007H\u0007J\u0016\u0010u\u001a\u0004\u0018\u00010v2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030xH\u0007J\u0017\u0010y\u001a\u0004\u0018\u00010v2\u000b\u0010t\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010z\u001a\u00070\u0007\u00a2\u0006\u0002\b{2\u0006\u0010\\\u001a\u00020'H\u0007J\u0012\u0010|\u001a\u0004\u0018\u00010\u00042\u0006\u0010t\u001a\u00020\u0007H\u0007J\b\u0010}\u001a\u00020\u001cH\u0007J%\u0010~\u001a\u00020\u001c2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0080@\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001J8\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020!2\b\u0010U\u001a\u0004\u0018\u00010VJ\t\u0010\u008a\u0001\u001a\u00020LH\u0007J\u0011\u0010\u008b\u0001\u001a\u00020!2\u0006\u0010\\\u001a\u00020'H\u0007J\u0019\u0010\u008b\u0001\u001a\u00020!2\u0006\u0010\\\u001a\u00020'2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u008c\u0001\u001a\u00020!2\u0007\u0010\u008d\u0001\u001a\u00020vH\u0007J\u0014\u0010\u008c\u0001\u001a\u00020!2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u0007H\u0007J\u0011\u0010\u008f\u0001\u001a\u00020!2\u0006\u0010p\u001a\u00020\u0004H\u0007J\u0011\u0010\u0090\u0001\u001a\u00020!2\u0006\u0010\\\u001a\u00020'H\u0007J\u001b\u0010\u0090\u0001\u001a\u00020!2\u0006\u0010\\\u001a\u00020'2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u0012\u0010\u0091\u0001\u001a\u00020!2\u0007\u0010\u0092\u0001\u001a\u00020\u0004H\u0007J\u0016\u0010\u0093\u0001\u001a\u00020!2\u000b\u0010t\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0011\u0010\u0094\u0001\u001a\u00020!2\u0006\u0010]\u001a\u00020\u0004H\u0007J\b\u0010\"\u001a\u00020!H\u0007J\u0011\u0010\u0095\u0001\u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0003\u0010\u0096\u0001J\u0012\u0010\u0097\u0001\u001a\u00020!2\u0007\u0010\u008d\u0001\u001a\u00020vH\u0007J\u0012\u0010\u0098\u0001\u001a\u00020!2\u0007\u0010\u0099\u0001\u001a\u00020\u0007H\u0007J\u0012\u0010\u009a\u0001\u001a\u00020!2\u0007\u0010\u009b\u0001\u001a\u00020!H\u0007J*\u0010\u009c\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0=0&2\u0013\u0010\u009d\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070=0&H\u0002J>\u0010\u009e\u0001\u001a\u00020!2\u0007\u0010\u009f\u0001\u001a\u00020R2\u0013\u0010\u00a0\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0@2\u0015\u0010\u00a1\u0001\u001a\u0010\u0012\u0004\u0012\u00020R\u0012\u0005\u0012\u00030\u00a3\u00010\u00a2\u0001H\u0007JX\u0010\u009e\u0001\u001a\u00020!2\u0007\u0010\u009f\u0001\u001a\u00020R2\u0010\u0010\u00a4\u0001\u001a\u000b\u0012\u0006\b\u0000\u0012\u00020R0\u00a5\u00012\u0013\u0010\u00a0\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0@2\u001d\u0010\u00a1\u0001\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010R\u0012\u0005\u0012\u00030\u00a3\u00010\u00a6\u0001H\u0002J>\u0010\u00a7\u0001\u001a\u00020L2\u0007\u0010\u009f\u0001\u001a\u00020R2\u0013\u0010\u00a0\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020R0@2\u0015\u0010\u00a1\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0005\u0012\u00030\u00a3\u00010\u00a2\u0001H\u0007J\u0013\u0010\u00a8\u0001\u001a\u00020L2\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0007JL\u0010\u00a8\u0001\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u00012\u000e\u0010\u00ab\u0001\u001a\t\u0012\u0005\u0012\u00030\u00ac\u00010\u001b2\u0010\u0010\u00ad\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u0088\u0001\u0018\u00010\u001b2\u000f\u0010\u00ae\u0001\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010\u001bH\u0007J\u0012\u0010\u00af\u0001\u001a\u00020L2\u0007\u0010\u00b0\u0001\u001a\u00020\u001cH\u0007J\u001e\u0010\u00b1\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040H2\r\u0010\u00b2\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070cH\u0007JD\u0010\u00b3\u0001\u001a\u00020!2\b\u0010\u00b4\u0001\u001a\u00030\u00b5\u00012\r\u0010\u00b6\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040H2\u0006\u0010+\u001a\u00020,2\u0012\b\u0002\u0010\u00b7\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u00b8\u0001\u0018\u00010CH\u0007\u00a2\u0006\u0003\u0010\u00b9\u0001J\u0017\u0010\u00ba\u0001\u001a\u00020L2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020'0cH\u0007J<\u0010\u00bb\u0001\u001a\u00020L2\b\u0010\u00b4\u0001\u001a\u00030\u00b5\u00012\r\u0010\u00b6\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070c2\u0012\b\u0002\u0010\u00b7\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u00b8\u0001\u0018\u00010CH\u0007\u00a2\u0006\u0003\u0010\u00bc\u0001J<\u0010\u00bb\u0001\u001a\u00020L2\b\u0010\u00b4\u0001\u001a\u00030\u00b5\u00012\r\u0010\u00b6\u0001\u001a\b\u0012\u0004\u0012\u00020\u00040H2\u0012\b\u0002\u0010\u00b7\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u00b8\u0001\u0018\u00010CH\u0007\u00a2\u0006\u0003\u0010\u00bd\u0001J=\u0010\u00bb\u0001\u001a\u00020L2\b\u0010\u00b4\u0001\u001a\u00030\u00b5\u00012\u000e\u0010\u00b6\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u00be\u00012\u0012\b\u0002\u0010\u00b7\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u00b8\u0001\u0018\u00010CH\u0007\u00a2\u0006\u0003\u0010\u00bf\u0001R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u0012\u0010$\u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u0002\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,8GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b-\u0010\u0002\u001a\u0004\b.\u0010/R\"\u00101\u001a\u0004\u0018\u00010\u001c2\b\u00100\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0010\u00104\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u00105\u001a\u0004\u0018\u0001068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0=0<8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010B\u001a\b\u0012\u0004\u0012\u00020'0C8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bD\u0010\u0002\u001a\u0004\bE\u0010FR\u0016\u0010G\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010I\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040HX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c0\u0001"}, d2={"Lcom/intellij/ide/plugins/PluginManagerCore;", "", "()V", "ALL_MODULES_MARKER", "Lcom/intellij/openapi/extensions/PluginId;", "CORE_ID", "CORE_PLUGIN_ID", "", "DISABLE", "Lorg/jetbrains/annotations/NonNls;", "EDIT", "ENABLE", "JAVA_MODULE_ID", "JAVA_PLUGIN_ID", "META_INF", "MODULE_DEPENDENCY_PREFIX", "PLUGIN_XML", "PLUGIN_XML_PATH", "SPECIAL_IDEA_PLUGIN_ID", "VENDOR_JETBRAINS", "VENDOR_JETBRAINS_SRO", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getBuildNumber$annotations", "getBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "initFuture", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/ide/plugins/PluginSet;", "initPluginFuture", "getInitPluginFuture", "()Lkotlinx/coroutines/Deferred;", "isIgnoreCompatibility", "", "isRunningFromSources", "Ljava/lang/Boolean;", "isUnitTestMode", "loadedPlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getLoadedPlugins$annotations", "getLoadedPlugins", "()Ljava/util/List;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "<set-?>", "nullablePluginSet", "getNullablePluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "ourBuildNumber", "pluginDescriptorDebugData", "Lcom/intellij/ide/plugins/PluginDescriptorsDebugData;", "getPluginDescriptorDebugData", "()Lcom/intellij/ide/plugins/PluginDescriptorsDebugData;", "setPluginDescriptorDebugData", "(Lcom/intellij/ide/plugins/PluginDescriptorsDebugData;)V", "pluginErrors", "Ljava/util/ArrayList;", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/util/text/HtmlChunk;", "pluginLoadingErrors", "", "Lcom/intellij/ide/plugins/PluginLoadingError;", "plugins", "", "getPlugins$annotations", "getPlugins", "()[Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "pluginsToDisable", "", "pluginsToEnable", "shadowedBundledPlugins", "addDisablePluginListener", "", "listener", "Ljava/lang/Runnable;", "arePluginsInitialized", "ask3rdPartyPluginsPrivacyConsent", "descriptors", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "buildPluginIdMap", "check3rdPartyPluginsPrivacyConsent", "parentActivity", "Lcom/intellij/diagnostic/Activity;", "idMap", "aliens", "checkAndPut", "", "", "descriptor", "id", "prevDuplicateMap", "checkBuildNumberCompatibility", "ideBuildNumber", "checkEssentialPluginsAreAvailable", "disableIncompatiblePlugins", "", "errors", "disablePlugin", "enablePlugin", "findPlugin", "findPluginByModuleDependency", "get3rdPartyPluginIds", "getAndClearPluginLoadingErrors", "getEnabledPluginRawList", "Ljava/util/concurrent/CompletableFuture;", "getIncompatibleOs", "Lcom/intellij/ide/plugins/IdeaPluginOsRequirement;", "getLoadingError", "pluginId", "getNonOptionalDependenciesIds", "getPlugin", "getPluginByClassName", "className", "getPluginDescriptorIfIdeaClassLoaderIsUsed", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "aClass", "Ljava/lang/Class;", "getPluginDescriptorOrPlatformByClassName", "getPluginNameAndVendor", "Lorg/jetbrains/annotations/Nls;", "getPluginOrPlatformByClassName", "getPluginSet", "initializeAndSetPlugins", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "loadingResult", "Lcom/intellij/ide/plugins/PluginLoadingResult;", "initializeAndSetPlugins$intellij_platform_core_impl", "(Lcom/intellij/ide/plugins/DescriptorListLoadingContext;Lcom/intellij/ide/plugins/PluginLoadingResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializePlugins", "Lcom/intellij/ide/plugins/PluginManagerState;", "coreLoader", "Ljava/lang/ClassLoader;", "checkEssentialPlugins", "invalidatePlugins", "isCompatible", "isDevelopedByJetBrains", "plugin", "vendorString", "isDisabled", "isIncompatible", "isModuleDependency", "dependentPluginId", "isPlatformClass", "isPluginInstalled", "isThirdPartyPluginsNoteAccepted", "()Ljava/lang/Boolean;", "isUpdatedBundledPlugin", "isVendorJetBrains", "vendorItem", "onEnable", "enabled", "preparePluginErrors", "globalErrorsSuppliers", "processAllNonOptionalDependencies", "rootDescriptor", "pluginIdMap", "consumer", "Lkotlin/Function1;", "Ljava/nio/file/FileVisitResult;", "depProcessed", "", "Lkotlin/Function2;", "processAllNonOptionalDependencyIds", "scheduleDescriptorLoading", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "zipFilePoolDeferred", "Lcom/intellij/util/lang/ZipFilePool;", "mainClassLoaderDeferred", "logDeferred", "setPluginSet", "value", "toPluginIds", "pluginIdStrings", "tryWritePluginIdsToFile", "path", "Ljava/nio/file/Path;", "pluginIds", "openOptions", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;Ljava/util/Set;Lcom/intellij/openapi/diagnostic/Logger;[Ljava/nio/file/OpenOption;)Z", "write3rdPartyPlugins", "writePluginIdsToFile", "(Ljava/nio/file/Path;Ljava/util/Collection;[Ljava/nio/file/OpenOption;)V", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/OpenOption;)V", "Lkotlin/sequences/Sequence;", "(Ljava/nio/file/Path;Lkotlin/sequences/Sequence;[Ljava/nio/file/OpenOption;)V", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nPluginManagerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCore\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,1079:1\n37#2,2:1080\n1549#3:1082\n1620#3,3:1083\n288#3,2:1092\n1247#4,2:1086\n603#4:1088\n179#4,2:1089\n26#5:1091\n*S KotlinDebug\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCore\n*L\n141#1:1080,2\n161#1:1082\n161#1:1083,3\n859#1:1092,2\n279#1:1086,2\n308#1:1088\n506#1:1089,2\n754#1:1091\n*E\n"})
public final class PluginManagerCore {
    @NotNull
    public static final PluginManagerCore INSTANCE = new PluginManagerCore();
    @JvmField
    @NotNull
    public static final PluginId CORE_ID;
    @JvmField
    @NotNull
    public static final PluginId JAVA_PLUGIN_ID;
    @JvmField
    @NotNull
    public static final PluginId JAVA_MODULE_ID;
    @JvmField
    @NotNull
    public static final PluginId ALL_MODULES_MARKER;
    @JvmField
    @NotNull
    public static final PluginId SPECIAL_IDEA_PLUGIN_ID;
    @VisibleForTesting
    @JvmField
    public static volatile boolean isIgnoreCompatibility;
    @VisibleForTesting
    @JvmField
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    @NotNull
    private static final ArrayList<Supplier<HtmlChunk>> pluginErrors;
    @NotNull
    private static Set<PluginId> shadowedBundledPlugins;
    @Nullable
    private static BuildNumber ourBuildNumber;

    private PluginManagerCore() {
    }

    @NotNull
    public static final BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromPluginCompatibleBuild();
            if (INSTANCE.getLogger().isDebugEnabled()) {
                Logger logger = INSTANCE.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("getBuildNumber: fromPluginsCompatibleBuild=");
                Object object = result2;
                if (object == null || (object = ((BuildNumber)object).asString()) == null) {
                    object = "null";
                }
                logger.debug(stringBuilder.append((String)object).toString());
            }
            if (result2 == null) {
                BuildNumber buildNumber;
                if (isUnitTestMode) {
                    buildNumber = BuildNumber.currentVersion();
                } else {
                    BuildNumber buildNumber2;
                    try {
                        buildNumber2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException _) {
                        buildNumber2 = BuildNumber.currentVersion();
                    }
                    buildNumber = buildNumber2;
                }
                result2 = buildNumber;
            }
            ourBuildNumber = result2;
        }
        return result2;
    }

    @Nullable
    public final IdeaPluginOsRequirement getIncompatibleOs(@NotNull IdeaPluginDescriptor descriptor) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            List<IdeaPluginDependency> list = descriptor.getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getIncompatibleOs.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdeaPluginOsRequirement p2 = (IdeaPluginOsRequirement)((Object)element$iv);
                boolean bl = false;
                if (!(p2 != null && !p2.isHostOs())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @JvmStatic
    @Nullable
    public static final PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor, @NotNull BuildNumber ideBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)ideBuildNumber, (String)"ideBuildNumber");
        IdeaPluginOsRequirement incompatibleOs = INSTANCE.getIncompatibleOs(descriptor);
        if (incompatibleOs != null) {
            Object[] objectArray = new Object[]{descriptor.getName(), descriptor.getVersion(), incompatibleOs, SystemInfo.getOsName()};
            Supplier supplier = PluginManagerCoreKt.access$message("plugin.loading.error.long.incompatible.with.platform", objectArray);
            objectArray = new Object[]{incompatibleOs};
            return new PluginLoadingError(descriptor, supplier, PluginManagerCoreKt.access$message("plugin.loading.error.short.incompatible.with.platform", objectArray));
        }
        if (isIgnoreCompatibility) {
            return null;
        }
        try {
            String pluginName;
            BuildNumber untilBuildNumber;
            String pluginName2;
            BuildNumber sinceBuildNumber;
            String sinceBuild = descriptor.getSinceBuild();
            if (sinceBuild != null && (sinceBuildNumber = BuildNumber.fromString(sinceBuild, pluginName2 = descriptor.getName(), null)) != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                Object[] objectArray = new Object[]{pluginName2, descriptor.getVersion(), sinceBuild, ideBuildNumber};
                Supplier supplier = PluginManagerCoreKt.access$message("plugin.loading.error.long.incompatible.since.build", objectArray);
                objectArray = new Object[]{sinceBuild};
                return new PluginLoadingError(descriptor, supplier, PluginManagerCoreKt.access$message("plugin.loading.error.short.incompatible.since.build", objectArray));
            }
            String untilBuild = descriptor.getUntilBuild();
            if (untilBuild != null && (untilBuildNumber = BuildNumber.fromString(untilBuild, pluginName = descriptor.getName(), null)) != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                Object[] objectArray = new Object[]{pluginName, descriptor.getVersion(), untilBuild, ideBuildNumber};
                Supplier supplier = PluginManagerCoreKt.access$message("plugin.loading.error.long.incompatible.until.build", objectArray);
                objectArray = new Object[]{untilBuild};
                return new PluginLoadingError(descriptor, supplier, PluginManagerCoreKt.access$message("plugin.loading.error.short.incompatible.until.build", objectArray));
            }
        }
        catch (Exception e2) {
            INSTANCE.getLogger().error(e2);
            Object[] objectArray = new Object[]{descriptor.getName()};
            return new PluginLoadingError(descriptor, PluginManagerCoreKt.access$message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", objectArray), PluginManagerCoreKt.access$message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
        return null;
    }

    @ApiStatus.Internal
    public final void writePluginIdsToFile(@NotNull Path path, @NotNull Set<PluginId> pluginIds, @Nullable OpenOption[] openOptions) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        this.writePluginIdsToFile(path, (Sequence<PluginId>)CollectionsKt.asSequence((Iterable)pluginIds), openOptions);
    }

    @ApiStatus.Internal
    public final boolean tryWritePluginIdsToFile(@NotNull Path path, @NotNull Set<PluginId> pluginIds, @NotNull Logger logger, @Nullable OpenOption[] openOptions) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            this.writePluginIdsToFile(path, pluginIds, openOptions);
            return true;
        }
        catch (IOException e2) {
            logger.warn("Unable to write plugin id list to: " + path, e2);
            return false;
        }
    }

    public static /* synthetic */ boolean tryWritePluginIdsToFile$default(PluginManagerCore pluginManagerCore, Path path, Set set, Logger logger, OpenOption[] openOptionArray, int n2, Object object) {
        if ((n2 & 8) != 0) {
            openOptionArray = null;
        }
        return pluginManagerCore.tryWritePluginIdsToFile(path, set, logger, openOptionArray);
    }

    @ApiStatus.Internal
    public final void writePluginIdsToFile(@NotNull Path path, @NotNull Sequence<PluginId> pluginIds, @Nullable OpenOption[] openOptions) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        this.writePluginIdsToFile(path, SequencesKt.toList((Sequence)SequencesKt.map(pluginIds, (Function1)writePluginIdsToFile.1.INSTANCE)), openOptions);
    }

    @VisibleForTesting
    public final synchronized void writePluginIdsToFile(@NotNull Path path, @NotNull Collection<String> pluginIds, @Nullable OpenOption[] openOptions) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        NioFiles.createDirectories(path.getParent());
        Iterable iterable = new TreeSet<String>(pluginIds);
        OpenOption[] openOptionArray = openOptions;
        if (openOptions == null) {
            boolean $i$f$emptyArray = false;
            openOptionArray = new OpenOption[]{};
        }
        OpenOption[] openOptionArray2 = openOptionArray;
        Files.write(path, (Iterable<? extends CharSequence>)iterable, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final Set<PluginId> toPluginIds(@NotNull Collection<String> pluginIdStrings) {
        Intrinsics.checkNotNullParameter(pluginIdStrings, (String)"pluginIdStrings");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)pluginIdStrings), (Function1)toPluginIds.1.INSTANCE), (Function1)toPluginIds.2.INSTANCE), (Function1)toPluginIds.3.INSTANCE));
    }

    @ApiStatus.Internal
    @NotNull
    public static final Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    static {
        PluginId pluginId = PluginId.getId("com.intellij");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        CORE_ID = pluginId;
        PluginId pluginId2 = PluginId.getId("com.intellij.java");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getId(...)");
        JAVA_PLUGIN_ID = pluginId2;
        PluginId pluginId3 = PluginId.getId("com.intellij.modules.java");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId3, (String)"getId(...)");
        JAVA_MODULE_ID = pluginId3;
        PluginId pluginId4 = PluginId.getId("com.intellij.modules.all");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId4, (String)"getId(...)");
        ALL_MODULES_MARKER = pluginId4;
        PluginId pluginId5 = PluginId.getId("IDEA CORE");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId5, (String)"getId(...)");
        SPECIAL_IDEA_PLUGIN_ID = pluginId5;
        isIgnoreCompatibility = Boolean.getBoolean("idea.ignore.plugin.compatibility");
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        pluginErrors = new ArrayList();
        shadowedBundledPlugins = ExtensionsKt.persistentSetOf();
    }
}

