/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiTemplateExpressionImpl
extends ExpressionPsiElement
implements PsiTemplateExpression {
    public PsiTemplateExpressionImpl() {
        super(JavaElementType.TEMPLATE_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiTemplateExpressionImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTemplateExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @Nullable
    public PsiExpression getProcessor() {
        PsiElement child = this.getFirstChild();
        return child instanceof PsiExpression ? (PsiExpression)child : null;
    }

    @Override
    @NotNull
    public PsiTemplateExpression.ArgumentType getArgumentType() {
        PsiElement lastChild = this.getLastChild();
        if (lastChild instanceof PsiTemplate) {
            PsiTemplateExpression.ArgumentType argumentType = PsiTemplateExpression.ArgumentType.TEMPLATE;
            if (argumentType == null) {
                PsiTemplateExpressionImpl.$$$reportNull$$$0(1);
            }
            return argumentType;
        }
        if (!(lastChild instanceof PsiLiteralExpression)) {
            throw new AssertionError((Object)("literal expression expected, got " + lastChild.getClass()));
        }
        PsiTemplateExpression.ArgumentType argumentType = ((PsiLiteralExpression)lastChild).isTextBlock() ? PsiTemplateExpression.ArgumentType.TEXT_BLOCK : PsiTemplateExpression.ArgumentType.STRING_LITERAL;
        if (argumentType == null) {
            PsiTemplateExpressionImpl.$$$reportNull$$$0(2);
        }
        return argumentType;
    }

    @Override
    @Nullable
    public PsiTemplate getTemplate() {
        PsiElement lastChild = this.getLastChild();
        return lastChild instanceof PsiTemplate ? (PsiTemplate)lastChild : null;
    }

    @Override
    @Nullable
    public PsiLiteralExpression getLiteralExpression() {
        PsiElement lastChild = this.getLastChild();
        return lastChild instanceof PsiLiteralExpression ? (PsiLiteralExpression)lastChild : null;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        PsiExpression processor = this.getProcessor();
        if (processor == null) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                PsiTemplateExpressionImpl.$$$reportNull$$$0(3);
            }
            return javaResolveResult;
        }
        PsiType type = processor.getType();
        if (type == null) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                PsiTemplateExpressionImpl.$$$reportNull$$$0(4);
            }
            return javaResolveResult;
        }
        PsiMethod method = PsiTemplateExpressionImpl.findBaseProcessMethod(type);
        if (method == null) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                PsiTemplateExpressionImpl.$$$reportNull$$$0(5);
            }
            return javaResolveResult;
        }
        for (PsiClassType psiClassType : PsiTypesUtil.getClassTypeComponents(type)) {
            PsiSubstitutor substitutor2;
            PsiClass methodContainingClass;
            PsiMethod foundMethod;
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (!TypeConversionUtil.isAssignable(type, psiClassType) || (aClass = (resolveResult = psiClassType.resolveGenerics()).getElement()) == null || (foundMethod = aClass.findMethodBySignature(method, true)) == null || (methodContainingClass = foundMethod.getContainingClass()) == null || (substitutor2 = TypeConversionUtil.getClassSubstitutor(methodContainingClass, aClass, resolveResult.getSubstitutor())) == null) continue;
            return new MethodCandidateInfo(foundMethod, substitutor2, false, false, this, null, null, null);
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiTemplateExpressionImpl.$$$reportNull$$$0(6);
        }
        return javaResolveResult;
    }

    @Override
    @Nullable
    public PsiMethod resolveMethod() {
        return ObjectUtils.tryCast(this.resolveMethodGenerics(), PsiMethod.class);
    }

    private static PsiMethod findBaseProcessMethod(PsiType type) {
        Ref refMethod = Ref.create();
        InheritanceUtil.processSuperTypes(type, true, superType -> {
            PsiMethod[] processMethods;
            if (!(superType instanceof PsiClassType)) {
                return true;
            }
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)superType).resolveGenerics();
            PsiClass superClass = result2.getElement();
            if (superClass == null) {
                return true;
            }
            if (!"java.lang.StringTemplate.Processor".equals(superClass.getQualifiedName())) {
                return true;
            }
            for (PsiMethod method : processMethods = superClass.findMethodsByName("process", false)) {
                PsiType parameterType;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length != 1 || !((parameterType = parameters[0].getType()) instanceof PsiClassType) || !parameterType.equalsToText("java.lang.StringTemplate")) continue;
                refMethod.set(method);
                return false;
            }
            return true;
        });
        return (PsiMethod)refMethod.get();
    }

    @Override
    @Nullable
    public PsiType getType() {
        JavaResolveResult result2;
        PsiMethod method;
        if (!PsiUtil.getLanguageLevel(this).equals((Object)LanguageLevel.JDK_21_PREVIEW) && (method = (PsiMethod)(result2 = this.resolveMethodGenerics()).getElement()) != null) {
            return result2.getSubstitutor().substitute(method.getReturnType());
        }
        PsiExpression processor = this.getProcessor();
        if (processor == null) {
            return null;
        }
        PsiType type = processor.getType();
        if (type == null) {
            return null;
        }
        for (PsiClassType psiClassType : PsiTypesUtil.getClassTypeComponents(type)) {
            PsiType substituted = PsiUtil.substituteTypeParameter((PsiType)psiClassType, "java.lang.StringTemplate.Processor", 0, false);
            if (substituted == null) continue;
            return PsiUtil.captureToplevelWildcards(substituted, this);
        }
        return null;
    }

    @Override
    public String toString() {
        return "PsiTemplateExpression";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiTemplateExpressionImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiTemplateExpressionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMethodGenerics";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

