/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinClassFileDecompiler;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "<init>", "()V", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getStubBuilder", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinClsStubBuilder;", "createFileViewProvider", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinDecompiledFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "decompiler-to-psi"})
public final class KotlinClassFileDecompiler
extends ClassFileDecompilers.Full {
    @Override
    public boolean accepts(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ClsKotlinBinaryClassCache.isKotlinJvmCompiledFile$default(ClsKotlinBinaryClassCache.Companion.getInstance(), file, null, 2, null);
    }

    @Override
    @NotNull
    public KotlinClsStubBuilder getStubBuilder() {
        return KotlinClsStubBuilder.INSTANCE;
    }

    @Override
    @NotNull
    public KotlinDecompiledFileViewProvider createFileViewProvider(@NotNull VirtualFile file, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return new KotlinDecompiledFileViewProvider(manager, file, physical, (Function1<? super KotlinDecompiledFileViewProvider, ? extends KtDecompiledFile>)((Function1)KotlinClassFileDecompiler::createFileViewProvider$lambda$0));
    }

    private static final KtDecompiledFile createFileViewProvider$lambda$0(KotlinDecompiledFileViewProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        VirtualFile virtualFile = provider2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        return ClsClassFinder.isKotlinInternalCompiledFile$default(ClsClassFinder.INSTANCE, virtualFile2, null, ClsClassFinder.MultifileClassPartKindStrategy.NON_INTERNAL, 2, null) ? null : (KtDecompiledFile)new KtClsFile(provider2);
    }
}

