/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.common.DisposableZipFileSystemAccessor;
import org.jetbrains.kotlin.cli.common.arguments.CommonKlibBasedCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.DuplicatedUniqueNameStrategy;
import org.jetbrains.kotlin.config.KlibAbiCompatibilityLevel;
import org.jetbrains.kotlin.config.KlibConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.konan.file.ZipFileSystemInPlaceAccessor;
import org.jetbrains.kotlin.library.KotlinAbiVersion;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0002H\u0002\"\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"setupCommonKlibArguments", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonKlibBasedCompilerArguments;", "canBeMetadataKlibCompilation", "", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "copyCommonKlibArgumentsFrom", "source", "parseCustomKotlinAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "customKlibAbiVersion", "", "collector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getZipFileSystemAccessor", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "setupKlibAbiCompatibilityLevel", "LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "Lorg/jetbrains/kotlin/config/KlibAbiCompatibilityLevel;", "cli"})
@SourceDebugExtension(value={"SMAP\nklibArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 klibArguments.kt\norg/jetbrains/kotlin/cli/common/KlibArgumentsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n1#2:199\n1642#3,10:188\n1915#3:198\n1916#3:200\n1652#3:201\n1807#3,3:202\n975#3,7:205\n1249#3,4:212\n1915#3,2:216\n*S KotlinDebug\n*F\n+ 1 klibArguments.kt\norg/jetbrains/kotlin/cli/common/KlibArgumentsKt\n*L\n90#1:199\n90#1:188,10\n90#1:198\n90#1:200\n90#1:201\n92#1:202,3\n149#1:205,7\n164#1:212,4\n174#1:216,2\n*E\n"})
public final class KlibArgumentsKt {
    @NotNull
    private static final EnumMap<LanguageVersion, KlibAbiCompatibilityLevel> LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL;

    public static final void setupCommonKlibArguments(@NotNull CompilerConfiguration $this$setupCommonKlibArguments, @NotNull CommonKlibBasedCompilerArguments arguments, boolean canBeMetadataKlibCompilation, @NotNull Disposable rootDisposable) {
        Intrinsics.checkNotNullParameter((Object)$this$setupCommonKlibArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        boolean isKlibMetadataCompilation = canBeMetadataKlibCompilation && arguments.getMetadataKlib();
        Object[] objectArray = arguments.getRelativePathBases();
        if (objectArray != null) {
            Object[] it = objectArray;
            boolean bl = false;
            KlibConfigurationKeysKt.setKlibRelativePathBases($this$setupCommonKlibArguments, CollectionsKt.plus((Collection)KlibConfigurationKeysKt.getKlibRelativePathBases($this$setupCommonKlibArguments), (Object[])it));
        }
        KlibConfigurationKeysKt.setKlibNormalizeAbsolutePath($this$setupCommonKlibArguments, arguments.getNormalizeAbsolutePath());
        KlibConfigurationKeysKt.setProduceKlibSignaturesClashChecks($this$setupCommonKlibArguments, arguments.getEnableSignatureClashChecks());
        CLIConfigurationKeysKt.setRenderDiagnosticInternalName($this$setupCommonKlibArguments, arguments.getRenderInternalDiagnosticNames());
        KlibConfigurationKeysKt.setDuplicatedUniqueNameStrategy($this$setupCommonKlibArguments, DuplicatedUniqueNameStrategy.Companion.parseOrDefault(arguments.getDuplicatedUniqueNameStrategy(), isKlibMetadataCompilation ? DuplicatedUniqueNameStrategy.ALLOW_ALL_WITH_WARNING : DuplicatedUniqueNameStrategy.DENY));
        KlibConfigurationKeysKt.setCustomKlibAbiVersion($this$setupCommonKlibArguments, KlibArgumentsKt.parseCustomKotlinAbiVersion(arguments.getCustomKlibAbiVersion(), CommonConfigurationKeysKt.getMessageCollector($this$setupCommonKlibArguments)));
        if (!isKlibMetadataCompilation) {
            KlibArgumentsKt.setupKlibAbiCompatibilityLevel($this$setupCommonKlibArguments);
        }
        KlibConfigurationKeysKt.setZipFileSystemAccessor($this$setupCommonKlibArguments, KlibArgumentsKt.getZipFileSystemAccessor(arguments, CommonConfigurationKeysKt.getMessageCollector($this$setupCommonKlibArguments), rootDisposable));
    }

    public static final void copyCommonKlibArgumentsFrom(@NotNull CompilerConfiguration $this$copyCommonKlibArgumentsFrom, @NotNull CompilerConfiguration source) {
        Intrinsics.checkNotNullParameter((Object)$this$copyCommonKlibArgumentsFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        KlibConfigurationKeysKt.setKlibRelativePathBases($this$copyCommonKlibArgumentsFrom, KlibConfigurationKeysKt.getKlibRelativePathBases(source));
        KlibConfigurationKeysKt.setKlibNormalizeAbsolutePath($this$copyCommonKlibArgumentsFrom, KlibConfigurationKeysKt.getKlibNormalizeAbsolutePath(source));
        KlibConfigurationKeysKt.setProduceKlibSignaturesClashChecks($this$copyCommonKlibArgumentsFrom, KlibConfigurationKeysKt.getProduceKlibSignaturesClashChecks(source));
        CLIConfigurationKeysKt.setRenderDiagnosticInternalName($this$copyCommonKlibArgumentsFrom, CLIConfigurationKeysKt.getRenderDiagnosticInternalName(source));
        DuplicatedUniqueNameStrategy duplicatedUniqueNameStrategy = KlibConfigurationKeysKt.getDuplicatedUniqueNameStrategy(source);
        if (duplicatedUniqueNameStrategy != null) {
            DuplicatedUniqueNameStrategy it = duplicatedUniqueNameStrategy;
            boolean bl = false;
            KlibConfigurationKeysKt.setDuplicatedUniqueNameStrategy($this$copyCommonKlibArgumentsFrom, it);
        }
        KlibConfigurationKeysKt.setCustomKlibAbiVersion($this$copyCommonKlibArgumentsFrom, KlibConfigurationKeysKt.getCustomKlibAbiVersion(source));
        KlibConfigurationKeysKt.setKlibAbiCompatibilityLevel($this$copyCommonKlibArgumentsFrom, KlibConfigurationKeysKt.getKlibAbiCompatibilityLevel(source));
        KlibConfigurationKeysKt.setZipFileSystemAccessor($this$copyCommonKlibArgumentsFrom, KlibConfigurationKeysKt.getZipFileSystemAccessor(source));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinAbiVersion parseCustomKotlinAbiVersion(String customKlibAbiVersion, MessageCollector collector) {
        List version2;
        block16: {
            block15: {
                boolean bl;
                block14: {
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block13: {
                        void $this$mapNotNullTo$iv$iv;
                        char[] cArray;
                        Object object = customKlibAbiVersion;
                        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) == null) {
                            return null;
                        }
                        Object versionParts = object;
                        if (versionParts.size() != 3) {
                            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "Invalid ABI version format. Expected format: <major>.<minor>.<patch>", null, 4, null);
                            return null;
                        }
                        Iterable $this$mapNotNull$iv = (Iterable)versionParts;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Integer it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl3 = false;
                            String it = (String)element$iv$iv;
                            boolean bl4 = false;
                            if (StringsKt.toIntOrNull((String)it) == null) continue;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        version2 = (List)destination$iv$iv;
                        Regex validNumberRegex = new Regex("(0|[1-9]\\d{0,2})");
                        $this$any$iv = (Iterable)versionParts;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl6 = false;
                                if (!(!validNumberRegex.matches((CharSequence)it))) continue;
                                bl2 = true;
                                break block13;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) break block15;
                    $this$any$iv = version2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            int it = ((Number)element$iv).intValue();
                            boolean bl7 = false;
                            boolean bl8 = 0 <= it ? it < 256 : false;
                            if (!(!bl8)) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block16;
            }
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "Invalid ABI version numbers. Each part must be in the range 0..255.", null, 4, null);
            return null;
        }
        return new KotlinAbiVersion(((Number)version2.get(0)).intValue(), ((Number)version2.get(1)).intValue(), ((Number)version2.get(2)).intValue());
    }

    /*
     * WARNING - void declaration
     */
    private static final ZipFileSystemAccessor getZipFileSystemAccessor(CommonKlibBasedCompilerArguments arguments, MessageCollector collector, Disposable rootDisposable) {
        ZipFileSystemAccessor zipFileSystemAccessor;
        Integer cacheLimit = StringsKt.toIntOrNull((String)arguments.getKlibZipFileAccessorCacheLimit());
        if (cacheLimit == null || cacheLimit < 0) {
            void $this$getZipFileSystemAccessor_u24lambda_u240;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            MessageCollector messageCollector = collector;
            boolean bl = false;
            $this$getZipFileSystemAccessor_u24lambda_u240.append("Cannot parse -Xklib-zip-file-accessor-cache-limit value: \"" + arguments.getKlibZipFileAccessorCacheLimit() + "\". ");
            $this$getZipFileSystemAccessor_u24lambda_u240.append("It must be an integer >= 0.");
            Unit unit = Unit.INSTANCE;
            MessageCollector.report$default(messageCollector, compilerMessageSeverity, stringBuilder.toString(), null, 4, null);
            return null;
        }
        if (cacheLimit > 0) {
            DisposableZipFileSystemAccessor disposableZipFileSystemAccessor;
            DisposableZipFileSystemAccessor it = disposableZipFileSystemAccessor = new DisposableZipFileSystemAccessor(cacheLimit);
            boolean bl = false;
            Disposer.register(rootDisposable, it);
            zipFileSystemAccessor = disposableZipFileSystemAccessor;
        } else {
            zipFileSystemAccessor = ZipFileSystemInPlaceAccessor.INSTANCE;
        }
        return zipFileSystemAccessor;
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupKlibAbiCompatibilityLevel(CompilerConfiguration $this$setupKlibAbiCompatibilityLevel) {
        KlibAbiCompatibilityLevel klibAbiCompatibilityLevel;
        LanguageVersionSettings languageVersionSettings = $this$setupKlibAbiCompatibilityLevel.get(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS);
        if (languageVersionSettings == null) {
            throw new IllegalStateException("Language version settings should be already set up".toString());
        }
        LanguageVersionSettings languageVersionSettings2 = languageVersionSettings;
        CompilerConfiguration compilerConfiguration = $this$setupKlibAbiCompatibilityLevel;
        if (languageVersionSettings2.supportsFeature(LanguageFeature.ExportKlibToOlderAbiVersion)) {
            void var3_3;
            LanguageVersion languageVersion = languageVersionSettings2.getLanguageVersion();
            KlibAbiCompatibilityLevel abiCompatibilityLevel = LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL.get(languageVersion);
            if (abiCompatibilityLevel == null) {
                void $this$setupKlibAbiCompatibilityLevel_u24lambda_u240;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector($this$setupKlibAbiCompatibilityLevel);
                CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
                boolean bl = false;
                $this$setupKlibAbiCompatibilityLevel_u24lambda_u240.append("Exporting KLIBs in older ABI format is only supported for the following language versions: ");
                Set<LanguageVersion> set = LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Iterable $this$takeWhile$iv = set;
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    LanguageVersion it = (LanguageVersion)item$iv;
                    boolean bl2 = false;
                    if (!(it.compareTo((Enum)LanguageVersion.LATEST_STABLE) < 0)) break;
                    list$iv.add(item$iv);
                }
                CollectionsKt.joinTo$default((Iterable)list$iv, (Appendable)((Appendable)$this$setupKlibAbiCompatibilityLevel_u24lambda_u240), null, null, null, (int)0, null, null, (int)126, null);
                $this$setupKlibAbiCompatibilityLevel_u24lambda_u240.append(". The current language version is ");
                $this$setupKlibAbiCompatibilityLevel_u24lambda_u240.append(languageVersion);
                Unit unit = Unit.INSTANCE;
                CompilerConfiguration compilerConfiguration3 = compilerConfiguration2;
                MessageCollector.report$default(messageCollector, compilerMessageSeverity, stringBuilder.toString(), null, 4, null);
                return;
            }
            klibAbiCompatibilityLevel = var3_3;
        } else {
            klibAbiCompatibilityLevel = KlibAbiCompatibilityLevel.Companion.getLATEST_STABLE();
        }
        KlibConfigurationKeysKt.setKlibAbiCompatibilityLevel(compilerConfiguration, klibAbiCompatibilityLevel);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv;
        EnumMap enumMap;
        EnumMap $this$LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL_u24lambda_u240 = enumMap = new EnumMap(LanguageVersion.class);
        boolean bl = false;
        Iterable iterable = (Iterable)KlibAbiCompatibilityLevel.getEntries();
        Map destination$iv = $this$LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL_u24lambda_u240;
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            LanguageVersion languageVersion;
            void abiCompatibilityLevel;
            KlibAbiCompatibilityLevel klibAbiCompatibilityLevel = (KlibAbiCompatibilityLevel)((Object)element$iv);
            Map map = destination$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[abiCompatibilityLevel.ordinal()]) {
                case 1: {
                    languageVersion = LanguageVersion.KOTLIN_2_2;
                    break;
                }
                case 2: {
                    languageVersion = LanguageVersion.KOTLIN_2_3;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            map.put(languageVersion, element$iv);
        }
        if (!($this$LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL_u24lambda_u240.size() == KlibAbiCompatibilityLevel.getEntries().size())) {
            throw new IllegalStateException("Check failed.");
        }
        Iterable $this$forEach$iv = (Iterable)LanguageVersion.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageVersion languageVersion = (LanguageVersion)element$iv;
            boolean bl3 = false;
            if (languageVersion.compareTo((Enum)LanguageVersion.KOTLIN_2_1) < 0 || ((Map)$this$LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL_u24lambda_u240).containsKey(languageVersion)) continue;
            ((Map)$this$LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL_u24lambda_u240).put(languageVersion, KlibAbiCompatibilityLevel.Companion.getLATEST_STABLE());
        }
        LANGUAGE_VERSION_TO_ABI_COMPATIBILITY_LEVEL = enumMap;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KlibAbiCompatibilityLevel.values().length];
            try {
                nArray[KlibAbiCompatibilityLevel.ABI_LEVEL_2_2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KlibAbiCompatibilityLevel.ABI_LEVEL_2_3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

