/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyBodyResolveStateKt;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextualPropertyWithBackingFieldChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextualPropertyWithBackingFieldChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextualPropertyWithBackingFieldChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextualPropertyWithBackingFieldChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,38:1\n56#2:39\n*S KotlinDebug\n*F\n+ 1 FirContextualPropertyWithBackingFieldChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextualPropertyWithBackingFieldChecker\n*L\n30#1:39\n*E\n"})
public final class FirContextualPropertyWithBackingFieldChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirContextualPropertyWithBackingFieldChecker INSTANCE = new FirContextualPropertyWithBackingFieldChecker();

    private FirContextualPropertyWithBackingFieldChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextReceivers) && !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextParameters)) {
            return;
        }
        if (declaration.getContextParameters().isEmpty()) {
            return;
        }
        if (DeclarationAttributesKt.getHasBackingField(declaration)) {
            FirMemberDeclaration $this$isLateInit$iv = declaration;
            boolean $i$f$isLateInit = false;
            if (!$this$isLateInit$iv.getStatus().isLateInit() && !FirPropertyBodyResolveStateKt.isLocal(declaration)) {
                DiagnosticContext diagnosticContext2 = context2;
                Object object = declaration.getInitializer();
                if (object == null || (object = ((FirExpression)object).getSource()) == null) {
                    object = declaration.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, reporter, (AbstractKtSourceElement)object, FirErrors.INSTANCE.getCONTEXT_PARAMETERS_WITH_BACKING_FIELD(), null, 8, null);
            }
        }
    }
}

