/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.parsing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.localfs.KotlinLocalFileSystem;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u000f"}, d2={"classesFqNames", "", "", "files", "Ljava/io/File;", "kotlinFiles", "", "disposable", "Lcom/intellij/openapi/Disposable;", "filterClassesTo", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classes", "Ljava/util/Deque;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nparseFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 parseFileUtils.kt\norg/jetbrains/kotlin/incremental/parsing/ParseFileUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n777#2:79\n873#2,2:80\n822#2,2:82\n*S KotlinDebug\n*F\n+ 1 parseFileUtils.kt\norg/jetbrains/kotlin/incremental/parsing/ParseFileUtilsKt\n*L\n29#1:79\n29#1:80,2\n76#1:82,2\n*E\n"})
public final class ParseFileUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> classesFqNames(@NotNull Set<? extends File> files2) {
        Set<String> set;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!(StringsKt.endsWith((String)string, (String)".kt", (boolean)true) && it.isFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingKotlinFiles = (List)destination$iv$iv;
        if (existingKotlinFiles.isEmpty()) {
            return SetsKt.emptySet();
        }
        Disposable disposable = Disposer.newDisposable("Disposable for org.jetbrains.kotlin.incremental.parsing.classesFqNames");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        try {
            set = ParseFileUtilsKt.classesFqNames(existingKotlinFiles, disposable2);
        }
        finally {
            Disposer.dispose(disposable2);
        }
        return set;
    }

    private static final Set<String> classesFqNames(Collection<? extends File> kotlinFiles, Disposable disposable) {
        CompilerConfiguration config = new CompilerConfiguration();
        config.put(JVMConfigurationKeys.NO_JDK, true);
        CommonConfigurationKeysKt.setMessageCollector(config, MessageCollector.Companion.getNONE());
        JvmContentRootsKt.configureJdkClasspathRoots(config);
        EnvironmentConfigFiles configFiles = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(disposable, config, configFiles);
        PsiManager psiManager = PsiManager.getInstance(environment.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFileSystem virtualFileSystem = fileManager.getFileSystem("file");
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.localfs.KotlinLocalFileSystem");
        KotlinLocalFileSystem localFS = (KotlinLocalFileSystem)virtualFileSystem;
        HashSet<String> result2 = new HashSet<String>();
        for (File file : kotlinFiles) {
            VirtualFile virtualFile;
            Intrinsics.checkNotNull((Object)localFS.findFileByIoFile(file));
            for (PsiFile psiFile : new SingleRootFileViewProvider(psiManager2, virtualFile).getAllFiles()) {
                if (!(psiFile instanceof KtFile)) continue;
                ArrayDeque classes = new ArrayDeque();
                ParseFileUtilsKt.filterClassesTo((Collection<? extends KtDeclaration>)((KtFile)psiFile).getDeclarations(), classes);
                while (!((Collection)classes).isEmpty()) {
                    KtClassOrObject klass = (KtClassOrObject)classes.pollFirst();
                    if (klass.getFqName() != null) {
                        FqName it;
                        boolean bl = false;
                        result2.add(it.asString());
                    }
                    ParseFileUtilsKt.filterClassesTo((Collection<? extends KtDeclaration>)klass.getDeclarations(), classes);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void filterClassesTo(Collection<? extends KtDeclaration> $this$filterClassesTo, Deque<KtClassOrObject> classes) {
        void $this$filterIsInstanceTo$iv;
        Iterable iterable = $this$filterClassesTo;
        Collection destination$iv = classes;
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv : $this$filterIsInstanceTo$iv) {
            if (!(element$iv instanceof KtClassOrObject)) continue;
            destination$iv.add(element$iv);
        }
    }
}

