/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonString;", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "write", "", "writer", "Ljava/io/Writer;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "js.parser"})
public final class JsonString
extends JsonNode {
    @NotNull
    private final String value;

    public JsonString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        super(null);
        this.value = value2;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.append('\"');
        String string = this.value;
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            Writer writer2;
            char c2 = string.charAt(i2);
            char c3 = c2;
            if (c3 == '\\') {
                writer2 = writer.append("\\\\");
                continue;
            }
            if (c3 == '\"') {
                writer2 = writer.append("\\\"");
                continue;
            }
            if (c3 == '\r') {
                writer2 = writer.append("\\r");
                continue;
            }
            if (c3 == '\n') {
                writer2 = writer.append("\\n");
                continue;
            }
            if (c3 == '\t') {
                writer2 = writer.append("\\t");
                continue;
            }
            if (c3 == '\b') {
                writer2 = writer.append("\\b");
                continue;
            }
            if (c3 == '\f') {
                writer2 = writer.append("\\f");
                continue;
            }
            boolean bl = ' ' <= c3 ? c3 < '\u007f' : false;
            if (bl) {
                writer2 = writer.append(c2);
                continue;
            }
            writer.append("\\u");
            int shift = 0;
            shift = 16;
            int n3 = 4;
            for (int i3 = 0; i3 < n3; ++i3) {
                int it = i3;
                boolean bl2 = false;
                int digit = c2 >>> (shift -= 4) & 0xF;
                writer.append(digit < 10 ? (char)(digit + 48) : (char)(digit - 10 + 97));
            }
            writer2 = Unit.INSTANCE;
        }
        writer.append('\"');
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString();
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final JsonString copy(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return new JsonString(value2);
    }

    public static /* synthetic */ JsonString copy$default(JsonString jsonString, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = jsonString.value;
        }
        return jsonString.copy(string);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonString)) {
            return false;
        }
        JsonString jsonString = (JsonString)other;
        return Intrinsics.areEqual((Object)this.value, (Object)jsonString.value);
    }
}

