/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u0016*\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NewSchemeOfIntegerOperatorResolutionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkArgument", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "needToCheck", "", "checkArgumentImpl", "Lorg/jetbrains/kotlin/types/SimpleType;", "argumentExpression", "isIntOperator", "literalOperatorsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "frontend"})
@SourceDebugExtension(value={"SMAP\nNewSchemeOfIntegerOperatorResolutionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewSchemeOfIntegerOperatorResolutionChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/NewSchemeOfIntegerOperatorResolutionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1661#2,3:126\n*S KotlinDebug\n*F\n+ 1 NewSchemeOfIntegerOperatorResolutionChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/NewSchemeOfIntegerOperatorResolutionChecker\n*L\n122#1:126,3\n*E\n"})
public final class NewSchemeOfIntegerOperatorResolutionChecker
implements CallChecker {
    @NotNull
    public static final NewSchemeOfIntegerOperatorResolutionChecker INSTANCE;
    @NotNull
    private static final Set<FqName> literalOperatorsFqNames;

    private NewSchemeOfIntegerOperatorResolutionChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            SimpleType expectedType;
            KotlinType kotlinType;
            ValueParameterDescriptor valueParameter2 = entry.getKey();
            ResolvedValueArgument arguments = entry.getValue();
            Intrinsics.checkNotNull((Object)valueParameter2);
            if (ArgumentsUtilsKt.isVararg(valueParameter2)) {
                kotlinType = valueParameter2.getVarargElementType();
                if (kotlinType == null) {
                    continue;
                }
            } else {
                kotlinType = valueParameter2.getType();
            }
            if (!this.needToCheck(expectedType = FlexibleTypesKt.lowerIfFlexible(kotlinType.unwrap()))) continue;
            for (ValueArgument argument : arguments.getArguments()) {
                KtExpression expression2;
                if (KtPsiUtil.deparenthesize(argument.getArgumentExpression()) == null) continue;
                this.checkArgumentImpl(expectedType, expression2, context2.getTrace(), context2.getModuleDescriptor());
            }
        }
    }

    @JvmStatic
    public static final void checkArgument(@NotNull KotlinType expectedType, @NotNull KtExpression argument, @NotNull BindingTrace trace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (INSTANCE.needToCheck(expectedType)) {
            SimpleType simpleType = FlexibleTypesKt.lowerIfFlexible(expectedType);
            KtExpression ktExpression = KtPsiUtil.deparenthesize(argument);
            Intrinsics.checkNotNull((Object)ktExpression);
            INSTANCE.checkArgumentImpl(simpleType, ktExpression, trace, moduleDescriptor);
        }
    }

    public final boolean needToCheck(@NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        if (TypeUtils.noExpectedType(expectedType)) {
            return false;
        }
        return TypeUtilsKt.isPrimitiveNumberOrNullableType(FlexibleTypesKt.lowerIfFlexible(expectedType));
    }

    private final void checkArgumentImpl(SimpleType expectedType, KtExpression argumentExpression, BindingTrace trace, ModuleDescriptor moduleDescriptor) {
        KotlinType kotlinType;
        IElementType token;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(argumentExpression, bindingContext2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> callForArgument = resolvedCall2;
        if (!this.isIntOperator(callForArgument)) {
            return;
        }
        KtElement ktElement = callForArgument.getCall().getCallElement();
        KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
        if (ktExpression == null) {
            return;
        }
        KtExpression callElement = ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.deparenthesize(callElement);
        Intrinsics.checkNotNull((Object)ktExpression2);
        KtExpression deparenthesizedElement = ktExpression2;
        if (deparenthesizedElement instanceof KtConstantExpression) {
            return;
        }
        if (deparenthesizedElement instanceof KtUnaryExpression && (Intrinsics.areEqual((Object)(token = ((KtUnaryExpression)deparenthesizedElement).getOperationToken()), (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)token, (Object)KtTokens.MINUS))) {
            return;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, argumentExpression);
        if (compileTimeConstant == null) {
            return;
        }
        CompileTimeConstant compileTimeValue = compileTimeConstant;
        CompileTimeConstant compileTimeConstant2 = compileTimeValue;
        if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
            SimpleType currentExpressionType = ((IntegerValueTypeConstant)compileTimeValue).getUnknownIntegerType();
            TypeConstructor typeConstructor2 = currentExpressionType.getConstructor();
            IntegerLiteralTypeConstructor integerLiteralTypeConstructor = typeConstructor2 instanceof IntegerLiteralTypeConstructor ? (IntegerLiteralTypeConstructor)typeConstructor2 : null;
            if (integerLiteralTypeConstructor == null) {
                return;
            }
            IntegerLiteralTypeConstructor valueTypeConstructor = integerLiteralTypeConstructor;
            kotlinType = valueTypeConstructor.getApproximatedType();
        } else if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
            SimpleType typeFromCall;
            KotlinType kotlinType2 = callForArgument.getResultingDescriptor().getReturnType();
            SimpleType simpleType = typeFromCall = kotlinType2 != null ? FlexibleTypesKt.lowerIfFlexible(kotlinType2) : null;
            if (typeFromCall != null) {
                kotlinType = typeFromCall;
            } else {
                ConstantValue constantValue = ((TypedCompileTimeConstant)compileTimeValue).getConstantValue();
                if (constantValue instanceof ErrorValue) {
                    return;
                }
                Object t2 = constantValue.getValue();
                Long l2 = t2 instanceof Long ? (Long)t2 : null;
                if (l2 == null) {
                    return;
                }
                long value2 = l2;
                kotlinType = new IntegerLiteralTypeConstructor(value2, moduleDescriptor, ((TypedCompileTimeConstant)compileTimeValue).getParameters()).getApproximatedType();
            }
        } else {
            return;
        }
        KotlinType newExpressionType = kotlinType;
        if (!Intrinsics.areEqual((Object)newExpressionType.getConstructor(), (Object)expectedType.getConstructor())) {
            boolean willBeConversion;
            boolean bl = willBeConversion = TypeUtilsKt.isInt(newExpressionType) && TypeUtilsKt.isLong(TypeUtilsKt.makeNotNullable(expectedType));
            if (!willBeConversion) {
                trace.report(Errors.INTEGER_OPERATOR_RESOLVE_WILL_CHANGE.on((KtExpression)((PsiElement)argumentExpression), newExpressionType));
            }
        }
    }

    private final boolean isIntOperator(ResolvedCall<?> $this$isIntOperator) {
        Object obj = $this$isIntOperator.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor = obj instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)obj : null;
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor descriptor = simpleFunctionDescriptor;
        return literalOperatorsFqNames.contains(DescriptorUtilsKt.getFqNameSafe(descriptor));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        INSTANCE = new NewSchemeOfIntegerOperatorResolutionChecker();
        Object object = new String[]{"plus", "minus", "times", "div", "rem", "plus", "minus", "times", "div", "rem", "shl", "shr", "ushr", "and", "or", "xor", "unaryPlus", "unaryMinus", "inv"};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{"kotlin", "Int", it};
            collection.add(FqName.Companion.fromSegments(CollectionsKt.listOf((Object[])objectArray)));
        }
        literalOperatorsFqNames = (Set)var1_1;
    }
}

