/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntrySuperclassReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DeprecatedClassifierUsageChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "<init>", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class DeprecatedClassifierUsageChecker
implements ClassifierUsageChecker {
    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (element.getParent() instanceof KtThisExpression) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NoDeprecationOnDeprecatedEnumEntries) && element instanceof KtEnumEntrySuperclassReferenceExpression) {
            ClassDescriptor referencedEnum;
            KtElement ktElement = (KtElement)element;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            ConstructorDescriptor constructorDescriptor = callableDescriptor instanceof ConstructorDescriptor ? (ConstructorDescriptor)callableDescriptor : null;
            ClassDescriptor classDescriptor = referencedEnum = constructorDescriptor != null ? constructorDescriptor.getConstructedClass() : null;
            if (Intrinsics.areEqual((Object)referencedEnum, (Object)targetDescriptor)) {
                return;
            }
        }
        for (DescriptorBasedDeprecationInfo deprecation : context2.getDeprecationResolver().getDeprecations(targetDescriptor)) {
            context2.getTrace().report(DeprecationUtilKt.createDeprecationDiagnostic$default(element, deprecation, context2.getLanguageVersionSettings(), false, 8, null));
        }
    }
}

