/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.ReturnValueCheckerMode;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ReturnValueAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "<init>", "()V", "mustUseReturnValueFq", "Lorg/jetbrains/kotlin/name/FqName;", "getMustUseReturnValueFq", "()Lorg/jetbrains/kotlin/name/FqName;", "oldMustUse", "getOldMustUse", "ignorableFq", "getIgnorableFq", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class ReturnValueAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final ReturnValueAnnotationChecker INSTANCE = new ReturnValueAnnotationChecker();
    @NotNull
    private static final FqName mustUseReturnValueFq = StandardClassIds.Annotations.INSTANCE.getMustUseReturnValues().asSingleFqName();
    @NotNull
    private static final FqName oldMustUse = new FqName("kotlin.MustUseReturnValue");
    @NotNull
    private static final FqName ignorableFq = StandardClassIds.Annotations.INSTANCE.getIgnorableReturnValue().asSingleFqName();

    private ReturnValueAnnotationChecker() {
    }

    @NotNull
    public final FqName getMustUseReturnValueFq() {
        return mustUseReturnValueFq;
    }

    @NotNull
    public final FqName getOldMustUse() {
        return oldMustUse;
    }

    @NotNull
    public final FqName getIgnorableFq() {
        return ignorableFq;
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (languageVersionSettings.getFlag(AnalysisFlags.getReturnValueCheckerMode()) != ReturnValueCheckerMode.DISABLED) {
            return;
        }
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            FqName name2;
            AnnotationDescriptor descriptor;
            if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null || descriptor.getFqName() == null || !Intrinsics.areEqual((Object)name2, (Object)mustUseReturnValueFq) && !Intrinsics.areEqual((Object)name2, (Object)ignorableFq) && !Intrinsics.areEqual((Object)name2, (Object)oldMustUse)) continue;
            trace.report(Errors.IGNORABILITY_ANNOTATIONS_WITH_CHECKER_DISABLED.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry)));
        }
    }
}

