/*
 * Decompiled with CFR 0.152.
 */
package org.jline.keymap;

import java.io.IOError;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.utils.ClosedException;
import org.jline.utils.NonBlockingReader;

public class BindingReader {
    protected final NonBlockingReader reader;
    protected final StringBuilder opBuffer = new StringBuilder();
    protected final Deque<Integer> pushBackChar = new ArrayDeque<Integer>();
    protected String lastBinding;

    public BindingReader(NonBlockingReader reader) {
        this.reader = reader;
    }

    public <T> T readBinding(KeyMap<T> keys) {
        return this.readBinding(keys, null, true);
    }

    public <T> T readBinding(KeyMap<T> keys, KeyMap<T> local) {
        return this.readBinding(keys, local, true);
    }

    public <T> T readBinding(KeyMap<T> keys, KeyMap<T> local, boolean block) {
        this.lastBinding = null;
        T o2 = null;
        int[] remaining = new int[1];
        boolean hasRead = false;
        while (true) {
            if (local != null) {
                o2 = local.getBound(this.opBuffer, remaining);
            }
            if (o2 == null && (local == null || remaining[0] >= 0)) {
                o2 = keys.getBound(this.opBuffer, remaining);
            }
            if (o2 != null) {
                if (remaining[0] >= 0) {
                    this.runMacro(this.opBuffer.substring(this.opBuffer.length() - remaining[0]));
                    this.opBuffer.setLength(this.opBuffer.length() - remaining[0]);
                } else {
                    long ambiguousTimeout = keys.getAmbiguousTimeout();
                    if (ambiguousTimeout > 0L && this.peekCharacter(ambiguousTimeout) != -2) {
                        o2 = null;
                    }
                }
                if (o2 != null) {
                    this.lastBinding = this.opBuffer.toString();
                    this.opBuffer.setLength(0);
                    return o2;
                }
            } else if (remaining[0] > 0) {
                int cp = this.opBuffer.codePointAt(0);
                String rem = this.opBuffer.substring(Character.charCount(cp));
                this.lastBinding = this.opBuffer.substring(0, Character.charCount(cp));
                o2 = cp >= 128 ? keys.getUnicode() : keys.getNomatch();
                this.opBuffer.setLength(0);
                this.opBuffer.append(rem);
                if (o2 != null) {
                    return o2;
                }
            }
            if (!block && hasRead) break;
            int c2 = this.readCharacter();
            if (c2 == -1) {
                return null;
            }
            this.opBuffer.appendCodePoint(c2);
            hasRead = true;
        }
        return null;
    }

    public String readStringUntil(String sequence2) {
        StringBuilder sb = new StringBuilder();
        if (!this.pushBackChar.isEmpty()) {
            this.pushBackChar.forEach(sb::appendCodePoint);
        }
        try {
            char[] buf = new char[64];
            while (true) {
                int idx;
                if ((idx = sb.indexOf(sequence2, Math.max(0, sb.length() - buf.length - sequence2.length()))) >= 0) {
                    String rem = sb.substring(idx + sequence2.length());
                    this.runMacro(rem);
                    return sb.substring(0, idx);
                }
                int l2 = this.reader.readBuffered(buf);
                if (l2 < 0) {
                    throw new ClosedException();
                }
                sb.append(buf, 0, l2);
            }
        }
        catch (ClosedException e2) {
            throw new EndOfFileException(e2);
        }
        catch (IOException e3) {
            throw new IOError(e3);
        }
    }

    public int readCharacter() {
        if (!this.pushBackChar.isEmpty()) {
            return this.pushBackChar.pop();
        }
        try {
            int c2 = -2;
            int s2 = 0;
            while (c2 == -2) {
                c2 = this.reader.read(100L);
                if (c2 < 0 || !Character.isHighSurrogate((char)c2)) continue;
                s2 = c2;
                c2 = -2;
            }
            return s2 != 0 ? Character.toCodePoint((char)s2, (char)c2) : c2;
        }
        catch (ClosedException e2) {
            throw new EndOfFileException(e2);
        }
        catch (IOException e3) {
            throw new IOError(e3);
        }
    }

    public int peekCharacter(long timeout) {
        if (!this.pushBackChar.isEmpty()) {
            return this.pushBackChar.peek();
        }
        try {
            return this.reader.peek(timeout);
        }
        catch (IOException e2) {
            throw new IOError(e2);
        }
    }

    public void runMacro(String macro) {
        macro.codePoints().forEachOrdered(this.pushBackChar::addLast);
    }

    public String getLastBinding() {
        return this.lastBinding;
    }
}

