/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.gradle.dsl

import org.gradle.api.NamedDomainObjectContainer
import org.gradle.api.NamedDomainObjectProvider
import org.jetbrains.kotlin.gradle.ExperimentalWasmDsl
import org.jetbrains.kotlin.gradle.plugin.KotlinDependencyHandler
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet
import org.jetbrains.kotlin.gradle.plugin.LanguageSettingsBuilder
import org.jetbrains.kotlin.konan.target.DEPRECATED_TARGET_MESSAGE

/**
 * Provides static accessors for source set conventions
 */
interface KotlinMultiplatformSourceSetConventions {
    // region Common Source Set Accessors

    // DO NOT EDIT MANUALLY! Generated by org.jetbrains.kotlin.generators.gradle.dsl.MppSourceSetConventionsCodegenKt

    /**
     * Static accessor for shared kotlin Source Set between all declared targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    jvm()
     *    iosX64()
     *
     *    sourceSets {
     *      commonMain.dependencies {
     *          // Add commonMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.commonMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    jvm()
     *    iosX64()
     *
     *    sourceSets {
     *      commonTest.dependencies {
     *          // Add commonTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.commonTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared native targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxX64()
     *    iosX64()
     *
     *    sourceSets {
     *      nativeMain.dependencies {
     *          // Add nativeMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.nativeMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared native targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxX64()
     *    iosX64()
     *
     *    sourceSets {
     *      nativeTest.dependencies {
     *          // Add nativeTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.nativeTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Apple targets (ios, macos, watchos, tvos).
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosX64()
     *    macosX64()
     *
     *    sourceSets {
     *      appleMain.dependencies {
     *          // Add appleMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.appleMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Apple targets (ios, macos, watchos, tvos).
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosX64()
     *    macosX64()
     *
     *    sourceSets {
     *      appleTest.dependencies {
     *          // Add appleTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.appleTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared iOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosX64()
     *    iosArm64()
     *
     *    sourceSets {
     *      iosMain.dependencies {
     *          // Add iosMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared iOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosX64()
     *    iosArm64()
     *
     *    sourceSets {
     *      iosTest.dependencies {
     *          // Add iosTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared tvOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosX64()
     *    tvosArm64()
     *
     *    sourceSets {
     *      tvosMain.dependencies {
     *          // Add tvosMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared tvOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosX64()
     *    tvosArm64()
     *
     *    sourceSets {
     *      tvosTest.dependencies {
     *          // Add tvosTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared watchOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosX64()
     *    watchosArm64()
     *
     *    sourceSets {
     *      watchosMain.dependencies {
     *          // Add watchosMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared watchOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosX64()
     *    watchosArm64()
     *
     *    sourceSets {
     *      watchosTest.dependencies {
     *          // Add watchosTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared macOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    macosX64()
     *    macosArm64()
     *
     *    sourceSets {
     *      macosMain.dependencies {
     *          // Add macosMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.macosMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared macOS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    macosX64()
     *    macosArm64()
     *
     *    sourceSets {
     *      macosTest.dependencies {
     *          // Add macosTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.macosTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Linux targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxX64()
     *    linuxArm64()
     *
     *    sourceSets {
     *      linuxMain.dependencies {
     *          // Add linuxMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Linux targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxX64()
     *    linuxArm64()
     *
     *    sourceSets {
     *      linuxTest.dependencies {
     *          // Add linuxTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Mingw targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    mingwX64()
     *    mingwX86()
     *
     *    sourceSets {
     *      mingwMain.dependencies {
     *          // Add mingwMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.mingwMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Mingw targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    mingwX64()
     *    mingwX86()
     *
     *    sourceSets {
     *      mingwTest.dependencies {
     *          // Add mingwTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.mingwTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Android Native targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeX64()
     *    androidNativeArm64()
     *
     *    sourceSets {
     *      androidNativeMain.dependencies {
     *          // Add androidNativeMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared Android Native targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeX64()
     *    androidNativeArm64()
     *
     *    sourceSets {
     *      androidNativeTest.dependencies {
     *          // Add androidNativeTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared JS and WasmJS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    js()
     *    wasmJs()
     *
     *    sourceSets {
     *      webMain.dependencies {
     *          // Add webMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.webMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for shared kotlin Source Set between all declared JS and WasmJS targets.
     * Declare at least one of the targets mentioned above to access this source set.
     * If no targets were declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    js()
     *    wasmJs()
     *
     *    sourceSets {
     *      webTest.dependencies {
     *          // Add webTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.webTest: NamedDomainObjectProvider<KotlinSourceSet>

    // endregion

    // region Non-Native Source Set Accessors

    // DO NOT EDIT MANUALLY! Generated by org.jetbrains.kotlin.generators.gradle.dsl.MppSourceSetConventionsCodegenKt

    /**
     * Static accessor for the main Kotlin Source Set of js target.
     * Declare js target to access this source set.
     * If js target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    js() // Target is declared, jsMain source set is created
     *
     *    sourceSets {
     *      jsMain.dependencies {
     *          // Add jsMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.jsMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of js target.
     * Declare js target to access this source set.
     * If js target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    js() // Target is declared, jsTest source set is created
     *
     *    sourceSets {
     *      jsTest.dependencies {
     *          // Add jsTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.jsTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of jvm target.
     * Declare jvm target to access this source set.
     * If jvm target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    jvm() // Target is declared, jvmMain source set is created
     *
     *    sourceSets {
     *      jvmMain.dependencies {
     *          // Add jvmMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.jvmMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of jvm target.
     * Declare jvm target to access this source set.
     * If jvm target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    jvm() // Target is declared, jvmTest source set is created
     *
     *    sourceSets {
     *      jvmTest.dependencies {
     *          // Add jvmTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.jvmTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of wasmJs target.
     * Declare wasmJs target to access this source set.
     * If wasmJs target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    wasmJs() // Target is declared, wasmJsMain source set is created
     *
     *    sourceSets {
     *      wasmJsMain.dependencies {
     *          // Add wasmJsMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    @ExperimentalWasmDsl
    val NamedDomainObjectContainer<KotlinSourceSet>.wasmJsMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of wasmJs target.
     * Declare wasmJs target to access this source set.
     * If wasmJs target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    wasmJs() // Target is declared, wasmJsTest source set is created
     *
     *    sourceSets {
     *      wasmJsTest.dependencies {
     *          // Add wasmJsTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    @ExperimentalWasmDsl
    val NamedDomainObjectContainer<KotlinSourceSet>.wasmJsTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of wasmWasi target.
     * Declare wasmWasi target to access this source set.
     * If wasmWasi target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    wasmWasi() // Target is declared, wasmWasiMain source set is created
     *
     *    sourceSets {
     *      wasmWasiMain.dependencies {
     *          // Add wasmWasiMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    @ExperimentalWasmDsl
    val NamedDomainObjectContainer<KotlinSourceSet>.wasmWasiMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of wasmWasi target.
     * Declare wasmWasi target to access this source set.
     * If wasmWasi target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    wasmWasi() // Target is declared, wasmWasiTest source set is created
     *
     *    sourceSets {
     *      wasmWasiTest.dependencies {
     *          // Add wasmWasiTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    @ExperimentalWasmDsl
    val NamedDomainObjectContainer<KotlinSourceSet>.wasmWasiTest: NamedDomainObjectProvider<KotlinSourceSet>

    // endregion

    // region Native Source Set Accessors

    // DO NOT EDIT MANUALLY! Generated by org.jetbrains.kotlin.generators.gradle.dsl.MppSourceSetConventionsCodegenKt

    /**
     * Static accessor for the main Kotlin Source Set of androidNativeArm32 target.
     * Declare androidNativeArm32 target to access this source set.
     * If androidNativeArm32 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeArm32() // Target is declared, androidNativeArm32Main source set is created
     *
     *    sourceSets {
     *      androidNativeArm32Main.dependencies {
     *          // Add androidNativeArm32Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeArm32Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of androidNativeArm32 target.
     * Declare androidNativeArm32 target to access this source set.
     * If androidNativeArm32 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeArm32() // Target is declared, androidNativeArm32Test source set is created
     *
     *    sourceSets {
     *      androidNativeArm32Test.dependencies {
     *          // Add androidNativeArm32Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeArm32Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of androidNativeArm64 target.
     * Declare androidNativeArm64 target to access this source set.
     * If androidNativeArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeArm64() // Target is declared, androidNativeArm64Main source set is created
     *
     *    sourceSets {
     *      androidNativeArm64Main.dependencies {
     *          // Add androidNativeArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of androidNativeArm64 target.
     * Declare androidNativeArm64 target to access this source set.
     * If androidNativeArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeArm64() // Target is declared, androidNativeArm64Test source set is created
     *
     *    sourceSets {
     *      androidNativeArm64Test.dependencies {
     *          // Add androidNativeArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of androidNativeX64 target.
     * Declare androidNativeX64 target to access this source set.
     * If androidNativeX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeX64() // Target is declared, androidNativeX64Main source set is created
     *
     *    sourceSets {
     *      androidNativeX64Main.dependencies {
     *          // Add androidNativeX64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeX64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of androidNativeX64 target.
     * Declare androidNativeX64 target to access this source set.
     * If androidNativeX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeX64() // Target is declared, androidNativeX64Test source set is created
     *
     *    sourceSets {
     *      androidNativeX64Test.dependencies {
     *          // Add androidNativeX64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeX64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of androidNativeX86 target.
     * Declare androidNativeX86 target to access this source set.
     * If androidNativeX86 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeX86() // Target is declared, androidNativeX86Main source set is created
     *
     *    sourceSets {
     *      androidNativeX86Main.dependencies {
     *          // Add androidNativeX86Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeX86Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of androidNativeX86 target.
     * Declare androidNativeX86 target to access this source set.
     * If androidNativeX86 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidNativeX86() // Target is declared, androidNativeX86Test source set is created
     *
     *    sourceSets {
     *      androidNativeX86Test.dependencies {
     *          // Add androidNativeX86Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidNativeX86Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of iosArm64 target.
     * Declare iosArm64 target to access this source set.
     * If iosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosArm64() // Target is declared, iosArm64Main source set is created
     *
     *    sourceSets {
     *      iosArm64Main.dependencies {
     *          // Add iosArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of iosArm64 target.
     * Declare iosArm64 target to access this source set.
     * If iosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosArm64() // Target is declared, iosArm64Test source set is created
     *
     *    sourceSets {
     *      iosArm64Test.dependencies {
     *          // Add iosArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of iosSimulatorArm64 target.
     * Declare iosSimulatorArm64 target to access this source set.
     * If iosSimulatorArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosSimulatorArm64() // Target is declared, iosSimulatorArm64Main source set is created
     *
     *    sourceSets {
     *      iosSimulatorArm64Main.dependencies {
     *          // Add iosSimulatorArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosSimulatorArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of iosSimulatorArm64 target.
     * Declare iosSimulatorArm64 target to access this source set.
     * If iosSimulatorArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosSimulatorArm64() // Target is declared, iosSimulatorArm64Test source set is created
     *
     *    sourceSets {
     *      iosSimulatorArm64Test.dependencies {
     *          // Add iosSimulatorArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosSimulatorArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of iosX64 target.
     * Declare iosX64 target to access this source set.
     * If iosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosX64() // Target is declared, iosX64Main source set is created
     *
     *    sourceSets {
     *      iosX64Main.dependencies {
     *          // Add iosX64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosX64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of iosX64 target.
     * Declare iosX64 target to access this source set.
     * If iosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosX64() // Target is declared, iosX64Test source set is created
     *
     *    sourceSets {
     *      iosX64Test.dependencies {
     *          // Add iosX64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.iosX64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of linuxArm32Hfp target.
     * Declare linuxArm32Hfp target to access this source set.
     * If linuxArm32Hfp target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxArm32Hfp() // Target is declared, linuxArm32HfpMain source set is created
     *
     *    sourceSets {
     *      linuxArm32HfpMain.dependencies {
     *          // Add linuxArm32HfpMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    @Deprecated(DEPRECATED_TARGET_MESSAGE, level = DeprecationLevel.WARNING)
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxArm32HfpMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of linuxArm32Hfp target.
     * Declare linuxArm32Hfp target to access this source set.
     * If linuxArm32Hfp target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxArm32Hfp() // Target is declared, linuxArm32HfpTest source set is created
     *
     *    sourceSets {
     *      linuxArm32HfpTest.dependencies {
     *          // Add linuxArm32HfpTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    @Deprecated(DEPRECATED_TARGET_MESSAGE, level = DeprecationLevel.WARNING)
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxArm32HfpTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of linuxArm64 target.
     * Declare linuxArm64 target to access this source set.
     * If linuxArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxArm64() // Target is declared, linuxArm64Main source set is created
     *
     *    sourceSets {
     *      linuxArm64Main.dependencies {
     *          // Add linuxArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of linuxArm64 target.
     * Declare linuxArm64 target to access this source set.
     * If linuxArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxArm64() // Target is declared, linuxArm64Test source set is created
     *
     *    sourceSets {
     *      linuxArm64Test.dependencies {
     *          // Add linuxArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of linuxX64 target.
     * Declare linuxX64 target to access this source set.
     * If linuxX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxX64() // Target is declared, linuxX64Main source set is created
     *
     *    sourceSets {
     *      linuxX64Main.dependencies {
     *          // Add linuxX64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxX64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of linuxX64 target.
     * Declare linuxX64 target to access this source set.
     * If linuxX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    linuxX64() // Target is declared, linuxX64Test source set is created
     *
     *    sourceSets {
     *      linuxX64Test.dependencies {
     *          // Add linuxX64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.linuxX64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of macosArm64 target.
     * Declare macosArm64 target to access this source set.
     * If macosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    macosArm64() // Target is declared, macosArm64Main source set is created
     *
     *    sourceSets {
     *      macosArm64Main.dependencies {
     *          // Add macosArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.macosArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of macosArm64 target.
     * Declare macosArm64 target to access this source set.
     * If macosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    macosArm64() // Target is declared, macosArm64Test source set is created
     *
     *    sourceSets {
     *      macosArm64Test.dependencies {
     *          // Add macosArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.macosArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of macosX64 target.
     * Declare macosX64 target to access this source set.
     * If macosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    macosX64() // Target is declared, macosX64Main source set is created
     *
     *    sourceSets {
     *      macosX64Main.dependencies {
     *          // Add macosX64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.macosX64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of macosX64 target.
     * Declare macosX64 target to access this source set.
     * If macosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    macosX64() // Target is declared, macosX64Test source set is created
     *
     *    sourceSets {
     *      macosX64Test.dependencies {
     *          // Add macosX64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.macosX64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of mingwX64 target.
     * Declare mingwX64 target to access this source set.
     * If mingwX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    mingwX64() // Target is declared, mingwX64Main source set is created
     *
     *    sourceSets {
     *      mingwX64Main.dependencies {
     *          // Add mingwX64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.mingwX64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of mingwX64 target.
     * Declare mingwX64 target to access this source set.
     * If mingwX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    mingwX64() // Target is declared, mingwX64Test source set is created
     *
     *    sourceSets {
     *      mingwX64Test.dependencies {
     *          // Add mingwX64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.mingwX64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of tvosArm64 target.
     * Declare tvosArm64 target to access this source set.
     * If tvosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosArm64() // Target is declared, tvosArm64Main source set is created
     *
     *    sourceSets {
     *      tvosArm64Main.dependencies {
     *          // Add tvosArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of tvosArm64 target.
     * Declare tvosArm64 target to access this source set.
     * If tvosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosArm64() // Target is declared, tvosArm64Test source set is created
     *
     *    sourceSets {
     *      tvosArm64Test.dependencies {
     *          // Add tvosArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of tvosSimulatorArm64 target.
     * Declare tvosSimulatorArm64 target to access this source set.
     * If tvosSimulatorArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosSimulatorArm64() // Target is declared, tvosSimulatorArm64Main source set is created
     *
     *    sourceSets {
     *      tvosSimulatorArm64Main.dependencies {
     *          // Add tvosSimulatorArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosSimulatorArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of tvosSimulatorArm64 target.
     * Declare tvosSimulatorArm64 target to access this source set.
     * If tvosSimulatorArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosSimulatorArm64() // Target is declared, tvosSimulatorArm64Test source set is created
     *
     *    sourceSets {
     *      tvosSimulatorArm64Test.dependencies {
     *          // Add tvosSimulatorArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosSimulatorArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of tvosX64 target.
     * Declare tvosX64 target to access this source set.
     * If tvosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosX64() // Target is declared, tvosX64Main source set is created
     *
     *    sourceSets {
     *      tvosX64Main.dependencies {
     *          // Add tvosX64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosX64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of tvosX64 target.
     * Declare tvosX64 target to access this source set.
     * If tvosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    tvosX64() // Target is declared, tvosX64Test source set is created
     *
     *    sourceSets {
     *      tvosX64Test.dependencies {
     *          // Add tvosX64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.tvosX64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of watchosArm32 target.
     * Declare watchosArm32 target to access this source set.
     * If watchosArm32 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosArm32() // Target is declared, watchosArm32Main source set is created
     *
     *    sourceSets {
     *      watchosArm32Main.dependencies {
     *          // Add watchosArm32Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosArm32Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of watchosArm32 target.
     * Declare watchosArm32 target to access this source set.
     * If watchosArm32 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosArm32() // Target is declared, watchosArm32Test source set is created
     *
     *    sourceSets {
     *      watchosArm32Test.dependencies {
     *          // Add watchosArm32Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosArm32Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of watchosArm64 target.
     * Declare watchosArm64 target to access this source set.
     * If watchosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosArm64() // Target is declared, watchosArm64Main source set is created
     *
     *    sourceSets {
     *      watchosArm64Main.dependencies {
     *          // Add watchosArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of watchosArm64 target.
     * Declare watchosArm64 target to access this source set.
     * If watchosArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosArm64() // Target is declared, watchosArm64Test source set is created
     *
     *    sourceSets {
     *      watchosArm64Test.dependencies {
     *          // Add watchosArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of watchosDeviceArm64 target.
     * Declare watchosDeviceArm64 target to access this source set.
     * If watchosDeviceArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosDeviceArm64() // Target is declared, watchosDeviceArm64Main source set is created
     *
     *    sourceSets {
     *      watchosDeviceArm64Main.dependencies {
     *          // Add watchosDeviceArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosDeviceArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of watchosDeviceArm64 target.
     * Declare watchosDeviceArm64 target to access this source set.
     * If watchosDeviceArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosDeviceArm64() // Target is declared, watchosDeviceArm64Test source set is created
     *
     *    sourceSets {
     *      watchosDeviceArm64Test.dependencies {
     *          // Add watchosDeviceArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosDeviceArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of watchosSimulatorArm64 target.
     * Declare watchosSimulatorArm64 target to access this source set.
     * If watchosSimulatorArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosSimulatorArm64() // Target is declared, watchosSimulatorArm64Main source set is created
     *
     *    sourceSets {
     *      watchosSimulatorArm64Main.dependencies {
     *          // Add watchosSimulatorArm64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosSimulatorArm64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of watchosSimulatorArm64 target.
     * Declare watchosSimulatorArm64 target to access this source set.
     * If watchosSimulatorArm64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosSimulatorArm64() // Target is declared, watchosSimulatorArm64Test source set is created
     *
     *    sourceSets {
     *      watchosSimulatorArm64Test.dependencies {
     *          // Add watchosSimulatorArm64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosSimulatorArm64Test: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the main Kotlin Source Set of watchosX64 target.
     * Declare watchosX64 target to access this source set.
     * If watchosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosX64() // Target is declared, watchosX64Main source set is created
     *
     *    sourceSets {
     *      watchosX64Main.dependencies {
     *          // Add watchosX64Main dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosX64Main: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the test Kotlin Source Set of watchosX64 target.
     * Declare watchosX64 target to access this source set.
     * If watchosX64 target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    watchosX64() // Target is declared, watchosX64Test source set is created
     *
     *    sourceSets {
     *      watchosX64Test.dependencies {
     *          // Add watchosX64Test dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.watchosX64Test: NamedDomainObjectProvider<KotlinSourceSet>

    // endregion

    /**
     * Static accessor for the main Kotlin Source Set of android target.
     * Declare android target to access this source set.
     * If android target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidTarget() // Target is declared, androidMain source set is created
     *
     *    sourceSets {
     *      androidMain.dependencies {
     *          // Add androidMain dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidMain: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the unit test Kotlin Source Set of android target.
     * Declare android target to access this source set.
     * If android target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidTarget() // Target is declared, androidUnitTest source set is created
     *
     *    sourceSets {
     *      androidUnitTest.dependencies {
     *          // Add androidUnitTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidUnitTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Static accessor for the instrumented test Kotlin Source Set of android target.
     * Declare android target to access this source set.
     * If android target wasn't declared, accessing this source set will cause a runtime error during configuration time.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    androidTarget() // Target is declared, androidInstrumentedTest source set is created
     *
     *    sourceSets {
     *      androidInstrumentedTest.dependencies {
     *          // Add androidUnitTest dependencies here
     *      }
     *    }
     * }
     * ```
     *
     * @since 2.0.20
     */
    val NamedDomainObjectContainer<KotlinSourceSet>.androidInstrumentedTest: NamedDomainObjectProvider<KotlinSourceSet>

    /**
     * Configure [KotlinSourceSet] provider with [configure] code block.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    iosX64()
     *    iosArm64()
     *
     *    sourceSets {
     *      nativeMain { /* this: KotlinSourceSet */
     *          kotlin.srcDir("src/native")
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    operator fun NamedDomainObjectProvider<KotlinSourceSet>.invoke(
        configure: KotlinSourceSet.() -> Unit,
    ): Unit = get().run(configure)

    /**
     * Configure [KotlinSourceSet] dependencies with [handler] code block.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    jvm()
     *    iosX64()
     *    iosArm64()
     *
     *    sourceSets {
     *      commonMain.dependencies {
     *          api("org.jetbrains.kotlinx:kotlinx-coroutines-core")
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    fun NamedDomainObjectProvider<KotlinSourceSet>.dependencies(
        handler: KotlinDependencyHandler.() -> Unit,
    ): Unit = get().dependencies(handler)

    /**
     * Configure [KotlinSourceSet] language settings with [configure] code block.
     *
     * Sample:
     *
     * ```kotlin
     * kotlin {
     *    jvm()
     *    iosX64()
     *    iosArm64()
     *
     *    sourceSets {
     *      commonMain.languageSettings {
     *          progressiveMode = true
     *      }
     *    }
     * }
     * ```
     *
     * @since 1.9.20
     */
    fun NamedDomainObjectProvider<KotlinSourceSet>.languageSettings(
        configure: LanguageSettingsBuilder.() -> Unit,
    ): Unit = this { languageSettings(configure) }
}

