/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsExtensionKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProject;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectModules;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmResolver;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003*\u0001\u0010\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020\fH\u0002J\u000e\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\fJ\u0017\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020\fH\u0016J/\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\f2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f00\"\u00020\f\u00a2\u0006\u0002\u00101R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject;", "", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "dir", "Ljava/io/File;", "getDir", "()Ljava/io/File;", "main", "", "getMain", "()Ljava/lang/String;", "modules", "org/jetbrains/kotlin/gradle/targets/js/npm/NpmProject$modules$1", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject$modules$1;", "name", "getName", "nodeModulesDir", "getNodeModulesDir", "packageJsonFile", "getPackageJsonFile", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "rootNodeModules", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "getRootNodeModules", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "getTarget", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "buildNpmProjectName", "require", "request", "resolve", "resolve$kotlin_gradle_plugin", "toString", "useTool", "", "exec", "Lorg/gradle/process/ExecSpec;", "tool", "args", "", "(Lorg/gradle/process/ExecSpec;Ljava/lang/String;[Ljava/lang/String;)V", "Companion", "kotlin-gradle-plugin"})
public class NpmProject {
    private final modules.1 modules;
    @NotNull
    private final KotlinJsCompilation compilation;
    @NotNull
    public static final String PACKAGE_JSON = "package.json";
    @NotNull
    public static final String NODE_MODULES = "node_modules";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getName() {
        return this.buildNpmProjectName();
    }

    @NotNull
    public final File getDir() {
        return FilesKt.resolve((File)NodeJsExtensionKt.getNodeJs(this.getProject()).getRoot().getProjectPackagesDir(), (String)this.getName());
    }

    @NotNull
    public final KotlinTarget getTarget() {
        return this.compilation.getTarget();
    }

    @NotNull
    public final Project getProject() {
        return this.getTarget().getProject();
    }

    @NotNull
    public final File getNodeModulesDir() {
        return FilesKt.resolve((File)this.getDir(), (String)NODE_MODULES);
    }

    @NotNull
    public final File getPackageJsonFile() {
        return FilesKt.resolve((File)this.getDir(), (String)PACKAGE_JSON);
    }

    @NotNull
    public final String getMain() {
        return "kotlin/" + this.getName() + ".js";
    }

    private final NpmProjectModules getRootNodeModules() {
        return new NpmProjectModules(NodeJsExtensionKt.getNodeJs(this.getProject()).getRoot().getRootPackageDir(), null, 2, null);
    }

    public final void useTool(@NotNull ExecSpec exec2, @NotNull String tool, String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)exec2, (String)"exec");
        Intrinsics.checkParameterIsNotNull((Object)tool, (String)"tool");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        exec2.setWorkingDir(this.getDir());
        exec2.setExecutable(NodeJsExtensionKt.getNodeJs(this.getProject()).getRoot().getEnvironment$kotlin_gradle_plugin().getNodeExecutable());
        exec2.setArgs(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.require(tool)), (Object[])args));
    }

    @NotNull
    public final String require(@NotNull String request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        NpmResolver.Companion.requireResolved$default(NpmResolver.Companion, this.getProject(), null, 2, null);
        return this.modules.require(request);
    }

    @Nullable
    public final File resolve$kotlin_gradle_plugin(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return NpmProjectModules.resolve$kotlin_gradle_plugin$default(this.modules, name2, null, 2, null);
    }

    private final String buildNpmProjectName() {
        Project project = this.getTarget().getProject();
        StringBuilder name2 = new StringBuilder();
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        name2.append(project2.getName());
        if (Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ^ true) {
            name2.append("-");
            name2.append(project.getName());
        }
        CharSequence charSequence = this.getTarget().getName();
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = this.getTarget().getName();
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)charSequence2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual((Object)string, (Object)"js") ^ true) {
                name2.append("-").append(this.getTarget().getName());
            }
        }
        if (Intrinsics.areEqual((Object)this.compilation.getName(), (Object)"main") ^ true) {
            name2.append("-").append(this.compilation.getName());
        }
        String string = name2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return "NpmProject(" + this.getName() + ')';
    }

    @NotNull
    public final KotlinJsCompilation getCompilation() {
        return this.compilation;
    }

    public NpmProject(@NotNull KotlinJsCompilation compilation) {
        Intrinsics.checkParameterIsNotNull((Object)compilation, (String)"compilation");
        this.compilation = compilation;
        this.modules = new NpmProjectModules(this, this.getDir(), this.getNodeModulesDir()){
            final /* synthetic */ NpmProject this$0;

            @Nullable
            public NpmProjectModules getParent() {
                return NpmProject.access$getRootNodeModules$p(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ NpmProjectModules access$getRootNodeModules$p(NpmProject $this) {
        return $this.getRootNodeModules();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject$Companion;", "", "()V", "NODE_MODULES", "", "PACKAGE_JSON", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

