/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.performance;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.performance.TaskTime;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/performance/TaskTimerListener;", "Lorg/gradle/api/execution/TaskExecutionListener;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "tasksTimes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/kotlin/gradle/plugin/performance/TaskTime;", "getTasksTimes", "()Ljava/util/concurrent/ConcurrentHashMap;", "afterExecute", "", "task", "Lorg/gradle/api/Task;", "taskState", "Lorg/gradle/api/tasks/TaskState;", "beforeExecute", "getTime", "", "taskName", "Companion", "kotlin-gradle-plugin"})
public final class TaskTimerListener
implements TaskExecutionListener {
    @NotNull
    private final ConcurrentHashMap<String, TaskTime> tasksTimes;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConcurrentHashMap<String, TaskTime> getTasksTimes() {
        return this.tasksTimes;
    }

    public final double getTime(@NotNull String taskName) {
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        Object object = this.tasksTimes.get(taskName);
        return object != null && (object = ((TaskTime)object).getDuration()) != null ? (Double)object : 0.0;
    }

    public void beforeExecute(@NotNull Task task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Map map = this.tasksTimes;
        String string = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.path");
        map.put(string, new TaskTime(System.nanoTime()));
    }

    public void afterExecute(@NotNull Task task, @NotNull TaskState taskState) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)taskState, (String)"taskState");
        Map map = this.tasksTimes;
        String string = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.path");
        TaskTime taskTime = (TaskTime)MapsKt.getValue((Map)map, (Object)string);
        taskTime.setDuration((double)(System.nanoTime() - taskTime.getStartTime()) / 1000.0);
    }

    public TaskTimerListener(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.tasksTimes = TaskTimerListener.Companion.getOrRegisterStorage(project, "org.jetbrains.kotlin.native.taskTimes");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/performance/TaskTimerListener$Companion;", "", "()V", "getOrRegisterStorage", "Ljava/util/concurrent/ConcurrentHashMap;", "K", "V", "project", "Lorg/gradle/api/Project;", "propertyName", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final <K, V> ConcurrentHashMap<K, V> getOrRegisterStorage(Project project, String propertyName) {
            Project project2 = project.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
            Object object = project2.getExtensions().getByType(ExtraPropertiesExtension.class);
            boolean bl = false;
            boolean bl2 = false;
            ExtraPropertiesExtension $receiver = (ExtraPropertiesExtension)object;
            boolean bl3 = false;
            if (!$receiver.has(propertyName)) {
                $receiver.set(propertyName, new ConcurrentHashMap());
            }
            Object object2 = $receiver.get(propertyName);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.ConcurrentHashMap<K, V>");
            }
            return (ConcurrentHashMap)object2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

