/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import com.github.gundy.semver4j.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnLock;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEntryRegistry;", "", "lockFile", "Ljava/io/File;", "(Ljava/io/File;)V", "entryMap", "", "", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnLock$Entry;", "dependencyKey", "getDependencyKey", "(Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnLock$Entry;)Ljava/lang/String;", "packageKey", "version", "find", "correctDependencyKey", "kotlin-gradle-plugin"})
public final class YarnEntryRegistry {
    private final Map<String, YarnLock.Entry> entryMap;
    private final File lockFile;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YarnLock.Entry find(@NotNull String packageKey, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)packageKey, (String)"packageKey");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        String key = this.dependencyKey(packageKey, version);
        YarnLock.Entry entry = this.entryMap.get(key);
        if (entry == null && Intrinsics.areEqual((Object)version, (Object)"*")) {
            Object v0;
            block4: {
                void $this$filterTo$iv$iv;
                String searchKey = this.dependencyKey(packageKey, "");
                Iterable $this$filter$iv = this.entryMap.entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)((String)it.getKey()), (String)searchKey, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!SemVer.satisfies((String)StringsKt.removePrefix((String)((String)it.getKey()), (CharSequence)searchKey), (String)"*")) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Map.Entry entry2 = v0;
            entry = entry2 != null ? (YarnLock.Entry)entry2.getValue() : null;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (entry == null) {
            boolean bl3 = false;
            String string = "Cannot find " + key + " in yarn.lock";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return entry;
    }

    private final String getDependencyKey(YarnLock.Entry $receiver) {
        return this.correctDependencyKey($receiver.getKey());
    }

    private final String dependencyKey(String packageKey, String version) {
        return this.correctDependencyKey(YarnLock.Companion.dependencyKey(packageKey, version));
    }

    private final String correctDependencyKey(String $receiver) {
        String string;
        if (StringsKt.contains$default((CharSequence)$receiver, (CharSequence)"@github:", (boolean)false, (int)2, null)) {
            string = StringsKt.replace$default((String)$receiver, (String)"@github:", (String)"@", (boolean)false, (int)4, null);
        } else if (StringsKt.contains$default((CharSequence)$receiver, (CharSequence)"@file:", (boolean)false, (int)2, null)) {
            String path;
            String location = StringsKt.substringAfter$default((String)$receiver, (String)"@file:", null, (int)2, null);
            File file = this.lockFile.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lockFile\n                    .parentFile");
            String string2 = path = FilesKt.resolve((File)file, (String)location).getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
            string = StringsKt.replaceAfter$default((String)$receiver, (String)"@file:", (String)string2, null, (int)4, null);
        } else {
            string = $receiver;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public YarnEntryRegistry(@NotNull File lockFile) {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkParameterIsNotNull((Object)lockFile, (String)"lockFile");
        this.lockFile = lockFile;
        Iterable iterable = YarnLock.Companion.parse(this.lockFile).getEntries();
        YarnEntryRegistry yarnEntryRegistry = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            YarnLock.Entry entry = (YarnLock.Entry)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            String string = this.getDependencyKey((YarnLock.Entry)it);
            map.put(string, element$iv$iv);
        }
        yarnEntryRegistry.entryMap = map = destination$iv$iv;
    }
}

