/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.js.npm.AbstractNodeModulesCacheKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.CompositeNodeModuleBuilderKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.CompositeNodeModulesCache;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJsonKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.SemverKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModuleBuilder;", "", "project", "Lorg/gradle/api/Project;", "srcDir", "Ljava/io/File;", "cache", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModulesCache;", "(Lorg/gradle/api/Project;Ljava/io/File;Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModulesCache;)V", "getCache", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModulesCache;", "getProject", "()Lorg/gradle/api/Project;", "getSrcDir", "()Ljava/io/File;", "srcPackageJsonFile", "getSrcPackageJsonFile", "setSrcPackageJsonFile", "(Ljava/io/File;)V", "rebuild", "kotlin-gradle-plugin"})
public final class CompositeNodeModuleBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final File srcDir;
    @NotNull
    private final CompositeNodeModulesCache cache;
    @NotNull
    private File srcPackageJsonFile;

    public CompositeNodeModuleBuilder(@NotNull Project project, @NotNull File srcDir2, @NotNull CompositeNodeModulesCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)srcDir2, (String)"srcDir");
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.project = project;
        this.srcDir = srcDir2;
        this.cache = cache;
        this.srcPackageJsonFile = this.srcDir;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getSrcDir() {
        return this.srcDir;
    }

    @NotNull
    public final CompositeNodeModulesCache getCache() {
        return this.cache;
    }

    @NotNull
    public final File getSrcPackageJsonFile() {
        return this.srcPackageJsonFile;
    }

    public final void setSrcPackageJsonFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.srcPackageJsonFile = file;
    }

    @Nullable
    public final File rebuild() {
        File file;
        String string;
        boolean bl = this.srcPackageJsonFile.isFile();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unable to read package.json of composite build";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        PackageJson packageJson2 = PackageJsonKt.fromSrcPackageJson(this.srcPackageJsonFile);
        if (packageJson2 == null) {
            Intrinsics.throwNpe();
        }
        PackageJson packageJson3 = packageJson2;
        packageJson3.setVersion(SemverKt.fixSemver(packageJson3.getVersion()));
        File container = this.cache.getDir$kotlin_gradle_plugin();
        File importedPackageDir = AbstractNodeModulesCacheKt.importedPackageDir(container, packageJson3.getName(), packageJson3.getVersion());
        Object object = this.srcDir.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"srcDir.parentFile");
        File file2 = object;
        object = packageJson3.getMain();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        String string3 = string = (file = FilesKt.relativeToOrNull((File)FilesKt.resolve((File)file2, (String)object), (File)importedPackageDir)) == null ? null : file.getPath();
        if (string == null) {
            throw new IllegalStateException("Unable to link composite builds for Kotlin/JS which have different roots");
        }
        packageJson3.setMain(string);
        return CompositeNodeModuleBuilderKt.access$makeNodeModule(container, packageJson3);
    }
}

