/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinSingleTargetExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import org.jetbrains.kotlin.gradle.targets.js.KotlinJsTarget;
import org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import org.jetbrains.kotlin.gradle.targets.js.ir.KotlinJsIrCompilation;
import org.jetbrains.kotlin.gradle.targets.js.ir.KotlinJsIrTarget;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.npm.RequiresNpmDependencies;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolved.KotlinCompilationNpmResolution;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolved.KotlinProjectNpmResolution;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolver.KotlinCompilationNpmResolver;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolver.KotlinProjectNpmResolverKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolver.KotlinRootNpmResolver;
import org.jetbrains.kotlin.gradle.targets.js.npm.tasks.KotlinPackageJsonTask;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTest;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0011\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\tH\u0086\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolver/KotlinProjectNpmResolver;", "", "project", "Lorg/gradle/api/Project;", "resolver", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolver/KotlinRootNpmResolver;", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolver/KotlinRootNpmResolver;)V", "byCompilation", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolver/KotlinCompilationNpmResolver;", "closed", "", "compilationResolvers", "", "getCompilationResolvers", "()Ljava/util/Collection;", "getProject", "()Lorg/gradle/api/Project;", "getResolver", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolver/KotlinRootNpmResolver;", "addCompilation", "", "compilation", "addContainerListeners", "addTargetListeners", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "close", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolved/KotlinProjectNpmResolution;", "get", "toString", "", "kotlin-gradle-plugin"})
public final class KotlinProjectNpmResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinRootNpmResolver resolver;
    @NotNull
    private final Map<KotlinJsCompilation, KotlinCompilationNpmResolver> byCompilation;
    private boolean closed;

    public KotlinProjectNpmResolver(@NotNull Project project, @NotNull KotlinRootNpmResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        this.project = project;
        this.resolver = resolver;
        boolean bl = false;
        this.byCompilation = new LinkedHashMap();
        this.addContainerListeners();
        KotlinMultiplatformPluginKt.whenEvaluated(this.project, (Function1)new Function1<Project, Unit>(){

            public final void invoke(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"<this>");
                final NodeJsRootExtension nodeJs = this.getResolver().getNodeJs();
                TaskContainer taskContainer = project.getProject().getTasks();
                Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"project.tasks");
                KotlinProjectNpmResolverKt.implementing((TaskCollection)taskContainer, Reflection.getOrCreateKotlinClass(RequiresNpmDependencies.class)).configureEach((Action)new Action<Task>(){

                    public final void execute(Task task) {
                        if (task.getEnabled()) {
                            if (task == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.npm.RequiresNpmDependencies");
                            }
                            RequiresNpmDependencies cfr_ignored_0 = (RequiresNpmDependencies)task;
                            TaskProvider<KotlinPackageJsonTask> packageJsonTaskHolder = this.get(((RequiresNpmDependencies)task).getCompilation()).getPackageJsonTaskHolder();
                            if (!(task instanceof KotlinJsTest)) {
                                nodeJs.getTaskRequirements().addTaskRequirements((RequiresNpmDependencies)task);
                            }
                            Object[] objectArray = new Object[]{packageJsonTaskHolder};
                            task.dependsOn(objectArray);
                            objectArray = new Object[]{nodeJs.getNpmInstallTaskProvider()};
                            task.dependsOn(objectArray);
                        }
                    }
                });
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final KotlinRootNpmResolver getResolver() {
        return this.resolver;
    }

    @NotNull
    public String toString() {
        return "ProjectNpmResolver(" + this.project + ')';
    }

    @NotNull
    public final KotlinCompilationNpmResolver get(@NotNull KotlinJsCompilation compilation2) {
        Intrinsics.checkParameterIsNotNull((Object)compilation2, (String)"compilation");
        boolean bl = Intrinsics.areEqual((Object)compilation2.getTarget().getProject(), (Object)this.project);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinCompilationNpmResolver kotlinCompilationNpmResolver = this.byCompilation.get(compilation2);
        if (kotlinCompilationNpmResolver == null) {
            String string = compilation2 + " was not registered in " + this;
            bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return kotlinCompilationNpmResolver;
    }

    @NotNull
    public final Collection<KotlinCompilationNpmResolver> getCompilationResolvers() {
        return this.byCompilation.values();
    }

    private final void addContainerListeners() {
        KotlinProjectExtension kotlinProjectExtension = KotlinProjectExtensionKt.getKotlinExtensionOrNull(this.project);
        if (kotlinProjectExtension == null) {
            String string = "NpmResolverPlugin should be applied after kotlin plugin";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinProjectExtension kotlin = kotlinProjectExtension;
        if ((kotlinProjectExtension = kotlin) instanceof KotlinSingleTargetExtension) {
            this.addTargetListeners(((KotlinSingleTargetExtension)kotlin).getTarget());
        } else if (kotlinProjectExtension instanceof KotlinMultiplatformExtension) {
            ((KotlinMultiplatformExtension)kotlin).getTargets().all((Action)new Action<KotlinTarget>(this){
                final /* synthetic */ KotlinProjectNpmResolver this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void execute(KotlinTarget it) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    KotlinProjectNpmResolver.access$addTargetListeners(this.this$0, it);
                }
            });
        } else {
            String string = Intrinsics.stringPlus((String)"Unsupported kotlin model: ", (Object)kotlin);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void addTargetListeners(KotlinTarget target2) {
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = this.getResolver().alreadyResolvedMessage(Intrinsics.stringPlus((String)"add target ", (Object)target2));
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (target2.getPlatformType() == KotlinPlatformType.js) {
            NamedDomainObjectContainer namedDomainObjectContainer;
            KotlinJsIrTarget kotlinJsIrTarget;
            target2.getCompilations().all((Action)new Action<KotlinCompilation<? extends KotlinCommonOptions>>(this){
                final /* synthetic */ KotlinProjectNpmResolver this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void execute(KotlinCompilation<? extends KotlinCommonOptions> compilation2) {
                    if (compilation2 instanceof KotlinJsCompilation) {
                        KotlinProjectNpmResolver.access$addCompilation(this.this$0, (KotlinJsCompilation)compilation2);
                    }
                }
            });
            if (target2 instanceof KotlinJsTarget && (kotlinJsIrTarget = ((KotlinJsTarget)target2).getIrTarget()) != null && (namedDomainObjectContainer = kotlinJsIrTarget.getCompilations()) != null) {
                namedDomainObjectContainer.all((Action)new Action<KotlinJsIrCompilation>(this){
                    final /* synthetic */ KotlinProjectNpmResolver this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void execute(KotlinJsIrCompilation compilation2) {
                        if (compilation2 instanceof KotlinJsCompilation) {
                            KotlinProjectNpmResolver.access$addCompilation(this.this$0, compilation2);
                        }
                    }
                });
            }
        }
    }

    private final synchronized void addCompilation(KotlinJsCompilation compilation2) {
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = this.getResolver().alreadyResolvedMessage(Intrinsics.stringPlus((String)"add compilation ", (Object)compilation2));
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<KotlinJsCompilation, KotlinCompilationNpmResolver> map = this.byCompilation;
        KotlinCompilationNpmResolver kotlinCompilationNpmResolver = new KotlinCompilationNpmResolver(this, compilation2);
        bl3 = false;
        map.put(compilation2, kotlinCompilationNpmResolver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinProjectNpmResolution close() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.closed = true;
        Iterable iterable = this.byCompilation.values();
        Project project = this.project;
        boolean $i$f$mapNotNull = false;
        void var3_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KotlinCompilationNpmResolution kotlinCompilationNpmResolution;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl6 = false;
            KotlinCompilationNpmResolver it = (KotlinCompilationNpmResolver)element$iv$iv;
            boolean bl7 = false;
            if (it.close() == null) continue;
            boolean bl8 = false;
            boolean bl9 = false;
            KotlinCompilationNpmResolution it$iv$iv = kotlinCompilationNpmResolution;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Map<RequiresNpmDependencies, Set<RequiredKotlinJsDependency>> map = this.resolver.getNodeJs().getTaskRequirements().getByTask();
        List list3 = list2;
        Project project2 = project;
        return new KotlinProjectNpmResolution(project2, list3, map);
    }

    public static final /* synthetic */ void access$addTargetListeners(KotlinProjectNpmResolver $this, KotlinTarget target2) {
        $this.addTargetListeners(target2);
    }

    public static final /* synthetic */ void access$addCompilation(KotlinProjectNpmResolver $this, KotlinJsCompilation compilation2) {
        $this.addCompilation(compilation2);
    }
}

