/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a.\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0080\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"formatContentLength", "", "bytes", "", "formatDuration", "milliseconds", "lifecycleWithDuration", "T", "Lorg/gradle/api/logging/Logger;", "messagePrefix", "action", "Lkotlin/Function0;", "(Lorg/gradle/api/logging/Logger;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-gradle-plugin"})
public final class FormattingUtilsKt {
    @NotNull
    public static final String formatDuration(long milliseconds) {
        StringBuilder stringBuilder;
        block18: {
            StringBuilder $this$formatDuration_u24lambda_u2d0;
            long ms;
            block17: {
                boolean bl;
                CharSequence charSequence;
                block16: {
                    long s;
                    block15: {
                        block14: {
                            long m;
                            block13: {
                                ms = 0L;
                                ms = milliseconds;
                                s = 0L;
                                m = 0L;
                                long h = 0L;
                                if (ms >= 1000L) {
                                    s = ms / (long)1000;
                                    ms %= (long)1000;
                                    if (s >= 60L) {
                                        m = s / (long)60;
                                        s %= (long)60;
                                        if (m >= 60L) {
                                            h = m / (long)60;
                                            m %= (long)60;
                                        }
                                    }
                                }
                                boolean bl2 = false;
                                stringBuilder = new StringBuilder();
                                boolean bl3 = false;
                                boolean bl4 = false;
                                $this$formatDuration_u24lambda_u2d0 = stringBuilder;
                                boolean bl5 = false;
                                if (h > 0L) {
                                    $this$formatDuration_u24lambda_u2d0.append(h).append(" h ");
                                }
                                if (m > 0L) break block13;
                                charSequence = $this$formatDuration_u24lambda_u2d0;
                                bl = false;
                                if (!(charSequence.length() > 0)) break block14;
                            }
                            $this$formatDuration_u24lambda_u2d0.append(m).append(" m ");
                        }
                        if (s > 0L) break block15;
                        charSequence = $this$formatDuration_u24lambda_u2d0;
                        bl = false;
                        if (!(charSequence.length() > 0)) break block16;
                    }
                    $this$formatDuration_u24lambda_u2d0.append(s).append(" s ");
                }
                if (ms > 0L) break block17;
                charSequence = $this$formatDuration_u24lambda_u2d0;
                bl = false;
                if (!(charSequence.length() > 0)) break block18;
            }
            $this$formatDuration_u24lambda_u2d0.append(ms).append(" ms");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final <T> T lifecycleWithDuration(@NotNull Logger $this$lifecycleWithDuration, @NotNull String messagePrefix, @NotNull Function0<? extends T> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$lifecycleWithDuration, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)messagePrefix, (String)"messagePrefix");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        boolean $i$f$lifecycleWithDuration = false;
        long startTime = System.currentTimeMillis();
        Object result2 = action.invoke();
        long finishTime = System.currentTimeMillis();
        $this$lifecycleWithDuration.lifecycle(messagePrefix + " took " + FormattingUtilsKt.formatDuration(finishTime - startTime));
        return (T)result2;
    }

    @NotNull
    public static final String formatContentLength(long bytes) {
        String string;
        if (bytes < 0L) {
            string = "N/A";
        } else if (bytes < 1024L) {
            string = bytes + " bytes";
        } else {
            double kilobytes = (double)bytes / (double)1024;
            if (kilobytes < 1024.0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%.2f KB";
                Object[] objectArray = new Object[]{kilobytes};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            } else {
                double megabytes = kilobytes / (double)1024;
                if (megabytes < 1024.0) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string4 = "%.2f MB";
                    Object[] objectArray = new Object[]{megabytes};
                    boolean bl = false;
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    string = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                } else {
                    double gigabytes = megabytes / (double)1024;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string6 = "%.2f GB";
                    Object[] objectArray = new Object[]{gigabytes};
                    boolean bl = false;
                    String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                    string = string7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
                }
            }
        }
        return string;
    }
}

