/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.compilerRunner.KotlinToolRunner;
import org.jetbrains.kotlin.konan.target.HostManager;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 ;2\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0016J\b\u00104\u001a\u000205H\u0002J\u0014\u00106\u001a\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&J\u0016\u00108\u001a\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0002J\u0016\u00109\u001a\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0002J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\tR\u0012\u0010\"\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u0012\u0010+\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0012\u0010-\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "classpath", "", "Ljava/io/File;", "getClasspath", "()Ljava/util/Set;", "daemonEntryPoint", "", "getDaemonEntryPoint", "()Ljava/lang/String;", "defaultMaxHeapSize", "getDefaultMaxHeapSize", "disableC2", "", "getDisableC2", "()Z", "displayName", "getDisplayName", "enableAssertions", "getEnableAssertions", "execEnvironment", "", "getExecEnvironment", "()Ljava/util/Map;", "execEnvironmentBlacklist", "getExecEnvironmentBlacklist", "execSystemProperties", "getExecSystemProperties", "execSystemPropertiesBlacklist", "getExecSystemPropertiesBlacklist", "isolatedClassLoaderCacheKey", "getIsolatedClassLoaderCacheKey", "()Ljava/lang/Object;", "jvmArgs", "", "getJvmArgs", "()Ljava/util/List;", "jvmArgs$delegate", "Lkotlin/Lazy;", "mainClass", "getMainClass", "mustRunViaExec", "getMustRunViaExec", "getProject", "()Lorg/gradle/api/Project;", "checkClasspath", "", "getCustomJvmArgs", "getIsolatedClassLoader", "Ljava/lang/ClassLoader;", "run", "args", "runInProcess", "runViaExec", "transformArgs", "Companion", "kotlin-gradle-plugin"})
public abstract class KotlinToolRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, String> execEnvironment;
    @NotNull
    private final Set<String> execEnvironmentBlacklist;
    @NotNull
    private final Map<String, String> execSystemProperties;
    @NotNull
    private final Set<String> execSystemPropertiesBlacklist;
    @NotNull
    private final Lazy jvmArgs$delegate;
    @NotNull
    private static final ConcurrentHashMap<Object, ClassLoader> isolatedClassLoadersMap = new ConcurrentHashMap();

    public KotlinToolRunner(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.execEnvironment = MapsKt.emptyMap();
        this.execEnvironmentBlacklist = SetsKt.emptySet();
        this.execSystemProperties = MapsKt.emptyMap();
        this.execSystemPropertiesBlacklist = SetsKt.setOf((Object)"java.endorsed.dirs");
        this.jvmArgs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<String>>(this){
            final /* synthetic */ KotlinToolRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                String string;
                boolean bl;
                List<String> customJvmArgs;
                List $this$invoke_u24lambda_u2d2;
                KotlinToolRunner kotlinToolRunner;
                List list2;
                block7: {
                    boolean bl2 = false;
                    list2 = new ArrayList<E>();
                    kotlinToolRunner = this.this$0;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    $this$invoke_u24lambda_u2d2 = list2;
                    boolean bl5 = false;
                    if (kotlinToolRunner.getEnableAssertions()) {
                        $this$invoke_u24lambda_u2d2.add("-ea");
                    }
                    customJvmArgs = kotlinToolRunner.getCustomJvmArgs();
                    Iterable $this$none$iv = customJvmArgs;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl6 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)"-Xmx", (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    $this$invoke_u24lambda_u2d2.add(Intrinsics.stringPlus((String)"-Xmx", (Object)kotlinToolRunner.getDefaultMaxHeapSize()));
                }
                if (kotlinToolRunner.getDisableC2() && (string = System.getProperty("java.vm.name")) != null) {
                    String string2 = string;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    String vmName = string2;
                    boolean bl9 = false;
                    if (StringsKt.contains((CharSequence)vmName, (CharSequence)"HotSpot", (boolean)true)) {
                        $this$invoke_u24lambda_u2d2.add("-XX:TieredStopAtLevel=1");
                    }
                }
                $this$invoke_u24lambda_u2d2.addAll((Collection)customJvmArgs);
                return list2;
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract String getMainClass();

    @NotNull
    public String getDaemonEntryPoint() {
        return "main";
    }

    @NotNull
    public Map<String, String> getExecEnvironment() {
        return this.execEnvironment;
    }

    @NotNull
    public Set<String> getExecEnvironmentBlacklist() {
        return this.execEnvironmentBlacklist;
    }

    @NotNull
    public Map<String, String> getExecSystemProperties() {
        return this.execSystemProperties;
    }

    @NotNull
    public Set<String> getExecSystemPropertiesBlacklist() {
        return this.execSystemPropertiesBlacklist;
    }

    @NotNull
    public abstract Set<File> getClasspath();

    public void checkClasspath() {
        Collection collection = this.getClasspath();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Classpath of the tool is empty: ", (Object)this.getDisplayName());
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public abstract Object getIsolatedClassLoaderCacheKey();

    private final ClassLoader getIsolatedClassLoader() {
        ClassLoader classLoader = isolatedClassLoadersMap.computeIfAbsent(this.getIsolatedClassLoaderCacheKey(), new Function<Object, ClassLoader>(this){
            final /* synthetic */ KotlinToolRunner this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final URLClassLoader apply(@NotNull Object it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable $this$map$iv = this.this$0.getClasspath();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    URL uRL = new File(it2.getAbsolutePath()).toURI().toURL();
                    collection.add(uRL);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                URL[] arrayOfURLs = uRLArray;
                URLClassLoader uRLClassLoader = new URLClassLoader(arrayOfURLs, null);
                KotlinToolRunner kotlinToolRunner = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                URLClassLoader $this$apply_u24lambda_u2d1 = uRLClassLoader;
                boolean bl3 = false;
                $this$apply_u24lambda_u2d1.setDefaultAssertionStatus(kotlinToolRunner.getEnableAssertions());
                return uRLClassLoader;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"private fun getIsolatedClassLoader(): ClassLoader = isolatedClassLoadersMap.computeIfAbsent(isolatedClassLoaderCacheKey) {\n        val arrayOfURLs = classpath.map { File(it.absolutePath).toURI().toURL() }.toTypedArray()\n        URLClassLoader(arrayOfURLs, null).apply {\n            setDefaultAssertionStatus(enableAssertions)\n        }\n    }");
        return classLoader;
    }

    @NotNull
    public String getDefaultMaxHeapSize() {
        return "3G";
    }

    public boolean getEnableAssertions() {
        return true;
    }

    public boolean getDisableC2() {
        return true;
    }

    public abstract boolean getMustRunViaExec();

    @NotNull
    public List<String> transformArgs(@NotNull List<String> args) {
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        return args;
    }

    @NotNull
    public List<String> getCustomJvmArgs() {
        return CollectionsKt.emptyList();
    }

    private final List<String> getJvmArgs() {
        Lazy lazy = this.jvmArgs$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final void run(@NotNull List<String> args) {
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        this.checkClasspath();
        if (this.getMustRunViaExec()) {
            this.runViaExec(args);
        } else {
            this.runInProcess(args);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runViaExec(List<String> args) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<String> transformedArgs = this.transformArgs(args);
        Object[] objectArray = new Object[]{this.getClasspath()};
        ConfigurableFileCollection classpath2 = this.project.files(objectArray);
        Object object = System.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProperties()");
        Map systemProperties2 = MapsKt.plus((Map)MapsKt.toMap((Sequence)KotlinToolRunner.Companion.escapeQuotesForWindows((Sequence<Pair<String, String>>)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence((Map)((Map)object)), (Function1)runViaExec.systemProperties.1.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(this){
            final /* synthetic */ KotlinToolRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull Pair<String, String> $dstr$k$_u24__u24) {
                Intrinsics.checkParameterIsNotNull($dstr$k$_u24__u24, (String)"$dstr$k$_u24__u24");
                String k = (String)$dstr$k$_u24__u24.component1();
                return !this.this$0.getExecSystemPropertiesBlacklist().contains(k);
            }
        })))), this.getExecSystemProperties());
        Logger logger = this.project.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("|Run \"").append(this.getDisplayName()).append("\" tool in a separate JVM process\n               |Main class = ").append(this.getMainClass()).append("\n               |Arguments = ").append(KotlinToolRunner.Companion.toPrettyString(args)).append("\n               |Transformed arguments = ").append(Intrinsics.areEqual(transformedArgs, args) ? "same as arguments" : KotlinToolRunner.Companion.toPrettyString(transformedArgs)).append("\n               |Classpath = ");
        object = classpath2.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"classpath.files");
        object = (Iterable)object;
        Companion companion = Companion;
        StringBuilder stringBuilder2 = stringBuilder;
        Logger logger2 = logger;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        logger2.info(StringsKt.trimMargin$default((String)stringBuilder2.append(companion.toPrettyString(collection)).append("\n               |JVM options = ").append(KotlinToolRunner.Companion.toPrettyString(this.getJvmArgs())).append("\n               |Java system properties = ").append(KotlinToolRunner.Companion.toPrettyString(systemProperties2)).append("\n               |Suppressed ENV variables = ").append(KotlinToolRunner.Companion.toPrettyString(this.getExecEnvironmentBlacklist())).append("\n               |Custom ENV variables = ").append(KotlinToolRunner.Companion.toPrettyString(this.getExecEnvironment())).append("\n            ").toString(), null, (int)1, null));
        this.project.javaexec((Action)new Action<JavaExecSpec>(this, classpath2, systemProperties2, transformedArgs){
            final /* synthetic */ KotlinToolRunner this$0;
            final /* synthetic */ ConfigurableFileCollection $classpath;
            final /* synthetic */ Map<String, String> $systemProperties;
            final /* synthetic */ List<String> $transformedArgs;
            {
                this.this$0 = $receiver;
                this.$classpath = $classpath;
                this.$systemProperties = $systemProperties;
                this.$transformedArgs = $transformedArgs;
            }

            public final void execute(JavaExecSpec spec) {
                spec.setMain(this.this$0.getMainClass());
                spec.setClasspath((FileCollection)this.$classpath);
                spec.jvmArgs((Iterable)KotlinToolRunner.access$getJvmArgs(this.this$0));
                spec.systemProperties(this.$systemProperties);
                Iterable $this$forEach$iv = this.this$0.getExecEnvironmentBlacklist();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    spec.getEnvironment().remove(it);
                }
                spec.environment(this.this$0.getExecEnvironment());
                spec.args((Iterable)this.$transformedArgs);
            }
        });
    }

    private final void runInProcess(List<String> args) {
        List<String> transformedArgs = this.transformArgs(args);
        this.project.getLogger().info(StringsKt.trimMargin$default((String)("|Run in-process tool \"" + this.getDisplayName() + "\"\n               |Entry point method = " + this.getMainClass() + '.' + this.getDaemonEntryPoint() + "\n               |Arguments = " + KotlinToolRunner.Companion.toPrettyString(args) + "\n               |Transformed arguments = " + (Intrinsics.areEqual(transformedArgs, args) ? "same as arguments" : KotlinToolRunner.Companion.toPrettyString(transformedArgs)) + "\n            "), null, (int)1, null));
        try {
            Class<?> mainClass = this.getIsolatedClassLoader().loadClass(this.getMainClass());
            Object[] objectArray = mainClass.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"mainClass.methods");
            Object[] $this$single$iv = objectArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.getDaemonEntryPoint())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Method entryPoint = (Method)single$iv;
            objectArray = new Object[1];
            Collection $this$toTypedArray$iv = transformedArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            entryPoint.invoke(null, objectArray);
        }
        catch (InvocationTargetException t) {
            Throwable throwable = t.getTargetException();
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"t.targetException");
            throw throwable;
        }
    }

    public static final /* synthetic */ List access$getJvmArgs(KotlinToolRunner $this) {
        return $this.getJvmArgs();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002J0\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\t*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\tH\u0002J\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0018\u0010\u000b\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\rH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner$Companion;", "", "()V", "isolatedClassLoadersMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/ClassLoader;", "escapeQuotes", "", "escapeQuotesForWindows", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "toPrettyString", "", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final String escapeQuotes(String $this$escapeQuotes) {
            return StringsKt.replace$default((String)$this$escapeQuotes, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        }

        private final Sequence<Pair<String, String>> escapeQuotesForWindows(Sequence<Pair<String, String>> $this$escapeQuotesForWindows) {
            return HostManager.Companion.getHostIsMingw() ? SequencesKt.map($this$escapeQuotesForWindows, (Function1)escapeQuotesForWindows.1.INSTANCE) : $this$escapeQuotesForWindows;
        }

        private final String toPrettyString(Map<String, String> $this$toPrettyString) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$toPrettyString_u24lambda_u2d1 = stringBuilder;
            boolean bl4 = false;
            $this$toPrettyString_u24lambda_u2d1.append('[');
            Map<String, String> map = $this$toPrettyString;
            boolean bl5 = false;
            if (!map.isEmpty()) {
                $this$toPrettyString_u24lambda_u2d1.append('\n');
            }
            Iterable $this$forEach$iv = $this$toPrettyString.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry $dstr$key$value = (Map.Entry)element$iv;
                boolean bl6 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl7 = false;
                String key = (String)entry.getKey();
                Map.Entry entry2 = $dstr$key$value;
                boolean bl8 = false;
                String value = (String)entry2.getValue();
                $this$toPrettyString_u24lambda_u2d1.append('\t').append(key).append(" = ").append(Companion.toPrettyString(value)).append('\n');
            }
            $this$toPrettyString_u24lambda_u2d1.append(']');
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final String toPrettyString(Collection<String> $this$toPrettyString) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$toPrettyString_u24lambda_u2d3 = stringBuilder;
            boolean bl4 = false;
            $this$toPrettyString_u24lambda_u2d3.append('[');
            Collection<String> collection = $this$toPrettyString;
            boolean bl5 = false;
            if (!collection.isEmpty()) {
                $this$toPrettyString_u24lambda_u2d3.append('\n');
            }
            Iterable $this$forEach$iv = $this$toPrettyString;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl6 = false;
                $this$toPrettyString_u24lambda_u2d3.append('\t').append(Companion.toPrettyString(it)).append('\n');
            }
            $this$toPrettyString_u24lambda_u2d3.append(']');
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final String toPrettyString(String $this$toPrettyString) {
            String string;
            CharSequence charSequence = $this$toPrettyString;
            boolean bl = false;
            if (charSequence.length() == 0) {
                string = "\"\"";
            } else {
                boolean bl2;
                block5: {
                    CharSequence $this$any$iv = $this$toPrettyString;
                    boolean $i$f$any = false;
                    CharSequence charSequence2 = $this$any$iv;
                    for (int j = 0; j < charSequence2.length(); ++j) {
                        char element$iv;
                        char it = element$iv = charSequence2.charAt(j);
                        boolean bl3 = false;
                        if (!(it == '\"' || CharsKt.isWhitespace((char)it))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    char c = '\"';
                    String string2 = StringUtil.escapeStringCharacters((String)$this$toPrettyString);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"escapeStringCharacters(this)");
                    boolean bl4 = false;
                    string = Intrinsics.stringPlus((String)(String.valueOf(c) + string2), (Object)"\"");
                } else {
                    string = $this$toPrettyString;
                }
            }
            return string;
        }

        public static final /* synthetic */ String access$escapeQuotes(Companion $this, String $receiver) {
            return $this.escapeQuotes($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

