/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.CocoapodsExtension;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.targets.native.tasks.DownloadCocoapodsTask;
import org.jetbrains.kotlin.gradle.targets.native.tasks.PodDownloadUrlTask;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\n \u0011*\u0004\u0018\u00010 0 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR:\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\t0\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0016\u0010\u0013\u001a\u00020\u00108AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/PodDownloadUrlTask;", "Lorg/jetbrains/kotlin/gradle/targets/native/tasks/DownloadCocoapodsTask;", "()V", "permittedFileExtensions", "", "", "getPermittedFileExtensions$kotlin_gradle_plugin", "()Ljava/util/List;", "podSource", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/cocoapods/CocoapodsExtension$CocoapodsDependency$PodLocation$Url;", "getPodSource$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "setPodSource$kotlin_gradle_plugin", "(Lorg/gradle/api/provider/Provider;)V", "podSourceDir", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getPodSourceDir$kotlin_gradle_plugin", "urlDir", "getUrlDir$kotlin_gradle_plugin", "()Ljava/io/File;", "archiveTree", "Lorg/gradle/api/file/FileTree;", "path", "extension", "copyArtifactToUrlDir", "", "artifact", "flatten", "", "createDependency", "Lorg/gradle/api/artifacts/Dependency;", "fileNameWithoutExtension", "download", "setupRepo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "repoUrl", "kotlin-gradle-plugin"})
public class PodDownloadUrlTask
extends DownloadCocoapodsTask {
    public Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> podSource;
    @NotNull
    private final File urlDir;
    private final Provider<File> podSourceDir;
    @NotNull
    private final List<String> permittedFileExtensions;

    public PodDownloadUrlTask() {
        Object[] objectArray = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"project");
        this.urlDir = KotlinCocoapodsPluginKt.getCocoapodsBuildDirs((Project)objectArray).externalSources("url");
        this.podSourceDir = this.getProject().provider((Callable)new Callable<File>(this){
            final /* synthetic */ PodDownloadUrlTask this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final File call() {
                File file = this.this$0.getUrlDir$kotlin_gradle_plugin();
                Object object = this.this$0.getPodName$kotlin_gradle_plugin().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"podName.get()");
                return FilesKt.resolve((File)file, (String)((String)object));
            }
        });
        objectArray = new String[]{"zip", "tar", "tgz", "tbz", "txz", "gzip", "tar.gz", "tar.bz2", "tar.xz", "jar"};
        this.permittedFileExtensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nested
    @NotNull
    public final Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> getPodSource$kotlin_gradle_plugin() {
        Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> provider = this.podSource;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"podSource");
        throw null;
    }

    public final void setPodSource$kotlin_gradle_plugin(@NotNull Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.podSource = provider;
    }

    @Internal
    @NotNull
    public final File getUrlDir$kotlin_gradle_plugin() {
        return this.urlDir;
    }

    @OutputDirectory
    public final Provider<File> getPodSourceDir$kotlin_gradle_plugin() {
        return this.podSourceDir;
    }

    @Internal
    @NotNull
    public final List<String> getPermittedFileExtensions$kotlin_gradle_plugin() {
        return this.permittedFileExtensions;
    }

    @TaskAction
    public final void download() {
        CocoapodsExtension.CocoapodsDependency.PodLocation.Url podLocation = (CocoapodsExtension.CocoapodsDependency.PodLocation.Url)this.getPodSource$kotlin_gradle_plugin().get();
        String string = podLocation.getUrl().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"podLocation.url.toString()");
        String url = string;
        String repoUrl = StringsKt.substringBeforeLast$default((String)url, (String)"/", null, (int)2, null);
        String fileName = StringsKt.substringAfterLast$default((String)url, (String)"/", null, (int)2, null);
        String fileNameWithoutExtension = StringsKt.substringBefore$default((String)fileName, (String)".", null, (int)2, null);
        String extension = StringsKt.substringAfter$default((String)fileName, (String)".", null, (int)2, null);
        boolean bl = this.permittedFileExtensions.contains(extension);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unknown file extension";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ArtifactRepository repo2 = this.setupRepo(repoUrl);
        Dependency dependency2 = this.createDependency(fileNameWithoutExtension, extension);
        Dependency[] bl4 = new Dependency[]{dependency2};
        Configuration configuration2 = this.getProject().getConfigurations().detachedConfiguration(bl4);
        File artifact2 = configuration2.getSingleFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifact2, (String)"artifact");
        this.copyArtifactToUrlDir(artifact2, extension, podLocation.getFlatten());
        this.getProject().getRepositories().remove((Object)repo2);
    }

    private final ArtifactRepository setupRepo(String repoUrl) {
        IvyArtifactRepository ivyArtifactRepository = this.getProject().getRepositories().ivy((Action)new Action<IvyArtifactRepository>(repoUrl){
            final /* synthetic */ String $repoUrl;
            {
                this.$repoUrl = $repoUrl;
            }

            public final void execute(IvyArtifactRepository repo2) {
                repo2.setUrl((Object)this.$repoUrl);
                repo2.patternLayout((Action)setupRepo.1.INSTANCE);
                repo2.metadataSources((Action)setupRepo.2.INSTANCE);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository, (String)"repoUrl: String): ArtifactRepository {\n        return project.repositories.ivy { repo ->\n            repo.setUrl(repoUrl)\n            repo.patternLayout {\n                it.artifact(\"[artifact].[ext]\")\n            }\n            repo.metadataSources {\n                it.artifact()\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final Dependency createDependency(String fileNameWithoutExtension, String extension) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)fileNameWithoutExtension), TuplesKt.to((Object)"version", (Object)"1.0"), TuplesKt.to((Object)"ext", (Object)extension)};
        return this.getProject().getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
    }

    private final void copyArtifactToUrlDir(File artifact2, String extension, boolean flatten) {
        String string = artifact2.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"artifact.absolutePath");
        FileTree archiveTree = this.archiveTree(string, extension);
        this.getProject().copy((Action)new Action<CopySpec>(this, archiveTree, extension, flatten){
            final /* synthetic */ PodDownloadUrlTask this$0;
            final /* synthetic */ FileTree $archiveTree;
            final /* synthetic */ String $extension;
            final /* synthetic */ boolean $flatten;
            {
                this.this$0 = $receiver;
                this.$archiveTree = $archiveTree;
                this.$extension = $extension;
                this.$flatten = $flatten;
            }

            public final void execute(CopySpec it) {
                File destinationDir2 = (File)this.this$0.getPodSourceDir$kotlin_gradle_plugin().get();
                it.into((Object)destinationDir2);
                Object[] objectArray = new Object[]{this.$archiveTree};
                it.from(objectArray);
                if (Intrinsics.areEqual((Object)this.$extension, (Object)"jar")) {
                    objectArray = new String[]{"META-INF/"};
                    it.exclude((String[])objectArray);
                }
                if (!this.$flatten) {
                    it.eachFile((Action)copyArtifactToUrlDir.1.INSTANCE);
                    it.setIncludeEmptyDirs(false);
                }
            }
        });
    }

    private final FileTree archiveTree(String path, String extension) {
        FileTree fileTree;
        if (Intrinsics.areEqual((Object)extension, (Object)"zip") || Intrinsics.areEqual((Object)extension, (Object)"jar")) {
            FileTree fileTree2 = this.getProject().zipTree((Object)path);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree2, (String)"{\n            project.zipTree(path)\n        }");
            fileTree = fileTree2;
        } else {
            FileTree fileTree3 = this.getProject().tarTree((Object)path);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree3, (String)"{\n            project.tarTree(path)\n        }");
            fileTree = fileTree3;
        }
        return fileTree;
    }
}

