/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.incremental;

import java.io.File;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.gradle.incremental.ChangesCollectorResult;
import org.jetbrains.kotlin.gradle.incremental.ClassSnapshot;
import org.jetbrains.kotlin.gradle.incremental.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.gradle.incremental.ClasspathSnapshot;
import org.jetbrains.kotlin.gradle.incremental.KotlinClassSnapshot;
import org.jetbrains.kotlin.gradle.incremental.NoOpBuildReporter;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.storage.FileToCanonicalPathConverter;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/incremental/ClasspathChangesComputer;", "", "()V", "collectClasspathChanges", "Lorg/jetbrains/kotlin/gradle/incremental/ChangesCollectorResult;", "current", "Lorg/jetbrains/kotlin/gradle/incremental/ClasspathSnapshot;", "previous", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "collectClasspathEntryChanges", "Lorg/jetbrains/kotlin/gradle/incremental/ClasspathEntrySnapshot;", "collectKotlinClassChanges", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "Lorg/jetbrains/kotlin/gradle/incremental/KotlinClassSnapshot;", "collectKotlinClassChanges$kotlin_gradle_plugin", "getChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges;", "kotlin-gradle-plugin"})
public final class ClasspathChangesComputer {
    @NotNull
    public static final ClasspathChangesComputer INSTANCE = new ClasspathChangesComputer();

    private ClasspathChangesComputer() {
    }

    @NotNull
    public final ClasspathChanges getChanges(@NotNull ClasspathSnapshot current, @NotNull ClasspathSnapshot previous) {
        ClasspathChanges classpathChanges;
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        ChangesCollector changesCollector = new ChangesCollector();
        ChangesCollectorResult changesCollectorResult = this.collectClasspathChanges(current, previous, changesCollector);
        if (Intrinsics.areEqual((Object)changesCollectorResult, (Object)ChangesCollectorResult.Success.INSTANCE)) {
            DirtyData dirtyData = BuildUtilKt.getDirtyData((ChangesCollector)changesCollector, (Iterable)CollectionsKt.emptyList(), (ICReporter)((ICReporter)NoOpBuildReporter.INSTANCE));
            Collection lookupSymbols = dirtyData.component1();
            Collection fqNames = dirtyData.component2();
            classpathChanges = (ClasspathChanges)new ClasspathChanges.Available(CollectionsKt.toList((Iterable)lookupSymbols), CollectionsKt.toList((Iterable)fqNames));
        } else if (changesCollectorResult instanceof ChangesCollectorResult.Failure) {
            classpathChanges = (ClasspathChanges)ClasspathChanges.NotAvailable.UnableToCompute.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return classpathChanges;
    }

    private final ChangesCollectorResult collectClasspathChanges(ClasspathSnapshot current, ClasspathSnapshot previous, ChangesCollector changesCollector) {
        if (current.getClasspathEntrySnapshots().size() != previous.getClasspathEntrySnapshots().size()) {
            return ChangesCollectorResult.Failure.AddedRemovedClasspathEntries.INSTANCE;
        }
        int n = 0;
        int n2 = current.getClasspathEntrySnapshots().size();
        while (n < n2) {
            int index = n++;
            ChangesCollectorResult result2 = this.collectClasspathEntryChanges(current.getClasspathEntrySnapshots().get(index), previous.getClasspathEntrySnapshots().get(index), changesCollector);
            if (!(result2 instanceof ChangesCollectorResult.Failure)) continue;
            return result2;
        }
        return ChangesCollectorResult.Success.INSTANCE;
    }

    private final ChangesCollectorResult collectClasspathEntryChanges(ClasspathEntrySnapshot current, ClasspathEntrySnapshot previous, ChangesCollector changesCollector) {
        if (current.getClassSnapshots().size() != previous.getClassSnapshots().size()) {
            return ChangesCollectorResult.Failure.AddedRemovedClasses.INSTANCE;
        }
        for (String key : current.getClassSnapshots().keySet()) {
            ClassSnapshot classSnapshot;
            ClassSnapshot classSnapshot2;
            Intrinsics.checkNotNull((Object)current.getClassSnapshots().get(key));
            Intrinsics.checkNotNullExpressionValue((Object)classSnapshot2, (String)"current.classSnapshots[key]!!");
            ClassSnapshot currentSnapshot = classSnapshot2;
            ClassSnapshot classSnapshot3 = previous.getClassSnapshots().get(key);
            if (classSnapshot3 == null) {
                return ChangesCollectorResult.Failure.AddedRemovedClasses.INSTANCE;
            }
            ClassSnapshot previousSnapshot = classSnapshot = classSnapshot3;
            if (!(currentSnapshot instanceof KotlinClassSnapshot) || !(previousSnapshot instanceof KotlinClassSnapshot)) {
                return ChangesCollectorResult.Failure.NotYetImplemented.INSTANCE;
            }
            this.collectKotlinClassChanges$kotlin_gradle_plugin((KotlinClassSnapshot)currentSnapshot, (KotlinClassSnapshot)previousSnapshot);
        }
        return ChangesCollectorResult.Success.INSTANCE;
    }

    @NotNull
    public final DirtyData collectKotlinClassChanges$kotlin_gradle_plugin(@NotNull KotlinClassSnapshot current, @NotNull KotlinClassSnapshot previous) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        File file = FileUtil.createTempDirectory((String)this.getClass().getSimpleName(), (String)Intrinsics.stringPlus((String)"_WorkingDir_", (Object)UUID.randomUUID()), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(this\u2026 /* deleteOnExit */ true)");
        File workingDir = file;
        IncrementalJvmCache incrementalJvmCache = new IncrementalJvmCache(workingDir, null, (FileToPathConverter)FileToCanonicalPathConverter.INSTANCE);
        incrementalJvmCache.saveClassToCache(previous.getClassInfo(), null, new ChangesCollector());
        ChangesCollector changesCollector = new ChangesCollector();
        incrementalJvmCache.saveClassToCache(current.getClassInfo(), null, changesCollector);
        FilesKt.deleteRecursively((File)workingDir);
        return BuildUtilKt.getDirtyData((ChangesCollector)changesCollector, (Iterable)CollectionsKt.listOf((Object)incrementalJvmCache), (ICReporter)NoOpBuildReporter.NoOpICReporter.INSTANCE);
    }
}

