/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.pm20;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.build.BuildState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinSingleTargetExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.project.model.KotlinModule;
import org.jetbrains.kotlin.project.model.KotlinModuleIdentifier;
import org.jetbrains.kotlin.project.model.LocalModuleIdentifier;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\b\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"targets", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinProjectExtension;", "getTargets", "(Lorg/jetbrains/kotlin/gradle/dsl/KotlinProjectExtension;)Ljava/lang/Iterable;", "currentBuildId", "Lorg/gradle/api/artifacts/component/BuildIdentifier;", "Lorg/gradle/api/Project;", "representsProject", "", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "project", "kotlin-gradle-plugin"})
public final class UtilsKt {
    @NotNull
    public static final Iterable<KotlinTarget> getTargets(@NotNull KotlinProjectExtension $this$targets) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)$this$targets, (String)"<this>");
        KotlinProjectExtension kotlinProjectExtension = $this$targets;
        if (kotlinProjectExtension instanceof KotlinSingleTargetExtension) {
            iterable = CollectionsKt.listOf((Object)((KotlinSingleTargetExtension)$this$targets).getTarget());
        } else if (kotlinProjectExtension instanceof KotlinMultiplatformExtension) {
            iterable = (Iterable)((KotlinMultiplatformExtension)$this$targets).getTargets();
        } else {
            throw (Throwable)new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected 'kotlin' extension ", (Object)$this$targets).toString());
        }
        return iterable;
    }

    public static final boolean representsProject(@NotNull KotlinModule $this$representsProject, @NotNull Project project) {
        KotlinModuleIdentifier kotlinModuleIdentifier;
        Intrinsics.checkNotNullParameter((Object)$this$representsProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinModuleIdentifier it = kotlinModuleIdentifier = $this$representsProject.getModuleIdentifier();
        boolean bl = false;
        return it instanceof LocalModuleIdentifier && Intrinsics.areEqual((Object)((LocalModuleIdentifier)it).getBuildId(), (Object)UtilsKt.currentBuildId(project).getName()) && Intrinsics.areEqual((Object)((LocalModuleIdentifier)it).getProjectId(), (Object)project.getPath());
    }

    @NotNull
    public static final BuildIdentifier currentBuildId(@NotNull Project $this$currentBuildId) {
        Intrinsics.checkNotNullParameter((Object)$this$currentBuildId, (String)"<this>");
        Project project = $this$currentBuildId.getProject();
        if (project == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
        }
        BuildIdentifier buildIdentifier = ((BuildState)((ProjectInternal)project).getServices().get(BuildState.class)).getBuildIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)buildIdentifier, (String)"currentBuildId");
        return buildIdentifier;
    }
}

