/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatData;
import org.jetbrains.kotlin.gradle.plugin.stat.ReportStatistics;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildEsStatListener;
import org.jetbrains.kotlin.gradle.plugin.statistics.TaskExecutionState;
import org.jetbrains.kotlin.gradle.report.TaskExecutionInfo;
import org.jetbrains.kotlin.gradle.report.TaskExecutionProperties;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.incremental.ChangedFiles;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\u0012\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J \u0010'\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00050\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\fR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildEsStatListener;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/api/execution/TaskExecutionListener;", "projectName", "", "reportStatistics", "", "Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "buildUuid", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getBuildUuid", "()Ljava/lang/String;", "hostName", "kotlin.jvm.PlatformType", "getHostName", "hostName$delegate", "Lkotlin/Lazy;", "label", "getLabel", "label$delegate", "getProjectName", "getReportStatistics", "()Ljava/util/List;", "afterExecute", "", "task", "Lorg/gradle/api/Task;", "taskState", "Lorg/gradle/api/tasks/TaskState;", "availableForStat", "", "taskPath", "beforeExecute", "p0", "close", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "reportData", "duration", "", "taskResult", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/TaskExecutionState;", "kotlin-gradle-plugin"})
public final class KotlinBuildEsStatListener
implements OperationCompletionListener,
AutoCloseable,
TaskExecutionListener {
    @NotNull
    private final String projectName;
    @NotNull
    private final List<ReportStatistics> reportStatistics;
    @NotNull
    private final String buildUuid;
    @NotNull
    private final Lazy label$delegate;
    @NotNull
    private final Lazy hostName$delegate;

    public KotlinBuildEsStatListener(@NotNull String projectName, @NotNull List<? extends ReportStatistics> reportStatistics, @NotNull String buildUuid) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(reportStatistics, (String)"reportStatistics");
        Intrinsics.checkNotNullParameter((Object)buildUuid, (String)"buildUuid");
        this.projectName = projectName;
        this.reportStatistics = reportStatistics;
        this.buildUuid = buildUuid;
        this.label$delegate = LazyKt.lazy((Function0)label.2.INSTANCE);
        this.hostName$delegate = LazyKt.lazy((Function0)hostName.2.INSTANCE);
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final List<ReportStatistics> getReportStatistics() {
        return this.reportStatistics;
    }

    @NotNull
    public final String getBuildUuid() {
        return this.buildUuid;
    }

    @Nullable
    public final String getLabel() {
        Lazy lazy = this.label$delegate;
        Object var2_2 = null;
        return (String)lazy.getValue();
    }

    public final String getHostName() {
        Lazy lazy = this.hostName$delegate;
        Object var2_2 = null;
        return (String)lazy.getValue();
    }

    public void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            TaskOperationResult result2 = ((TaskFinishEvent)event).getResult();
            String taskPath = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            long duration = ((TaskFinishEvent)event).getResult().getEndTime() - ((TaskFinishEvent)event).getResult().getStartTime();
            TaskOperationResult taskOperationResult = result2;
            TaskExecutionState taskResult = taskOperationResult instanceof TaskSuccessResult ? (((TaskSuccessResult)result2).isFromCache() ? TaskExecutionState.FROM_CACHE : (((TaskSuccessResult)result2).isUpToDate() ? TaskExecutionState.UP_TO_DATE : TaskExecutionState.SUCCESS)) : (taskOperationResult instanceof TaskSkippedResult ? TaskExecutionState.SKIPPED : (taskOperationResult instanceof TaskFailureResult ? TaskExecutionState.FAILED : TaskExecutionState.UNKNOWN));
            Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
            this.reportData(taskPath, duration, taskResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportData(String taskPath, long duration, TaskExecutionState taskResult) {
        Map map;
        Object object;
        List list2;
        List list3;
        Object item$iv$iv;
        Collection destination$iv$iv;
        Object $this$map$iv;
        ChangedFiles changedFiles;
        ChangedFiles changedFiles2;
        Object object2;
        Object object3;
        Object object4;
        Map map2;
        Object $this$filterValues$iv;
        Object object5;
        BuildTimes buildTimes;
        Object object6;
        Map map3;
        if (!this.availableForStat(taskPath)) {
            return;
        }
        TaskExecutionResult taskExecutionResult = TaskExecutionResults.INSTANCE.get(taskPath);
        TaskExecutionResult taskExecutionResult2 = taskExecutionResult;
        if (taskExecutionResult2 == null) {
            map3 = MapsKt.emptyMap();
        } else {
            object6 = taskExecutionResult2.getBuildMetrics();
            buildTimes = object6.getBuildTimes();
            $this$filterValues$iv = object5 = buildTimes.asMap();
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Object object7 = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry entry$iv : object7.entrySet()) {
                long value = ((Number)entry$iv.getValue()).longValue();
                boolean bl2 = false;
                if (!(value != 0L)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map3 = result$iv;
        }
        Map timeData = map3;
        object6 = taskExecutionResult;
        if (object6 == null) {
            map2 = MapsKt.emptyMap();
        } else {
            void $this$filterValues$iv2;
            void $this$mapValuesTo$iv$iv;
            buildTimes = ((TaskExecutionResult)object6).getBuildMetrics();
            object5 = buildTimes.getBuildPerformanceMetrics();
            Object $this$mapValues$iv = $this$filterValues$iv = object5.asMap();
            boolean $i$f$mapValues = false;
            Object object8 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean bl = false;
            Iterator bl2 = $this$associateByTo$iv$iv$iv.iterator();
            while (bl2.hasNext()) {
                void it;
                void it$iv$iv;
                Object element$iv$iv$iv = bl2.next();
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv2;
                boolean bl3 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                object4 = k;
                object3 = map4;
                boolean bl32 = false;
                object2 = ((Number)it.getValue()).longValue() / (long)1000;
                object3.put(object4, object2);
            }
            Map $i$f$filterValues = destination$iv$iv2;
            $this$mapValues$iv = $i$f$filterValues;
            boolean $i$f$filterValues2 = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            destination$iv$iv2 = $this$filterValues$iv2;
            $i$f$mapValuesTo = false;
            for (Map.Entry entry : destination$iv$iv2.entrySet()) {
                long value = ((Number)entry.getValue()).longValue();
                boolean bl4 = false;
                if (!(value != 0L)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            map2 = result$iv;
        }
        Map perfData = map2;
        object5 = taskExecutionResult;
        if (object5 == null) {
            changedFiles2 = null;
        } else {
            $this$filterValues$iv = ((TaskExecutionResult)object5).getTaskInfo();
            changedFiles2 = changedFiles = ((TaskExecutionInfo)$this$filterValues$iv).getChangedFiles();
        }
        if (changedFiles instanceof ChangedFiles.Known) {
            Object $this$mapTo$iv$iv;
            $this$map$iv = ((ChangedFiles.Known)changedFiles).getModified();
            boolean $i$f$map = false;
            Iterable $i$f$filterValues = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator result$iv = $this$mapTo$iv$iv.iterator();
            while (result$iv.hasNext()) {
                void it;
                item$iv$iv = result$iv.next();
                File $i$f$mapValuesTo = (File)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object4 = it.getAbsolutePath();
                object3.add(object4);
            }
            $this$map$iv = ((ChangedFiles.Known)changedFiles).getRemoved();
            object3 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            result$iv = $this$mapTo$iv$iv.iterator();
            while (result$iv.hasNext()) {
                item$iv$iv = result$iv.next();
                File it = (File)item$iv$iv;
                object4 = destination$iv$iv;
                boolean bl = false;
                object2 = it.getAbsolutePath();
                object4.add(object2);
            }
            object4 = (List)destination$iv$iv;
            list3 = CollectionsKt.plus((Collection)object3, (Iterable)((Iterable)object4));
        } else if (changedFiles instanceof ChangedFiles.Dependencies) {
            $this$map$iv = ((ChangedFiles.Dependencies)changedFiles).getModified();
            boolean $i$f$map = false;
            Object $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator result$iv = $this$mapTo$iv$iv.iterator();
            while (result$iv.hasNext()) {
                item$iv$iv = result$iv.next();
                File it = (File)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object4 = it.getAbsolutePath();
                object3.add(object4);
            }
            $this$map$iv = ((ChangedFiles.Dependencies)changedFiles).getRemoved();
            object3 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            result$iv = $this$mapTo$iv$iv.iterator();
            while (result$iv.hasNext()) {
                item$iv$iv = result$iv.next();
                File it = (File)item$iv$iv;
                object4 = destination$iv$iv;
                boolean bl = false;
                object2 = it.getAbsolutePath();
                object4.add(object2);
            }
            object4 = (List)destination$iv$iv;
            list3 = CollectionsKt.plus((Collection)object3, (Iterable)((Iterable)object4));
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List changes = list3;
        $this$map$iv = taskResult.name();
        String $i$f$map = this.getLabel();
        String string = this.projectName;
        Object $i$f$mapTo = taskExecutionResult;
        if ($i$f$mapTo == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            TaskExecutionInfo result$iv = ((TaskExecutionResult)$i$f$mapTo).getTaskInfo();
            object = result$iv.getProperties();
            Iterable $this$map$iv2 = (Iterable)object;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : iterable) {
                void it;
                TaskExecutionProperties bl3 = (TaskExecutionProperties)((Object)item$iv$iv2);
                object3 = destination$iv$iv3;
                boolean bl4 = false;
                object4 = it.name();
                object3.add(object4);
            }
            list2 = (List)destination$iv$iv3;
        }
        destination$iv$iv = list2;
        Object result$iv = taskExecutionResult;
        if (result$iv == null) {
            map = MapsKt.emptyMap();
        } else {
            object = ((TaskExecutionResult)result$iv).getBuildMetrics();
            BuildAttributes buildAttributes = object.getBuildAttributes();
            map = buildAttributes.asMap();
        }
        $i$f$mapTo = map;
        result$iv = this.getHostName();
        object = this.buildUuid;
        long l = System.currentTimeMillis();
        Intrinsics.checkNotNullExpressionValue((Object)result$iv, (String)"hostName");
        CompileStatData compileStatData = new CompileStatData(0, string, $i$f$map, taskPath, (String)$this$map$iv, duration, (List)destination$iv$iv, changes, (String)object, "1.6", (String)result$iv, l, (Map)$i$f$mapTo, timeData, perfData, 1, null);
        Iterable $this$forEach$iv = this.reportStatistics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReportStatistics it = (ReportStatistics)element$iv;
            boolean bl = false;
            it.report(compileStatData);
        }
    }

    private final boolean availableForStat(String taskPath) {
        return StringsKt.contains$default((CharSequence)taskPath, (CharSequence)"Kotlin", (boolean)false, (int)2, null) && TaskExecutionResults.INSTANCE.get(taskPath) != null;
    }

    public void afterExecute(@NotNull Task task, @NotNull TaskState taskState) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)taskState, (String)"taskState");
        TaskExecutionState taskResult = taskState.getSkipped() ? TaskExecutionState.SKIPPED : (taskState.getFailure() != null ? TaskExecutionState.FAILED : (taskState.getUpToDate() ? TaskExecutionState.UP_TO_DATE : (taskState.getDidWork() ? TaskExecutionState.SUCCESS : (taskState.getExecuted() ? TaskExecutionState.FROM_CACHE : TaskExecutionState.UNKNOWN))));
        String taskPath = task.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
        this.reportData(taskPath, 0L, taskResult);
    }

    @Override
    public void close() {
    }

    public void beforeExecute(@NotNull Task p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
    }
}

