/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js;

import java.io.File;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"JS", "", "JS_MAP", "META_JS", "appendConfigsFromDir", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "confDir", "Ljava/io/File;", "calculateDirHash", "Lorg/gradle/internal/hash/FileHasher;", "dir", "toHex", "", "kotlin-gradle-plugin"})
public final class UtilsKt {
    @NotNull
    public static final String JS = "js";
    @NotNull
    public static final String JS_MAP = "js.map";
    @NotNull
    public static final String META_JS = "meta.js";

    public static final void appendConfigsFromDir(@NotNull Appendable $this$appendConfigsFromDir, @NotNull File confDir) {
        Intrinsics.checkNotNullParameter((Object)$this$appendConfigsFromDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)confDir, (String)"confDir");
        Object[] objectArray = confDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] files = objectArray;
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])files), (Function1)appendConfigsFromDir.1.INSTANCE), (Function1)appendConfigsFromDir.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            StringUtilsKt.appendLine($this$appendConfigsFromDir, Intrinsics.stringPlus((String)"// ", (Object)it.getName()));
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $this$appendConfigsFromDir.append(FilesKt.readText$default((File)it, null, (int)1, null));
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
        }
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        int n = 0;
        int n2 = $this$toHex.length * 2;
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = 32;
        }
        char[] result2 = cArray;
        int i = 0;
        byte[] $this$forEach$iv = $this$toHex;
        boolean $i$f$forEach = false;
        byte[] byArray = $this$forEach$iv;
        int n4 = byArray.length;
        for (int j = 0; j < n4; ++j) {
            byte element$iv;
            byte it = element$iv = byArray[j];
            boolean bl = false;
            byte n5 = it;
            int n6 = i;
            i = n6 + 1;
            result2[n6] = Character.forDigit(n5 >> 4 & 0xF, 16);
            n6 = i;
            i = n6 + 1;
            result2[n6] = Character.forDigit(n5 & 0xF, 16);
        }
        return new String(result2);
    }

    @Nullable
    public static final String calculateDirHash(@NotNull FileHasher $this$calculateDirHash, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDirHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        if (!dir2.isDirectory()) {
            return null;
        }
        Hasher hasher = Hashing.defaultFunction().newHasher();
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)dir2, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            hasher.putString((CharSequence)FilesKt.toRelativeString((File)file, (File)dir2));
            if (!file.isFile()) continue;
            hasher.putHash($this$calculateDirHash.hash(file));
        }
        byte[] digest = hasher.hash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
        return UtilsKt.toHex(digest);
    }
}

