/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinGradleModule;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KpmProjectModelContainerKt;
import org.jetbrains.kotlin.project.model.KotlinModuleIdentifier;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/ProjectMppDependencyProjectStructureMetadataExtractor;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyProjectStructureMetadataExtractor;", "moduleIdentifier", "Lorg/jetbrains/kotlin/project/model/KotlinModuleIdentifier;", "dependencyProject", "Lorg/gradle/api/Project;", "(Lorg/jetbrains/kotlin/project/model/KotlinModuleIdentifier;Lorg/gradle/api/Project;)V", "getDependencyProject", "()Lorg/gradle/api/Project;", "getModuleIdentifier", "()Lorg/jetbrains/kotlin/project/model/KotlinModuleIdentifier;", "getProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "kotlin-gradle-plugin_common"})
public final class ProjectMppDependencyProjectStructureMetadataExtractor
extends MppDependencyProjectStructureMetadataExtractor {
    @NotNull
    private final KotlinModuleIdentifier moduleIdentifier;
    @NotNull
    private final Project dependencyProject;

    public ProjectMppDependencyProjectStructureMetadataExtractor(@NotNull KotlinModuleIdentifier moduleIdentifier, @NotNull Project dependencyProject) {
        Intrinsics.checkNotNullParameter((Object)moduleIdentifier, (String)"moduleIdentifier");
        Intrinsics.checkNotNullParameter((Object)dependencyProject, (String)"dependencyProject");
        super(null);
        this.moduleIdentifier = moduleIdentifier;
        this.dependencyProject = dependencyProject;
    }

    @NotNull
    public final KotlinModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    @NotNull
    public final Project getDependencyProject() {
        return this.dependencyProject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KotlinProjectStructureMetadata getProjectStructureMetadata() {
        KotlinProjectStructureMetadata kotlinProjectStructureMetadata;
        if (KotlinProjectExtensionKt.getTopLevelExtensionOrNull(this.dependencyProject) == null) {
            kotlinProjectStructureMetadata = null;
        } else if (KpmProjectModelContainerKt.getHasKpmModel(this.dependencyProject)) {
            void var3_3;
            Iterable $this$single$iv = (Iterable)KpmProjectModelContainerKt.getKpmModules(this.dependencyProject);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                KotlinGradleModule it = (KotlinGradleModule)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModuleIdentifier(), (Object)this.moduleIdentifier)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            void v1 = var3_3;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"dependencyProject.kpmMod\u2026ier == moduleIdentifier }");
            kotlinProjectStructureMetadata = KotlinProjectStructureMetadataKt.buildProjectStructureMetadata((KotlinGradleModule)v1);
        } else {
            kotlinProjectStructureMetadata = KotlinProjectStructureMetadataKt.buildKotlinProjectStructureMetadata(this.dependencyProject);
        }
        return kotlinProjectStructureMetadata;
    }
}

