/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.pm20;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.internal.build.BuildState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinSingleTargetExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.utils.ParsedGradleVersionKt;
import org.jetbrains.kotlin.project.model.KotlinModule;
import org.jetbrains.kotlin.project.model.KotlinModuleIdentifier;
import org.jetbrains.kotlin.project.model.LocalModuleIdentifier;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001d\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"archivesName", "", "Lorg/gradle/api/Project;", "getArchivesName", "(Lorg/gradle/api/Project;)Ljava/lang/String;", "distsDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "kotlin.jvm.PlatformType", "getDistsDirectory", "(Lorg/gradle/api/Project;)Lorg/gradle/api/file/DirectoryProperty;", "targets", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinProjectExtension;", "getTargets", "(Lorg/jetbrains/kotlin/gradle/dsl/KotlinProjectExtension;)Ljava/lang/Iterable;", "currentBuildId", "Lorg/gradle/api/artifacts/component/BuildIdentifier;", "representsProject", "", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "project", "kotlin-gradle-plugin_common"})
public final class UtilsKt {
    @NotNull
    public static final Iterable<KotlinTarget> getTargets(@NotNull KotlinProjectExtension $this$targets) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)$this$targets, (String)"<this>");
        KotlinProjectExtension kotlinProjectExtension = $this$targets;
        if (kotlinProjectExtension instanceof KotlinSingleTargetExtension) {
            iterable = CollectionsKt.listOf((Object)((KotlinSingleTargetExtension)$this$targets).getTarget());
        } else if (kotlinProjectExtension instanceof KotlinMultiplatformExtension) {
            iterable = (Iterable)((KotlinMultiplatformExtension)$this$targets).getTargets();
        } else {
            throw (Throwable)new IllegalStateException(("Unexpected 'kotlin' extension " + $this$targets).toString());
        }
        return iterable;
    }

    public static final boolean representsProject(@NotNull KotlinModule $this$representsProject, @NotNull Project project) {
        KotlinModuleIdentifier kotlinModuleIdentifier;
        Intrinsics.checkNotNullParameter((Object)$this$representsProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinModuleIdentifier it = kotlinModuleIdentifier = $this$representsProject.getModuleIdentifier();
        boolean bl = false;
        return it instanceof LocalModuleIdentifier && Intrinsics.areEqual((Object)((LocalModuleIdentifier)it).getBuildId(), (Object)UtilsKt.currentBuildId(project).getName()) && Intrinsics.areEqual((Object)((LocalModuleIdentifier)it).getProjectId(), (Object)project.getPath());
    }

    @NotNull
    public static final BuildIdentifier currentBuildId(@NotNull Project $this$currentBuildId) {
        Intrinsics.checkNotNullParameter((Object)$this$currentBuildId, (String)"<this>");
        Project project = $this$currentBuildId.getProject();
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
        BuildIdentifier buildIdentifier = ((BuildState)((ProjectInternal)project).getServices().get(BuildState.class)).getBuildIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)buildIdentifier, (String)"project as ProjectIntern\u2026ass.java).buildIdentifier");
        return buildIdentifier;
    }

    @Nullable
    public static final String getArchivesName(@NotNull Project $this$archivesName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$archivesName, (String)"<this>");
        if (ParsedGradleVersionKt.isGradleVersionAtLeast(7, 1)) {
            string = (String)((BasePluginExtension)$this$archivesName.getExtensions().getByType(BasePluginExtension.class)).getArchivesName().getOrNull();
        } else {
            BasePluginConvention basePluginConvention = (BasePluginConvention)$this$archivesName.getConvention().findPlugin(BasePluginConvention.class);
            string = basePluginConvention != null ? basePluginConvention.getArchivesBaseName() : null;
        }
        return string;
    }

    public static final DirectoryProperty getDistsDirectory(@NotNull Project $this$distsDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$distsDirectory, (String)"<this>");
        return ParsedGradleVersionKt.isGradleVersionAtLeast(7, 1) ? ((BasePluginExtension)$this$distsDirectory.getExtensions().getByType(BasePluginExtension.class)).getDistsDirectory() : ((BasePluginConvention)$this$distsDirectory.getConvention().getPlugin(BasePluginConvention.class)).getDistsDirectory();
    }
}

