/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandler;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J)\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/report/KotlinBuildReporterHandler;", "", "()V", "buildFinished", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "perfReportFile", "Ljava/io/File;", "kotlinTaskTimeNs", "", "", "", "allTasksTimeNs", "failure", "", "buildInfo", "taskOverview", "taskOverview$kotlin_gradle_plugin_common", "TextTable", "kotlin-gradle-plugin_common"})
public final class KotlinBuildReporterHandler {
    public final void buildFinished(@NotNull Gradle gradle, @NotNull File perfReportFile, @NotNull Map<String, Long> kotlinTaskTimeNs, long allTasksTimeNs, @Nullable Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        Intrinsics.checkNotNullParameter((Object)perfReportFile, (String)"perfReportFile");
        Intrinsics.checkNotNullParameter(kotlinTaskTimeNs, (String)"kotlinTaskTimeNs");
        Logger logger = gradle.getRootProject().getLogger();
        try {
            FilesKt.writeText$default((File)perfReportFile, (String)(this.buildInfo(gradle, failure) + this.taskOverview$kotlin_gradle_plugin_common(kotlinTaskTimeNs, allTasksTimeNs)), null, (int)2, null);
            logger.lifecycle("Kotlin build report is written to " + perfReportFile.getCanonicalPath());
        }
        catch (Throwable e) {
            logger.error("Could not write Kotlin build report to " + perfReportFile.getCanonicalPath(), e);
        }
    }

    public static /* synthetic */ void buildFinished$default(KotlinBuildReporterHandler kotlinBuildReporterHandler, Gradle gradle, File file, Map map, long l, Throwable throwable, int n, Object object) {
        if ((n & 0x10) != 0) {
            throwable = null;
        }
        kotlinBuildReporterHandler.buildFinished(gradle, file, map, l, throwable);
    }

    private final String buildInfo(Gradle gradle, Throwable failure) {
        ArrayList<String> startParams = new ArrayList<String>();
        Object object = gradle.getStartParameter();
        StartParameter $this$buildInfo_u24lambda_u240 = object;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder().append("tasks = ");
        List list2 = $this$buildInfo_u24lambda_u240.getTaskRequests();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"taskRequests");
        startParams.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)buildInfo.1.1.INSTANCE, (int)31, null)).toString());
        startParams.add("excluded tasks = " + $this$buildInfo_u24lambda_u240.getExcludedTaskNames());
        startParams.add("current dir = " + $this$buildInfo_u24lambda_u240.getCurrentDir());
        startParams.add("project properties args = " + $this$buildInfo_u24lambda_u240.getProjectProperties());
        startParams.add("system properties args = " + $this$buildInfo_u24lambda_u240.getSystemPropertiesArgs());
        Object $this$buildInfo_u24lambda_u242 = object = new StringBuilder();
        boolean bl2 = false;
        StringUtilsKt.appendLine((Appendable)$this$buildInfo_u24lambda_u242, "Gradle start parameters:");
        Iterable $this$forEach$iv = startParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            StringUtilsKt.appendLine((Appendable)$this$buildInfo_u24lambda_u242, "  " + it);
        }
        if (failure != null) {
            StringUtilsKt.appendLine((Appendable)$this$buildInfo_u24lambda_u242, "Build failed: " + failure);
        }
        StringUtilsKt.appendLine((Appendable)$this$buildInfo_u24lambda_u242);
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String taskOverview$kotlin_gradle_plugin_common(@NotNull Map<String, Long> kotlinTaskTimeNs, long allTasksTimeNs) {
        void $this$forEach$iv;
        Iterable $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(kotlinTaskTimeNs, (String)"kotlinTaskTimeNs");
        if (kotlinTaskTimeNs.isEmpty()) {
            StringBuilder stringBuilder;
            StringBuilder $this$taskOverview_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringUtilsKt.appendLine($this$taskOverview_u24lambda_u243, "No Kotlin task was run");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }
        StringBuilder sb = new StringBuilder();
        long kotlinTotalTimeNs = CollectionsKt.sumOfLong((Iterable)kotlinTaskTimeNs.values());
        String ktTaskPercent = KotlinBuildReporterHandlerKt.asString((double)kotlinTotalTimeNs / (double)allTasksTimeNs * (double)100, 1);
        StringUtilsKt.appendLine(sb, "Total time for Kotlin tasks: " + KotlinBuildReporterHandlerKt.formatTime(kotlinTotalTimeNs) + " (" + ktTaskPercent + " % of all tasks time)");
        Object object = new String[]{"Time", "% of Kotlin time", "Task"};
        TextTable table = new TextTable((String)object);
        object = kotlinTaskTimeNs.entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)b;
                boolean bl = false;
                long timeNs = ((Number)entry.getValue()).longValue();
                entry = (Map.Entry)a;
                Comparable comparable = Long.valueOf(timeNs);
                bl = false;
                timeNs = ((Number)entry.getValue()).longValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(timeNs));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String taskPath = (String)entry.getKey();
            long timeNs = ((Number)entry.getValue()).longValue();
            String percent = KotlinBuildReporterHandlerKt.asString((double)timeNs / (double)kotlinTotalTimeNs * (double)100, 1);
            String[] stringArray = new String[]{KotlinBuildReporterHandlerKt.formatTime(timeNs), percent + " %", taskPath};
            table.addRow(stringArray);
        }
        table.printTo(sb);
        StringUtilsKt.appendLine(sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/report/KotlinBuildReporterHandler$TextTable;", "", "columnNames", "", "", "([Ljava/lang/String;)V", "columnsCount", "", "maxLengths", "", "rows", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "addRow", "", "row", "printTo", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "kotlin-gradle-plugin_common"})
    public static final class TextTable {
        @NotNull
        private final ArrayList<List<String>> rows;
        private final int columnsCount;
        @NotNull
        private final int[] maxLengths;

        public TextTable(String ... columnNames) {
            Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
            this.rows = new ArrayList();
            this.columnsCount = columnNames.length;
            int n = 0;
            int n2 = this.columnsCount;
            int[] nArray = new int[n2];
            TextTable textTable = this;
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = columnNames[n3].length();
            }
            textTable.maxLengths = nArray;
            this.rows.add(ArraysKt.toList((Object[])columnNames));
        }

        public final void addRow(String ... row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            if (!(row.length == this.columnsCount)) {
                boolean bl = false;
                String string = "Row size " + row.length + " differs from columns count " + this.columnsCount;
                throw new IllegalStateException(string.toString());
            }
            this.rows.add(ArraysKt.toList((Object[])row));
            int n = row.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                String col = row[j];
                this.maxLengths[i2] = Math.max(this.maxLengths[i2], col.length());
            }
        }

        public final void printTo(@NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            for (List<String> row : this.rows) {
                StringUtilsKt.appendLine(sb);
                Iterator<String> iterator = row.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i2 = n++;
                    String col = iterator.next();
                    if (i2 > 0) {
                        sb.append("|");
                    }
                    sb.append(StringsKt.padEnd((String)col, (int)this.maxLengths[i2], (char)' '));
                }
            }
        }
    }
}

