/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmRangeKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmVersionsKt;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnLock;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEntryRegistry;", "", "lockFile", "Ljava/io/File;", "(Ljava/io/File;)V", "entryMap", "", "", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnLock$Entry;", "dependencyKey", "getDependencyKey", "(Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnLock$Entry;)Ljava/lang/String;", "packageKey", "version", "find", "correctDependencyKey", "kotlin-gradle-plugin_common"})
public final class YarnEntryRegistry {
    @NotNull
    private final File lockFile;
    @NotNull
    private final Map<String, YarnLock.Entry> entryMap;

    /*
     * WARNING - void declaration
     */
    public YarnEntryRegistry(@NotNull File lockFile) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)lockFile, (String)"lockFile");
        this.lockFile = lockFile;
        Iterable iterable = YarnLock.Companion.parse(this.lockFile).getEntries();
        YarnEntryRegistry yarnEntryRegistry = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            YarnLock.Entry entry = (YarnLock.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(this.getDependencyKey((YarnLock.Entry)it), element$iv$iv);
        }
        yarnEntryRegistry.entryMap = destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YarnLock.Entry find(@NotNull String packageKey, @NotNull String version2) {
        Object v1;
        String key;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)packageKey, (String)"packageKey");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            key = this.dependencyKey(packageKey, version2);
            YarnLock.Entry entry = this.entryMap.get(key);
            if (entry != null) {
                return entry;
            }
            Iterable iterable = this.entryMap.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry entry2 = (Map.Entry)element$iv;
                boolean bl = false;
                YarnLock.Entry entry3 = (YarnLock.Entry)entry2.getValue();
                boolean bl2 = entry3.getVersion() == null ? false : NpmRangeKt.intersect(NpmVersionsKt.includedRange$default(version2, false, 2, null), NpmVersionsKt.includedRange$default(entry3.getVersion(), false, 2, null)) != null;
                if (!bl2) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Map.Entry entry = v1;
        if (entry != null) {
            Map.Entry it = entry;
            boolean bl = false;
            return (YarnLock.Entry)it.getValue();
        }
        throw new GradleException("Cannot find " + key + " in yarn.lock");
    }

    private final String getDependencyKey(YarnLock.Entry $this$dependencyKey) {
        return this.correctDependencyKey($this$dependencyKey.getKey());
    }

    private final String dependencyKey(String packageKey, String version2) {
        return this.correctDependencyKey(YarnLock.Companion.dependencyKey(packageKey, version2));
    }

    private final String correctDependencyKey(String $this$correctDependencyKey) {
        String string;
        if (StringsKt.contains$default((CharSequence)$this$correctDependencyKey, (CharSequence)"@github:", (boolean)false, (int)2, null)) {
            string = StringsKt.replace$default((String)$this$correctDependencyKey, (String)"@github:", (String)"@", (boolean)false, (int)4, null);
        } else if (StringsKt.contains$default((CharSequence)$this$correctDependencyKey, (CharSequence)"@file:", (boolean)false, (int)2, null)) {
            String location = StringsKt.substringAfter$default((String)$this$correctDependencyKey, (String)"@file:", null, (int)2, null);
            File file = this.lockFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"lockFile\n                    .parentFile");
            String path = FilesKt.resolve((File)file, (String)location).getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            string = StringsKt.replaceAfter$default((String)$this$correctDependencyKey, (String)"@file:", (String)path, null, (int)4, null);
        } else {
            string = $this$correctDependencyKey;
        }
        return string;
    }
}

