/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.gradle.targets.js.npm.GradleNodeModule;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmDependencyKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolved.KotlinCompilationNpmResolution;
import org.jetbrains.kotlin.gradle.targets.js.yarn.ResolvedNpmDependency;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnImportedPackagesVersionResolver;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\u001a\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001c\u0010\u001b\u001a\u00020\u00182\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0018H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnImportedPackagesVersionResolver;", "", "logger", "Lorg/gradle/api/logging/Logger;", "npmProjects", "", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolved/KotlinCompilationNpmResolution;", "nodeJsWorldDir", "Ljava/io/File;", "(Lorg/gradle/api/logging/Logger;Ljava/util/Collection;Ljava/io/File;)V", "externalModules", "", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/GradleNodeModule;", "importedProjectWorkspaces", "", "", "internalCompositeModules", "resolvedVersion", "", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/ResolvedNpmDependency;", "resolve", "", "modules", "isWorkspace", "", "resolveAndUpdatePackages", "updatePackages", "updateVersionsMap", "map", "writePackageJson", "packageJson", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/PackageJson;", "path", "forceWrite", "kotlin-gradle-plugin_common"})
public final class YarnImportedPackagesVersionResolver {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Collection<KotlinCompilationNpmResolution> npmProjects;
    @NotNull
    private final File nodeJsWorldDir;
    @NotNull
    private final Map<String, ResolvedNpmDependency> resolvedVersion;
    @NotNull
    private final List<String> importedProjectWorkspaces;
    @NotNull
    private final Set<GradleNodeModule> externalModules;
    @NotNull
    private final Set<GradleNodeModule> internalCompositeModules;

    public YarnImportedPackagesVersionResolver(@NotNull Logger logger, @NotNull Collection<KotlinCompilationNpmResolution> npmProjects, @NotNull File nodeJsWorldDir) {
        Collection destination$iv;
        Iterable list$iv;
        KotlinCompilationNpmResolution it;
        Iterable $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(npmProjects, (String)"npmProjects");
        Intrinsics.checkNotNullParameter((Object)nodeJsWorldDir, (String)"nodeJsWorldDir");
        this.logger = logger;
        this.npmProjects = npmProjects;
        this.nodeJsWorldDir = nodeJsWorldDir;
        this.resolvedVersion = new LinkedHashMap();
        this.importedProjectWorkspaces = new ArrayList();
        Iterable iterable = this.npmProjects;
        Collection collection = new LinkedHashSet();
        YarnImportedPackagesVersionResolver yarnImportedPackagesVersionResolver = this;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            it = (KotlinCompilationNpmResolution)element$iv;
            boolean bl = false;
            list$iv = it.getExternalGradleDependencies();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        yarnImportedPackagesVersionResolver.externalModules = (Set)destination$iv;
        $this$flatMapTo$iv = this.npmProjects;
        destination$iv = new LinkedHashSet();
        yarnImportedPackagesVersionResolver = this;
        $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            it = (KotlinCompilationNpmResolution)element$iv;
            boolean bl = false;
            list$iv = it.getInternalCompositeDependencies();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        yarnImportedPackagesVersionResolver.internalCompositeModules = (Set)destination$iv;
    }

    @NotNull
    public final List<String> resolveAndUpdatePackages() {
        this.resolve(this.externalModules, true);
        this.resolve(this.internalCompositeModules, true);
        if (!this.resolvedVersion.isEmpty()) {
            this.updatePackages(this.internalCompositeModules);
        }
        return this.importedProjectWorkspaces;
    }

    /*
     * WARNING - void declaration
     */
    private final void resolve(Set<GradleNodeModule> modules, boolean isWorkspace) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = modules;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            GradleNodeModule it = (GradleNodeModule)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            GradleNodeModule selected2;
            GradleNodeModule gradleNodeModule;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String name2 = (String)entry.getKey();
            List versions2 = (List)entry.getValue();
            if (versions2.size() > 1) {
                Iterable $this$sortedBy$iv = versions2;
                boolean $i$f$sortedBy = false;
                List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        GradleNodeModule it = (GradleNodeModule)a;
                        boolean bl = false;
                        Comparable comparable = it.getSemver();
                        it = (GradleNodeModule)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getSemver());
                    }
                });
                this.logger.warn("There are multiple versions of \"" + name2 + "\" used in nodejs build: " + CollectionsKt.joinToString$default((Iterable)sorted, (CharSequence)", ", null, null, (int)0, null, (Function1)resolve.2.selected.1.INSTANCE, (int)30, null) + ". Only latest version will be used.");
                GradleNodeModule selected3 = (GradleNodeModule)CollectionsKt.last((List)sorted);
                this.resolvedVersion.put(name2, new ResolvedNpmDependency(selected3.getVersion(), selected3.getPath()));
                gradleNodeModule = selected3;
            } else {
                gradleNodeModule = selected2 = (GradleNodeModule)CollectionsKt.single((List)versions2);
            }
            if (!isWorkspace) continue;
            String string = FilesKt.relativeTo((File)selected2.getPath(), (File)this.nodeJsWorldDir).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selected.path.relativeTo(nodeJsWorldDir).path");
            this.importedProjectWorkspaces.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updatePackages(Set<GradleNodeModule> modules) {
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackageJson packageJson2;
            GradleNodeModule it = (GradleNodeModule)element$iv;
            boolean bl = false;
            File packageJsonFile2 = FilesKt.resolve((File)it.getPath(), (String)"package.json");
            Object object = packageJsonFile2;
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader it2 = (InputStreamReader)object;
                boolean bl2 = false;
                packageJson2 = new Gson().fromJson((Reader)it2, PackageJson.class);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            PackageJson packageJson3 = packageJson2;
            Intrinsics.checkNotNullExpressionValue((Object)packageJson3, (String)"packageJson");
            this.writePackageJson(packageJson3, packageJsonFile2, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePackageJson(PackageJson packageJson2, File path, boolean forceWrite) {
        block10: {
            block9: {
                boolean bl;
                block8: {
                    void $this$mapTo$iv$iv;
                    Object[] objectArray = new Map[]{packageJson2.getDependencies(), packageJson2.getDevDependencies()};
                    Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Map map = (Map)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(this.updateVersionsMap((Map<String, String>)it));
                    }
                    List updates = (List)destination$iv$iv;
                    if (forceWrite) break block9;
                    Iterable $this$any$iv = updates;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean it = (Boolean)element$iv;
                            boolean bl3 = false;
                            if (!it) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block10;
            }
            packageJson2.saveTo(path);
        }
    }

    private final boolean updateVersionsMap(Map<String, String> map) {
        Ref.BooleanRef doneSomething = new Ref.BooleanRef();
        Function1 function1 = (Function1)new Function1<Map.Entry<String, String>, Unit>(this, doneSomething){
            final /* synthetic */ YarnImportedPackagesVersionResolver this$0;
            final /* synthetic */ Ref.BooleanRef $doneSomething;
            {
                this.this$0 = $receiver;
                this.$doneSomething = $doneSomething;
                super(1);
            }

            public final void invoke(@NotNull Map.Entry<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ResolvedNpmDependency resolved = (ResolvedNpmDependency)YarnImportedPackagesVersionResolver.access$getResolvedVersion$p(this.this$0).get(it.getKey());
                if (resolved != null && !Intrinsics.areEqual((Object)it.getValue(), (Object)resolved.getVersion())) {
                    it.setValue(NpmDependencyKt.fileVersion(resolved.getFile()));
                    this.$doneSomething.element = true;
                }
            }
        };
        map.entrySet().iterator().forEachRemaining(new Consumer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0) {
                this.function.invoke(p0);
            }
        });
        return doneSomething.element;
    }

    public static final /* synthetic */ Map access$getResolvedVersion$p(YarnImportedPackagesVersionResolver $this) {
        return $this.resolvedVersion;
    }
}

