/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.FileReportSettings;
import org.jetbrains.kotlin.gradle.report.HttpReportSettings;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "rootProject", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
public final class ConfigureReporingKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ReportingSettings reportingSettings(@NotNull Project rootProject) {
        Object object;
        File file;
        BuildScanSettings buildScanSettings;
        HttpReportSettings httpReportSettings;
        FileReportSettings fileReportSettings;
        FileReportSettings fileReportSettings2;
        BuildReportMode buildReportMode;
        Object object2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        PropertiesProvider properties2 = PropertiesProvider.Companion.invoke(rootProject);
        Iterable $this$map$iv = properties2.getBuildReportOutputs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BuildReportType buildReportType;
            void it;
            Collection collection;
            block15: {
                object2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                BuildReportType[] $this$firstOrNull$iv = BuildReportType.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    BuildReportType element$iv;
                    BuildReportType brt = element$iv = $this$firstOrNull$iv[j];
                    boolean bl2 = false;
                    String string = brt.name();
                    String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString().toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase()");
                    if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
                    buildReportType = element$iv;
                    break block15;
                }
                buildReportType = null;
            }
            if (buildReportType == null) {
                throw new IllegalStateException("Unknown output type: " + (String)it);
            }
            collection.add(buildReportType);
        }
        List buildReportOutputTypes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        BuildReportMode buildReportMode2 = buildReportMode = buildReportOutputTypes.isEmpty() ? BuildReportMode.NONE : BuildReportMode.VERBOSE;
        if (buildReportOutputTypes.contains(BuildReportType.FILE)) {
            File file2 = properties2.getBuildReportFileOutputDir();
            if (file2 == null) {
                File file3 = rootProject.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"rootProject.buildDir");
                file2 = FilesKt.resolve((File)file3, (String)"reports/kotlin-build");
            }
            File buildReportDir = file2;
            boolean includeMetricsInReport = properties2.getBuildReportMetrics() || buildReportMode == BuildReportMode.VERBOSE;
            fileReportSettings2 = new FileReportSettings(buildReportDir, includeMetricsInReport);
        } else {
            fileReportSettings2 = fileReportSettings = (FileReportSettings)null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.HTTP)) {
            String string = properties2.getBuildReportHttpUrl();
            if (string == null) {
                throw new IllegalStateException("Can't configure http report: 'kotlin.build.report.http.url' property is mandatory");
            }
            String url = string;
            String password = properties2.getBuildReportHttpPassword();
            String user = properties2.getBuildReportHttpUser();
            httpReportSettings = new HttpReportSettings(url, password, user, properties2.getBuildReportHttpVerboseEnvironment());
        } else {
            httpReportSettings = null;
        }
        HttpReportSettings httpReportSettings2 = httpReportSettings;
        BuildScanSettings buildScanSettings2 = buildScanSettings = buildReportOutputTypes.contains(BuildReportType.BUILD_SCAN) ? new BuildScanSettings(properties2.getBuildReportBuildScanCustomValuesLimit()) : (BuildScanSettings)null;
        if (buildReportOutputTypes.contains(BuildReportType.SINGLE_FILE)) {
            file = properties2.getBuildReportSingleFile();
            if (file == null) {
                throw new IllegalStateException("Can't configure single file report: 'kotlin.build.report.single_file' property is mandatory");
            }
        } else {
            file = null;
        }
        File singleOutputFile = file;
        File file4 = properties2.getSingleBuildMetricsFile();
        if (file4 != null) {
            Object it = object2 = file4;
            boolean bl = false;
            buildReportOutputTypes.add(BuildReportType.SINGLE_FILE);
            object = object2;
        } else {
            object = null;
        }
        Object oldSingleBuildMetric = object;
        String string = properties2.getBuildReportLabel();
        Object object3 = singleOutputFile;
        if (object3 == null) {
            object3 = oldSingleBuildMetric;
        }
        object2 = object3;
        return new ReportingSettings(buildReportOutputTypes, buildReportMode, string, fileReportSettings, httpReportSettings2, buildScanSettings, (File)object2);
    }
}

