/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.hash.FileHasher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnEnv;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnRootExtensionKt;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnSetupTask;
import org.jetbrains.kotlin.gradle.utils.ArchiveOperationsCompat;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u00102\u001a\u000200H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00020\r8G\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001f8QX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8QX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0017R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010,\u001a\u0004\u0018\u00010\r8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u001d\u001a\u0004\b-\u0010\u0010\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveOperations", "Lorg/jetbrains/kotlin/gradle/utils/ArchiveOperationsCompat;", "configuration", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/artifacts/Configuration;", "getConfiguration$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Provider;", "setConfiguration$kotlin_gradle_plugin_common", "(Lorg/gradle/api/provider/Provider;)V", "destination", "Ljava/io/File;", "getDestination$annotations", "getDestination", "()Ljava/io/File;", "destinationHashFile", "getDestinationHashFile", "downloadUrl", "", "getDownloadUrl$annotations", "getDownloadUrl", "()Ljava/lang/String;", "env", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEnv;", "getEnv", "()Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEnv;", "env$delegate", "Lkotlin/Lazy;", "fileHasher", "Lorg/gradle/internal/hash/FileHasher;", "getFileHasher$kotlin_gradle_plugin_common", "()Lorg/gradle/internal/hash/FileHasher;", "fs", "Lorg/gradle/api/file/FileSystemOperations;", "getFs$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/FileSystemOperations;", "ivyDependency", "getIvyDependency", "settings", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnRootExtension;", "shouldDownload", "", "yarnDist", "getYarnDist", "yarnDist$delegate", "extract", "", "archive", "setup", "Companion", "kotlin-gradle-plugin_common"})
public class YarnSetupTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient YarnRootExtension settings;
    @NotNull
    private final Lazy env$delegate;
    private final boolean shouldDownload;
    @NotNull
    private final ArchiveOperationsCompat archiveOperations;
    public transient Provider<Configuration> configuration;
    @NotNull
    private final Lazy yarnDist$delegate;
    @NotNull
    public static final String NAME = "kotlinYarnSetup";

    public YarnSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.settings = YarnRootExtensionKt.getYarn(project);
        this.env$delegate = LazyKt.lazy((Function0)((Function0)new Function0<YarnEnv>(this){
            final /* synthetic */ YarnSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final YarnEnv invoke() {
                return (YarnEnv)YarnSetupTask.access$getSettings$p(this.this$0).requireConfigured();
            }
        }));
        this.shouldDownload = this.settings.getDownload();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.archiveOperations = new ArchiveOperationsCompat(project2);
        this.setGroup("nodeJs");
        this.setDescription("Download and install a local yarn version");
        this.yarnDist$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ YarnSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final File invoke() {
                File file;
                if (YarnSetupTask.access$getShouldDownload$p(this.this$0)) {
                    IStatisticsValuesConsumer iStatisticsValuesConsumer;
                    Function1 function1 = (Function1)new Function1<IvyArtifactRepository, Unit>(this.this$0){
                        final /* synthetic */ YarnSetupTask this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(IvyArtifactRepository repo2) {
                            repo2.setName("Yarn Distributions at " + this.this$0.getDownloadUrl());
                            repo2.setUrl(new URI(this.this$0.getDownloadUrl()));
                            Function1 function1 = yarnDist.repo.1.INSTANCE;
                            repo2.patternLayout(new Action(function1){
                                private final /* synthetic */ Function1 function;
                                {
                                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                    this.function = function;
                                }

                                public final /* synthetic */ void execute(Object p0) {
                                    this.function.invoke(p0);
                                }
                            });
                            function1 = yarnDist.repo.2.INSTANCE;
                            repo2.metadataSources(new /* invalid duplicate definition of identical inner class */);
                            function1 = yarnDist.repo.3.INSTANCE;
                            repo2.content(new /* invalid duplicate definition of identical inner class */);
                        }
                    };
                    IvyArtifactRepository repo2 = this.this$0.getProject().getRepositories().ivy(new /* invalid duplicate definition of identical inner class */);
                    long startDownloadTime = System.currentTimeMillis();
                    Set set2 = ((Configuration)this.this$0.getConfiguration$kotlin_gradle_plugin_common().get()).getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"configuration.get().files");
                    File dist = (File)CollectionsKt.single((Iterable)set2);
                    long downloadDuration = System.currentTimeMillis() - startDownloadTime;
                    if (downloadDuration > 0L && (iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance()) != null) {
                        IStatisticsValuesConsumer.DefaultImpls.report$default(iStatisticsValuesConsumer, NumericalMetrics.ARTIFACTS_DOWNLOAD_SPEED, dist.length() * (long)1000 / downloadDuration, null, 4, null);
                    }
                    this.this$0.getProject().getRepositories().remove((Object)repo2);
                    file = dist;
                } else {
                    file = null;
                }
                return file;
            }
        }));
        Function1 function1 = (Function1)new Function1<Task, Boolean>(){

            @NotNull
            public final Boolean invoke(Task it) {
                return shouldDownload;
            }
        };
        this.onlyIf(new Spec(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
    }

    private final YarnEnv getEnv() {
        Lazy lazy = this.env$delegate;
        return (YarnEnv)lazy.getValue();
    }

    @Inject
    @NotNull
    public FileHasher getFileHasher$kotlin_gradle_plugin_common() {
        throw new IllegalStateException("Should be injected".toString());
    }

    @Inject
    @NotNull
    public FileSystemOperations getFs$kotlin_gradle_plugin_common() {
        throw new IllegalStateException("Should be injected".toString());
    }

    @Input
    @NotNull
    public final String getDownloadUrl() {
        return this.getEnv().getDownloadUrl();
    }

    public static /* synthetic */ void getDownloadUrl$annotations() {
    }

    @OutputDirectory
    @NotNull
    public final File getDestination() {
        return this.getEnv().getHome();
    }

    public static /* synthetic */ void getDestination$annotations() {
    }

    @OutputFile
    @NotNull
    public final File getDestinationHashFile() {
        File file = this.getDestination().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"destination.parentFile");
        return FilesKt.resolve((File)file, (String)(this.getDestination().getName() + ".hash"));
    }

    @Input
    @NotNull
    public final String getIvyDependency() {
        return this.getEnv().getIvyDependency();
    }

    @Internal
    @NotNull
    public final Provider<Configuration> getConfiguration$kotlin_gradle_plugin_common() {
        Provider<Configuration> provider = this.configuration;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        return null;
    }

    public final void setConfiguration$kotlin_gradle_plugin_common(@NotNull Provider<Configuration> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.configuration = provider;
    }

    @Classpath
    @Optional
    @Nullable
    public final File getYarnDist() {
        Lazy lazy = this.yarnDist$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void setup() {
        boolean bl;
        if (!this.shouldDownload) {
            return;
        }
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Using yarn distribution from '" + this.getYarnDist() + '\'');
        Object dirHash = null;
        File file = this.getDestinationHashFile();
        boolean bl2 = false;
        if (file.exists()) {
            void $this$useLines$iv$iv;
            File $this$useLines_u24default$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            File file2 = $this$useLines_u24default$iv;
            Charset charset$iv$iv = charset$iv;
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv$iv;
            int n = 8192;
            Reader reader = closeable;
            closeable = (reader = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), charset$iv$iv)) instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            Throwable throwable = null;
            try {
                void it;
                String string;
                BufferedReader it$iv$iv = (BufferedReader)closeable;
                boolean bl3 = false;
                Sequence it2 = TextStreamsKt.lineSequence((BufferedReader)it$iv$iv);
                boolean bl4 = false;
                String string2 = string = UtilsKt.calculateDirHash(this.getFileHasher$kotlin_gradle_plugin_common(), this.getDestination());
                Object object = SequencesKt.single((Sequence)it2);
                boolean bl5 = false;
                dirHash = it;
                boolean bl6 = Intrinsics.areEqual((Object)object, (Object)string);
                bl = bl6;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            bl = false;
        }
        boolean upToDate = bl;
        File tmpDir = this.getTemporaryDir();
        File file3 = this.getYarnDist();
        Intrinsics.checkNotNull((Object)file3);
        Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
        this.extract(file3, tmpDir);
        if (upToDate) {
            FileHasher fileHasher = this.getFileHasher$kotlin_gradle_plugin_common();
            String string = this.getDestination().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destination.name");
            String string3 = UtilsKt.calculateDirHash(fileHasher, FilesKt.resolve((File)tmpDir, (String)string));
            Intrinsics.checkNotNull((Object)string3);
            if (Intrinsics.areEqual((Object)string3, dirHash)) {
                FilesKt.deleteRecursively((File)tmpDir);
                return;
            }
        }
        if (this.getDestination().isDirectory()) {
            FilesKt.deleteRecursively((File)this.getDestination());
        }
        Function1 function1 = (Function1)new Function1<CopySpec, Unit>(tmpDir, this){
            final /* synthetic */ File $tmpDir;
            final /* synthetic */ YarnSetupTask this$0;
            {
                this.$tmpDir = $tmpDir;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(CopySpec it) {
                Object[] objectArray = new Object[]{this.$tmpDir};
                it.from(objectArray);
                it.into((Object)this.this$0.getDestination().getParentFile());
            }
        };
        this.getFs$kotlin_gradle_plugin_common().copy(new /* invalid duplicate definition of identical inner class */);
        FilesKt.deleteRecursively((File)tmpDir);
        File file4 = this.getDestinationHashFile();
        String string = UtilsKt.calculateDirHash(this.getFileHasher$kotlin_gradle_plugin_common(), this.getDestination());
        Intrinsics.checkNotNull((Object)string);
        FilesKt.writeText$default((File)file4, (String)string, null, (int)2, null);
    }

    private final void extract(File archive, File destination) {
        String string = archive.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"archive.name");
        String dirInTar = StringsKt.removeSuffix((String)string, (CharSequence)".tar.gz");
        Function1 function1 = (Function1)new Function1<CopySpec, Unit>(this, archive, destination, dirInTar){
            final /* synthetic */ YarnSetupTask this$0;
            final /* synthetic */ File $archive;
            final /* synthetic */ File $destination;
            final /* synthetic */ String $dirInTar;
            {
                this.this$0 = $receiver;
                this.$archive = $archive;
                this.$destination = $destination;
                this.$dirInTar = $dirInTar;
                super(1);
            }

            public final void invoke(CopySpec it) {
                Object[] objectArray = new Object[]{YarnSetupTask.access$getArchiveOperations$p(this.this$0).tarTree(this.$archive)};
                it.from(objectArray);
                it.into((Object)this.$destination);
                it.setIncludeEmptyDirs(false);
                objectArray = (Object[])new Function1<FileCopyDetails, Unit>(this.$dirInTar){
                    final /* synthetic */ String $dirInTar;
                    {
                        this.$dirInTar = $dirInTar;
                        super(1);
                    }

                    public final void invoke(FileCopyDetails fileCopy) {
                        String string = fileCopy.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileCopy.path");
                        fileCopy.setPath(StringsKt.removePrefix((String)string, (CharSequence)this.$dirInTar));
                    }
                };
                it.eachFile(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.getFs$kotlin_gradle_plugin_common().copy(new /* invalid duplicate definition of identical inner class */);
    }

    public static final /* synthetic */ ArchiveOperationsCompat access$getArchiveOperations$p(YarnSetupTask $this) {
        return $this.archiveOperations;
    }

    public static final /* synthetic */ YarnRootExtension access$getSettings$p(YarnSetupTask $this) {
        return $this.settings;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnSetupTask$Companion;", "", "()V", "NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

