/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.conn;

import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpHost;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.conn.SchemePortResolver;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.conn.UnsupportedSchemeException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name2 = host.getSchemeName();
        if (name2.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name2.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name2 + " protocol is not supported");
    }
}

