/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.transforms;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.gradle.report.BuildMetricsService;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshotGranularity;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotter;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;

@CacheableTransform
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/ClasspathEntrySnapshotTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/jetbrains/kotlin/gradle/internal/transforms/ClasspathEntrySnapshotTransform$Parameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "doTransform", "", "classpathEntryInputDirOrJar", "Ljava/io/File;", "snapshotOutputFile", "granularity", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshotGranularity;", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "getClassSnapshotGranularity", "classpathEntryDirOrJar", "gradleUserHomeDir", "transform", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class ClasspathEntrySnapshotTransform
implements TransformAction<Parameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs) {
        BuildMetricsReporter buildMetricsReporter;
        BuildMetricsService buildMetricsReporterService;
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        File classpathEntryInputDirOrJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        StringBuilder stringBuilder = new StringBuilder();
        String string = classpathEntryInputDirOrJar.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classpathEntryInputDirOrJar.name");
        File snapshotOutputFile = outputs.file((Object)stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'_', (boolean)false, (int)4, null)).append("-snapshot.bin").toString());
        Intrinsics.checkNotNullExpressionValue((Object)classpathEntryInputDirOrJar, (String)"classpathEntryInputDirOrJar");
        File file = ((Directory)((Parameters)this.getParameters()).getGradleUserHomeDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.gradleUserHomeDir.get().asFile");
        ClassSnapshotGranularity granularity = this.getClassSnapshotGranularity(classpathEntryInputDirOrJar, file);
        BuildMetricsService buildMetricsService = buildMetricsReporterService = (BuildMetricsService)((Parameters)this.getParameters()).getBuildMetricsService().getOrNull();
        if (buildMetricsService != null) {
            BuildMetricsService it = buildMetricsService;
            boolean bl = false;
            buildMetricsReporter = (BuildMetricsReporter)new BuildMetricsReporterImpl();
        } else {
            buildMetricsReporter = (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE;
        }
        BuildMetricsReporter metricsReporter = buildMetricsReporter;
        long startTimeMs = System.currentTimeMillis();
        String failureMessage = null;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)snapshotOutputFile, (String)"snapshotOutputFile");
            this.doTransform(classpathEntryInputDirOrJar, snapshotOutputFile, granularity, metricsReporter);
        }
        catch (Throwable e) {
            failureMessage = e.getMessage();
            throw e;
        }
        finally {
            BuildMetricsService buildMetricsService2 = buildMetricsReporterService;
            if (buildMetricsService2 != null) {
                buildMetricsService2.addTransformMetrics(Reflection.getOrCreateKotlinClass(ClasspathEntrySnapshotTransform.class).getSimpleName() + " for " + classpathEntryInputDirOrJar.getPath(), ClasspathEntrySnapshotTransform.class, true, startTimeMs, System.currentTimeMillis() - startTimeMs, metricsReporter.getMetrics(), failureMessage);
            }
        }
    }

    private final ClassSnapshotGranularity getClassSnapshotGranularity(File classpathEntryDirOrJar, File gradleUserHomeDir) {
        return FilesKt.startsWith((File)classpathEntryDirOrJar, (File)gradleUserHomeDir) || Intrinsics.areEqual((Object)classpathEntryDirOrJar.getName(), (Object)"android.jar") ? ClassSnapshotGranularity.CLASS_LEVEL : ClassSnapshotGranularity.CLASS_MEMBER_LEVEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doTransform(File classpathEntryInputDirOrJar, File snapshotOutputFile, ClassSnapshotGranularity granularity, BuildMetricsReporter metrics) {
        void $this$measure$iv;
        BuildMetricsReporter buildMetricsReporter = metrics;
        BuildTime time$iv = BuildTime.CLASSPATH_ENTRY_SNAPSHOT_TRANSFORM;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            void $this$measure$iv2;
            boolean bl = false;
            ClasspathEntrySnapshot snapshot = ClasspathEntrySnapshotter.INSTANCE.snapshot(classpathEntryInputDirOrJar, granularity, metrics);
            BuildMetricsReporter buildMetricsReporter2 = metrics;
            BuildTime time$iv2 = BuildTime.SAVE_CLASSPATH_ENTRY_SNAPSHOT;
            boolean $i$f$measure2 = false;
            $this$measure$iv2.startMeasure(time$iv2);
            try {
                boolean bl2 = false;
                ExternalizersKt.saveToFile((DataExternalizer)((DataExternalizer)ClasspathEntrySnapshotExternalizer.INSTANCE), (File)snapshotOutputFile, (Object)snapshot);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$measure$iv2.endMeasure(time$iv2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
        metrics.addMetric(BuildPerformanceMetric.CLASSPATH_ENTRY_SNAPSHOT_TRANSFORM_EXECUTION_COUNT, 1L);
        if (StringsKt.equals((String)FilesKt.getExtension((File)classpathEntryInputDirOrJar), (String)"jar", (boolean)true)) {
            metrics.addMetric(BuildPerformanceMetric.JAR_CLASSPATH_ENTRY_SIZE, classpathEntryInputDirOrJar.length());
            metrics.addMetric(BuildPerformanceMetric.JAR_CLASSPATH_ENTRY_SNAPSHOT_SIZE, snapshotOutputFile.length());
        } else {
            metrics.addMetric(BuildPerformanceMetric.DIRECTORY_CLASSPATH_ENTRY_SNAPSHOT_SIZE, snapshotOutputFile.length());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/ClasspathEntrySnapshotTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "()V", "buildMetricsService", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "getBuildMetricsService", "()Lorg/gradle/api/provider/Property;", "gradleUserHomeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGradleUserHomeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "kotlin-gradle-plugin_common"})
    public static abstract class Parameters
    implements TransformParameters {
        @Internal
        @NotNull
        public abstract DirectoryProperty getGradleUserHomeDir();

        @Internal
        @NotNull
        public abstract Property<BuildMetricsService> getBuildMetricsService();
    }
}

