/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.SourceKind;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Category;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptionsDefault;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.internal.Kapt3GradleSubplugin;
import org.jetbrains.kotlin.gradle.internal.Kapt3KotlinGradleSubpluginKt;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.AbstractKotlinTargetConfigurator;
import org.jetbrains.kotlin.gradle.plugin.AndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.AndroidProjectHandlerKt;
import org.jetbrains.kotlin.gradle.plugin.AndroidTestedVariantArtifactsFilter;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinConfigurationTools;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTargetConfiguratorKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginEnvironment;
import org.jetbrains.kotlin.gradle.plugin.android.AndroidGradleWrapper;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilationFactory;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetInfoKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSets;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;
import org.jetbrains.kotlin.gradle.tasks.configuration.BaseKotlinCompileConfig;
import org.jetbrains.kotlin.gradle.testing.internal.KotlinTestsRegistryKt;
import org.jetbrains.kotlin.gradle.tooling.IncludeKotlinToolingMetadataInApkKt;
import org.jetbrains.kotlin.gradle.utils.AndroidPluginIdsKt;
import org.jetbrains.kotlin.gradle.utils.GradleConfigurationUtilsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJP\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00132\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%2\u000e\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0%H\u0002J\u001c\u0010)\u001a\u00020\t*\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/AndroidProjectHandler;", "", "kotlinConfigurationTools", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinConfigurationTools;", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinConfigurationTools;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "addAndroidUnitTestTasksAsDependenciesToAllTest", "", "project", "Lorg/gradle/api/Project;", "addKotlinDependenciesToAndroidSourceSets", "configureTarget", "kotlinAndroidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "getBuildTypeName", "", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "getFlavorNames", "", "getLibraryOutputTask", "postprocessVariant", "variantData", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJvmAndroidCompilation;", "androidExt", "Lcom/android/build/gradle/BaseExtension;", "androidPlugin", "Lcom/android/build/gradle/BasePlugin;", "preprocessVariant", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "setUpDependencyResolution", "wireKotlinTasks", "javaTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "kotlinTask", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "wireExtensionOptionsToCompilation", "extensionCompilerOptions", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmCompilerOptions;", "compilationCompilerOptions", "kotlin-gradle-plugin_common"})
public final class AndroidProjectHandler {
    @NotNull
    private final KotlinConfigurationTools kotlinConfigurationTools;
    private final Logger logger;

    public AndroidProjectHandler(@NotNull KotlinConfigurationTools kotlinConfigurationTools) {
        Intrinsics.checkNotNullParameter((Object)kotlinConfigurationTools, (String)"kotlinConfigurationTools");
        this.kotlinConfigurationTools = kotlinConfigurationTools;
        this.logger = Logging.getLogger(this.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public final void configureTarget(@NotNull KotlinAndroidTarget kotlinAndroidTarget) {
        void $this$addExtension$iv;
        Intrinsics.checkNotNullParameter((Object)kotlinAndroidTarget, (String)"kotlinAndroidTarget");
        Project project = kotlinAndroidTarget.getProject();
        Object object = project.getExtensions().getByName("android");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
        BaseExtension ext = (BaseExtension)object;
        KotlinAndroidSourceSets.applyKotlinAndroidSourceSetLayout$default(KotlinAndroidSourceSets.INSTANCE, kotlinAndroidTarget, null, 2, null);
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$newInstance$iv = objectFactory;
        boolean $i$f$newInstance22 = false;
        KotlinJvmCompilerOptionsDefault androidExtensionCompilerOptions = (KotlinJvmCompilerOptionsDefault)$this$newInstance$iv.newInstance(KotlinJvmCompilerOptionsDefault.class, new Object[0]);
        androidExtensionCompilerOptions.getNoJdk().value((Object)true).finalizeValueOnRead();
        KotlinJvmOptions kotlinOptions2 = new KotlinJvmOptions(androidExtensionCompilerOptions){
            final /* synthetic */ KotlinJvmCompilerOptionsDefault $androidExtensionCompilerOptions;
            {
                this.$androidExtensionCompilerOptions = $androidExtensionCompilerOptions;
            }

            @NotNull
            public KotlinJvmCompilerOptions getOptions() {
                KotlinJvmCompilerOptionsDefault kotlinJvmCompilerOptionsDefault = this.$androidExtensionCompilerOptions;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinJvmCompilerOptionsDefault, (String)"androidExtensionCompilerOptions");
                return kotlinJvmCompilerOptionsDefault;
            }

            public boolean getAllWarningsAsErrors() {
                return KotlinJvmOptions.DefaultImpls.getAllWarningsAsErrors(this);
            }

            public void setAllWarningsAsErrors(boolean value) {
                KotlinJvmOptions.DefaultImpls.setAllWarningsAsErrors(this, value);
            }

            @Nullable
            public String getApiVersion() {
                return KotlinJvmOptions.DefaultImpls.getApiVersion(this);
            }

            public void setApiVersion(@Nullable String value) {
                KotlinJvmOptions.DefaultImpls.setApiVersion(this, value);
            }

            @NotNull
            public List<String> getFreeCompilerArgs() {
                return KotlinJvmOptions.DefaultImpls.getFreeCompilerArgs(this);
            }

            public void setFreeCompilerArgs(@NotNull List<String> value) {
                KotlinJvmOptions.DefaultImpls.setFreeCompilerArgs(this, value);
            }

            public boolean getJavaParameters() {
                return KotlinJvmOptions.DefaultImpls.getJavaParameters(this);
            }

            public void setJavaParameters(boolean value) {
                KotlinJvmOptions.DefaultImpls.setJavaParameters(this, value);
            }

            @Nullable
            public String getJvmTarget() {
                return KotlinJvmOptions.DefaultImpls.getJvmTarget(this);
            }

            public void setJvmTarget(@Nullable String value) {
                KotlinJvmOptions.DefaultImpls.setJvmTarget(this, value);
            }

            @Nullable
            public String getLanguageVersion() {
                return KotlinJvmOptions.DefaultImpls.getLanguageVersion(this);
            }

            public void setLanguageVersion(@Nullable String value) {
                KotlinJvmOptions.DefaultImpls.setLanguageVersion(this, value);
            }

            @Nullable
            public String getModuleName() {
                return KotlinJvmOptions.DefaultImpls.getModuleName(this);
            }

            public void setModuleName(@Nullable String value) {
                KotlinJvmOptions.DefaultImpls.setModuleName(this, value);
            }

            public boolean getNoJdk() {
                return KotlinJvmOptions.DefaultImpls.getNoJdk(this);
            }

            public void setNoJdk(boolean value) {
                KotlinJvmOptions.DefaultImpls.setNoJdk(this, value);
            }

            public boolean getSuppressWarnings() {
                return KotlinJvmOptions.DefaultImpls.getSuppressWarnings(this);
            }

            public void setSuppressWarnings(boolean value) {
                KotlinJvmOptions.DefaultImpls.setSuppressWarnings(this, value);
            }

            public boolean getUseK2() {
                return KotlinJvmOptions.DefaultImpls.getUseK2(this);
            }

            public void setUseK2(boolean value) {
                KotlinJvmOptions.DefaultImpls.setUseK2(this, value);
            }

            public boolean getVerbose() {
                return KotlinJvmOptions.DefaultImpls.getVerbose(this);
            }

            public void setVerbose(boolean value) {
                KotlinJvmOptions.DefaultImpls.setVerbose(this, value);
            }
        };
        BaseExtension $i$f$newInstance22 = ext;
        String name$iv = KotlinPluginKt.getKOTLIN_OPTIONS_DSL_NAME();
        boolean $i$f$addExtension = false;
        ((ExtensionAware)$this$addExtension$iv).getExtensions().add(configureTarget.kotlinOptions.1.class, name$iv, (Object)kotlinOptions2);
        BasePlugin basePlugin = (BasePlugin)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)AndroidPluginIdsKt.getAndroidPluginIds()), (Function1)((Function1)new Function1<String, BasePlugin>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @Nullable
            public final BasePlugin invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Plugin plugin2 = this.$project.getPlugins().findPlugin(it);
                return plugin2 instanceof BasePlugin ? (BasePlugin)plugin2 : null;
            }
        })));
        if (basePlugin == null) {
            throw new InvalidPluginException("'kotlin-android' expects one of the Android Gradle plugins to be applied to the project:\n\t" + CollectionsKt.joinToString$default((Iterable)AndroidPluginIdsKt.getAndroidPluginIds(), (CharSequence)"\n\t", null, null, (int)0, null, (Function1)configureTarget.plugin.2.INSTANCE, (int)30, null));
        }
        BasePlugin plugin2 = basePlugin;
        KotlinPluginKt.forEachVariant(project, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(kotlinAndroidTarget, this, project, androidExtensionCompilerOptions){
            final /* synthetic */ KotlinAndroidTarget $kotlinAndroidTarget;
            final /* synthetic */ AndroidProjectHandler this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinJvmCompilerOptionsDefault $androidExtensionCompilerOptions;
            {
                this.$kotlinAndroidTarget = $kotlinAndroidTarget;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$androidExtensionCompilerOptions = $androidExtensionCompilerOptions;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                KotlinJvmAndroidCompilationFactory compilationFactory = new KotlinJvmAndroidCompilationFactory(this.$kotlinAndroidTarget, variant);
                String variantName = AndroidProjectHandlerKt.getVariantName(variant);
                KotlinJvmAndroidCompilation kotlinJvmAndroidCompilation = compilationFactory.create(variantName);
                AndroidProjectHandler androidProjectHandler = this.this$0;
                Project project = this.$project;
                KotlinJvmCompilerOptionsDefault kotlinJvmCompilerOptionsDefault = this.$androidExtensionCompilerOptions;
                KotlinAndroidTarget kotlinAndroidTarget = this.$kotlinAndroidTarget;
                KotlinJvmAndroidCompilation compilation2 = kotlinJvmAndroidCompilation;
                boolean bl = false;
                androidProjectHandler.setUpDependencyResolution(variant, compilation2);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinJvmCompilerOptionsDefault, (String)"androidExtensionCompilerOptions");
                KotlinJvmCompilerOptions kotlinJvmCompilerOptions = kotlinJvmCompilerOptionsDefault;
                ? obj2 = compilation2.getCompilerOptions().getOptions();
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions");
                AndroidProjectHandler.access$wireExtensionOptionsToCompilation(androidProjectHandler, project, kotlinJvmCompilerOptions, (KotlinJvmCompilerOptions)obj2);
                AndroidProjectHandler.access$preprocessVariant(androidProjectHandler, variant, compilation2, project, AndroidProjectHandler.access$getKotlinConfigurationTools$p(androidProjectHandler).getKotlinTasksProvider());
                NamedDomainObjectContainer<? extends KotlinJvmAndroidCompilation> namedDomainObjectContainer = kotlinAndroidTarget.getCompilations();
                Intrinsics.checkNotNull(namedDomainObjectContainer, (String)"null cannot be cast to non-null type org.gradle.api.NamedDomainObjectCollection<in org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation>");
                ((NamedDomainObjectCollection)namedDomainObjectContainer).add((Object)compilation2);
            }
        }));
        KotlinMultiplatformPluginKt.whenEvaluated(project, (Function1)new Function1<Project, Unit>(project, this, kotlinAndroidTarget, ext, plugin2){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidProjectHandler this$0;
            final /* synthetic */ KotlinAndroidTarget $kotlinAndroidTarget;
            final /* synthetic */ BaseExtension $ext;
            final /* synthetic */ BasePlugin $plugin;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$kotlinAndroidTarget = $kotlinAndroidTarget;
                this.$ext = $ext;
                this.$plugin = $plugin;
                super(1);
            }

            public final void invoke(@NotNull Project $this$whenEvaluated) {
                Intrinsics.checkNotNullParameter((Object)$this$whenEvaluated, (String)"$this$whenEvaluated");
                KotlinPluginKt.forEachVariant($this$whenEvaluated, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this.$kotlinAndroidTarget, this.this$0, this.$project, this.$ext, this.$plugin){
                    final /* synthetic */ KotlinAndroidTarget $kotlinAndroidTarget;
                    final /* synthetic */ AndroidProjectHandler this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ BaseExtension $ext;
                    final /* synthetic */ BasePlugin $plugin;
                    {
                        this.$kotlinAndroidTarget = $kotlinAndroidTarget;
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$ext = $ext;
                        this.$plugin = $plugin;
                        super(1);
                    }

                    public final void invoke(@NotNull BaseVariant variant) {
                        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                        KotlinJvmAndroidCompilation compilation2 = (KotlinJvmAndroidCompilation)this.$kotlinAndroidTarget.getCompilations().getByName(AndroidProjectHandlerKt.getVariantName(variant));
                        Intrinsics.checkNotNullExpressionValue((Object)compilation2, (String)"compilation");
                        AndroidProjectHandler.access$postprocessVariant(this.this$0, variant, compilation2, this.$project, this.$ext, this.$plugin);
                        SubpluginEnvironment subpluginEnvironment = SubpluginEnvironment.Companion.loadSubplugins(this.$project);
                        subpluginEnvironment.addSubpluginOptions(this.$project, compilation2);
                    }
                }));
                Kapt3KotlinGradleSubpluginKt.checkAndroidAnnotationProcessorDependencyUsage(this.$project);
                AndroidProjectHandler.access$addKotlinDependenciesToAndroidSourceSets(this.this$0, this.$project);
            }
        });
        IncludeKotlinToolingMetadataInApkKt.includeKotlinToolingMetadataInApk(project);
        this.addAndroidUnitTestTasksAsDependenciesToAllTest(project);
    }

    private final void wireExtensionOptionsToCompilation(Project $this$wireExtensionOptionsToCompilation, KotlinJvmCompilerOptions extensionCompilerOptions, KotlinJvmCompilerOptions compilationCompilerOptions) {
        compilationCompilerOptions.getAllWarningsAsErrors().convention((Provider)extensionCompilerOptions.getAllWarningsAsErrors());
        compilationCompilerOptions.getSuppressWarnings().convention((Provider)extensionCompilerOptions.getSuppressWarnings());
        compilationCompilerOptions.getVerbose().convention((Provider)extensionCompilerOptions.getVerbose());
        compilationCompilerOptions.getFreeCompilerArgs().addAll((Provider)extensionCompilerOptions.getFreeCompilerArgs());
        compilationCompilerOptions.getApiVersion().convention((Provider)extensionCompilerOptions.getApiVersion());
        compilationCompilerOptions.getLanguageVersion().convention((Provider)extensionCompilerOptions.getLanguageVersion());
        compilationCompilerOptions.getUseK2().convention((Provider)extensionCompilerOptions.getUseK2());
        compilationCompilerOptions.getJavaParameters().convention((Provider)extensionCompilerOptions.getJavaParameters());
        compilationCompilerOptions.getNoJdk().value((Provider)extensionCompilerOptions.getNoJdk()).finalizeValue();
        Function1 function1 = (Function1)new Function1<Project, Unit>(extensionCompilerOptions, compilationCompilerOptions){
            final /* synthetic */ KotlinJvmCompilerOptions $extensionCompilerOptions;
            final /* synthetic */ KotlinJvmCompilerOptions $compilationCompilerOptions;
            {
                this.$extensionCompilerOptions = $extensionCompilerOptions;
                this.$compilationCompilerOptions = $compilationCompilerOptions;
                super(1);
            }

            public final void invoke(Project it) {
                if (this.$extensionCompilerOptions.getJvmTarget().isPresent()) {
                    this.$compilationCompilerOptions.getJvmTarget().set((Provider)this.$extensionCompilerOptions.getJvmTarget());
                }
                if (this.$extensionCompilerOptions.getModuleName().isPresent()) {
                    this.$compilationCompilerOptions.getModuleName().set((Provider)this.$extensionCompilerOptions.getModuleName());
                }
            }
        };
        $this$wireExtensionOptionsToCompilation.afterEvaluate(new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    private final void addKotlinDependenciesToAndroidSourceSets(Project project) {
        Object object = project.getExtensions().getByName("android");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
        NamedDomainObjectContainer namedDomainObjectContainer = ((BaseExtension)object).getSourceSets();
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"project.extensions.getBy\u2026BaseExtension).sourceSets");
        Iterable $this$forEach$iv = (Iterable)namedDomainObjectContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinSourceSet kotlinSourceSet;
            AndroidSourceSet androidSourceSet = (AndroidSourceSet)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)androidSourceSet, (String)"androidSourceSet");
            if (KotlinAndroidSourceSetInfoKt.findKotlinSourceSet(project, androidSourceSet) == null) continue;
            boolean bl2 = false;
            AndroidProjectHandler.addKotlinDependenciesToAndroidSourceSets$addDependenciesToAndroidSourceSet(project, androidSourceSet, kotlinSourceSet.getApiConfigurationName(), kotlinSourceSet.getImplementationConfigurationName(), kotlinSourceSet.getCompileOnlyConfigurationName(), kotlinSourceSet.getRuntimeOnlyConfigurationName());
        }
    }

    private final void addAndroidUnitTestTasksAsDependenciesToAllTest(Project project) {
        String allTestTaskName = KotlinTestsRegistryKt.getKotlinTestRegistry(project).getAllTestsTaskName();
        Function1 function1 = (Function1)new Function1<Task, Boolean>(allTestTaskName){
            final /* synthetic */ String $allTestTaskName;
            {
                this.$allTestTaskName = $allTestTaskName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Task it) {
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$allTestTaskName);
            }
        };
        Spec spec = new Spec(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        };
        function1 = (Function1)new Function1<Task, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Task task2) {
                Object[] objectArray = new Object[]{this.$project.provider(new Callable(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    public final List<Object> call() {
                        List androidUnitTestTasks = new ArrayList<E>();
                        AndroidProjectHandlerKt.forEachVariant(this.$project, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>((List<Object>)androidUnitTestTasks, this.$project){
                            final /* synthetic */ List<Object> $androidUnitTestTasks;
                            final /* synthetic */ Project $project;
                            {
                                this.$androidUnitTestTasks = $androidUnitTestTasks;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull BaseVariant variant) {
                                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                                if (variant instanceof UnitTestVariant) {
                                    Provider provider = this.$project.provider(new Callable(this.$project, variant){
                                        final /* synthetic */ Project $project;
                                        final /* synthetic */ BaseVariant $variant;
                                        {
                                            this.$project = $project;
                                            this.$variant = $variant;
                                        }

                                        public final TaskCollection<Task> call() {
                                            Function1 function1 = (Function1)new Function1<Task, Boolean>(this.$variant){
                                                final /* synthetic */ BaseVariant $variant;
                                                {
                                                    this.$variant = $variant;
                                                    super(1);
                                                }

                                                @NotNull
                                                public final Boolean invoke(Task it) {
                                                    String[] stringArray = new String[]{"test", ((UnitTestVariant)this.$variant).getName()};
                                                    return Intrinsics.areEqual((Object)it.getName(), (Object)StringUtilsKt.lowerCamelCaseName(stringArray));
                                                }
                                            };
                                            return this.$project.getTasks().matching(new /* invalid duplicate definition of identical inner class */);
                                        }
                                    });
                                    Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project: Project) {\n    \u2026                        }");
                                    this.$androidUnitTestTasks.add(provider);
                                }
                            }
                        }));
                        return androidUnitTestTasks;
                    }
                })};
                task2.dependsOn(objectArray);
            }
        };
        project.getTasks().matching(spec).configureEach(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    private final void preprocessVariant(BaseVariant variantData, KotlinJvmAndroidCompilation compilation2, Project project, KotlinTasksProvider tasksProvider) {
        void $this$forEach$iv$iv;
        String variantDataName = AndroidProjectHandlerKt.getVariantName(variantData);
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Process variant [" + variantDataName + ']');
        KotlinSourceSet defaultSourceSet2 = (KotlinSourceSet)KotlinProjectExtensionKt.getKotlinExtension(project).getSourceSets().maybeCreate(compilation2.getDefaultSourceSetName());
        BaseKotlinCompileConfig<KotlinCompile> configAction2 = new BaseKotlinCompileConfig<KotlinCompile>(compilation2);
        configAction2.configureTask((Function1)new Function1<KotlinCompile, Unit>(project, variantDataName){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $variantDataName;
            {
                this.$project = $project;
                this.$variantDataName = $variantDataName;
                super(1);
            }

            public final void invoke(@NotNull KotlinCompile task2) {
                Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                task2.getUseModuleDetection().value((Object)true).disallowChanges();
                task2.getDestinationDirectory().set(this.$project.getLayout().getBuildDirectory().dir("tmp/kotlin-classes/" + this.$variantDataName));
                task2.setDescription("Compiles the " + this.$variantDataName + " kotlin.");
            }
        });
        String string = compilation2.getCompileKotlinTaskName();
        Object obj2 = compilation2.getCompilerOptions().getOptions();
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions");
        tasksProvider.registerKotlinJVMTask(project, string, (KotlinJvmCompilerOptions)obj2, configAction2);
        Intrinsics.checkNotNullExpressionValue((Object)defaultSourceSet2, (String)"defaultSourceSet");
        compilation2.source(defaultSourceSet2);
        BaseVariant $this$forEachKotlinSourceSet$iv = compilation2.getAndroidVariant();
        boolean $i$f$forEachKotlinSourceSet = false;
        List list2 = $this$forEachKotlinSourceSet$iv.getSourceSets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sourceSets");
        Iterable iterable = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            KotlinSourceSet kotlinSourceSet;
            SourceProvider provider$iv = (SourceProvider)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)provider$iv, (String)"provider");
            if (KotlinAndroidSourceSetInfoKt.findKotlinSourceSet(project, provider$iv) == null) continue;
            boolean bl2 = false;
            compilation2.source(kotlinSourceSet);
        }
    }

    private final void postprocessVariant(BaseVariant variantData, KotlinJvmAndroidCompilation compilation2, Project project, BaseExtension androidExt, BasePlugin androidPlugin) {
        BaseVariant baseVariant = AndroidProjectHandlerKt.getTestedVariantData(variantData);
        if (baseVariant != null) {
            BaseVariant testedVariant = baseVariant;
            boolean bl = false;
            String testedVariantName = AndroidProjectHandlerKt.getVariantName(testedVariant);
            KotlinCompilation testedCompilation = (KotlinCompilation)compilation2.getTarget().getCompilations().getByName(testedVariantName);
            Intrinsics.checkNotNullExpressionValue((Object)testedCompilation, (String)"testedCompilation");
            compilation2.associateWith(testedCompilation);
        }
        TaskProvider<? extends JavaCompile> javaTask = AndroidProjectHandlerKt.getJavaTaskProvider(variantData);
        TaskProvider<? extends KotlinCompile> kotlinTask = compilation2.getCompileKotlinTaskProvider();
        BaseVariant $this$forEachJavaSourceDir$iv = compilation2.getAndroidVariant();
        boolean $i$f$forEachJavaSourceDir = false;
        List list2 = $this$forEachJavaSourceDir$iv.getSourceFolders(SourceKind.JAVA);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSourceFolders(SourceKind.JAVA)");
        Iterable $this$forEach$iv$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ConfigurableFileTree sources2 = (ConfigurableFileTree)element$iv$iv;
            boolean bl = false;
            Function1 function1 = (Function1)new Function1<KotlinCompile, Unit>(sources2){
                final /* synthetic */ ConfigurableFileTree $sources;
                {
                    this.$sources = $sources;
                    super(1);
                }

                public final void invoke(KotlinCompile it) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)this.$sources.getDir(), (String)"sources.dir");
                    it.setSource(objectArray);
                    objectArray = new Object[]{this.$sources};
                    it.dependsOn(objectArray);
                }
            };
            kotlinTask.configure(new /* invalid duplicate definition of identical inner class */);
        }
        this.wireKotlinTasks(project, compilation2, androidPlugin, androidExt, variantData, javaTask, kotlinTask);
    }

    private final void wireKotlinTasks(Project project, KotlinJvmAndroidCompilation compilation2, BasePlugin androidPlugin, BaseExtension androidExt, BaseVariant variantData, TaskProvider<? extends AbstractCompile> javaTask, TaskProvider<? extends KotlinCompile> kotlinTask) {
        Object[] objectArray = new Object[]{project.provider(new Callable(kotlinTask, project, variantData){
            final /* synthetic */ TaskProvider<? extends KotlinCompile> $kotlinTask;
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variantData;
            {
                this.$kotlinTask = $kotlinTask;
                this.$project = $project;
                this.$variantData = $variantData;
            }

            public final List<File> call() {
                List list2 = new ArrayList<E>();
                TaskProvider<? extends KotlinCompile> taskProvider = this.$kotlinTask;
                Project project = this.$project;
                BaseVariant baseVariant = this.$variantData;
                List $this$call_u24lambda_u240 = list2;
                boolean bl = false;
                File file = ((Directory)((KotlinCompile)taskProvider.get()).getDestinationDirectory().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"kotlinTask.get().destinationDirectory.get().asFile");
                $this$call_u24lambda_u240.add(file);
                if (Kapt3GradleSubplugin.Companion.isEnabled(project)) {
                    File kaptClasssesDir = Kapt3GradleSubplugin.Companion.getKaptGeneratedClassesDir(project, AndroidProjectHandlerKt.getVariantName(baseVariant));
                    $this$call_u24lambda_u240.add(kaptClasssesDir);
                }
                return list2;
            }
        })};
        ConfigurableFileCollection configurableFileCollection = project.files(objectArray);
        objectArray = new Object[]{kotlinTask};
        ConfigurableFileCollection preJavaKotlinOutput2 = configurableFileCollection.builtBy(objectArray);
        Object preJavaClasspathKey = variantData.registerPreJavacGeneratedBytecode((FileCollection)preJavaKotlinOutput2);
        Function1 function1 = (Function1)new Function1<KotlinCompile, Unit>(variantData, preJavaClasspathKey, javaTask, androidPlugin, androidExt){
            final /* synthetic */ BaseVariant $variantData;
            final /* synthetic */ Object $preJavaClasspathKey;
            final /* synthetic */ TaskProvider<? extends AbstractCompile> $javaTask;
            final /* synthetic */ BasePlugin $androidPlugin;
            final /* synthetic */ BaseExtension $androidExt;
            {
                this.$variantData = $variantData;
                this.$preJavaClasspathKey = $preJavaClasspathKey;
                this.$javaTask = $javaTask;
                this.$androidPlugin = $androidPlugin;
                this.$androidExt = $androidExt;
                super(1);
            }

            public final void invoke(KotlinCompile kotlinTaskInstance) {
                Object[] objectArray = new Object[]{this.$variantData.getCompileClasspath(this.$preJavaClasspathKey)};
                ConfigurableFileCollection configurableFileCollection = kotlinTaskInstance.getLibraries().from(objectArray);
                objectArray = new Object[]{new Callable(this.$androidPlugin, this.$androidExt){
                    final /* synthetic */ BasePlugin $androidPlugin;
                    final /* synthetic */ BaseExtension $androidExt;
                    {
                        this.$androidPlugin = $androidPlugin;
                        this.$androidExt = $androidExt;
                    }

                    @Nullable
                    public final Object call() {
                        return AndroidGradleWrapper.INSTANCE.getRuntimeJars(this.$androidPlugin, this.$androidExt);
                    }
                }};
                configurableFileCollection.from(objectArray);
                objectArray = (Object[])wireKotlinTasks.2.INSTANCE;
                kotlinTaskInstance.getJavaOutputDir$kotlin_gradle_plugin_common().set(this.$javaTask.flatMap(new Transformer((Function1)objectArray){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object transform(Object p0) {
                        return this.function.invoke(p0);
                    }
                }));
            }
        };
        kotlinTask.configure(new /* invalid duplicate definition of identical inner class */);
        ArtifactCollection originalArtifactCollection = variantData.getCompileClasspathArtifacts(preJavaClasspathKey);
        boolean testedVariantDataIsNotNull = AndroidProjectHandlerKt.getTestedVariantData(variantData) != null;
        String projectPath2 = project.getPath();
        Property<FileCollection> property2 = compilation2.getTestedVariantArtifacts$kotlin_gradle_plugin_common();
        FileCollection fileCollection = originalArtifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)originalArtifactCollection, (String)"originalArtifactCollection");
        Intrinsics.checkNotNullExpressionValue((Object)projectPath2, (String)"projectPath");
        property2.set((Object)fileCollection.filter((Spec)new AndroidTestedVariantArtifactsFilter(originalArtifactCollection, testedVariantDataIsNotNull, projectPath2)));
        Object[] objectArray2 = new Object[2];
        Function1 function12 = wireKotlinTasks.2.INSTANCE;
        objectArray2[0] = kotlinTask.flatMap(new /* invalid duplicate definition of identical inner class */);
        function12 = wireKotlinTasks.3.INSTANCE;
        objectArray2[1] = javaTask.flatMap(new /* invalid duplicate definition of identical inner class */);
        compilation2.getOutput().getClassesDirs().from(objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFlavorNames(@NotNull BaseVariant variant) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        List list2 = variant.getProductFlavors();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"variant.productFlavors");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProductFlavor productFlavor = (ProductFlavor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getBuildTypeName(@NotNull BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        String string = variant.getBuildType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.buildType.name");
        return string;
    }

    @Nullable
    public final Object getLibraryOutputTask(@NotNull BaseVariant variant) {
        Object object;
        Object object2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Method[] methodArray = variant.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"variant.javaClass.methods");
            for (Object object3 : (Object[])methodArray) {
                Method it = (Method)object3;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getPackageLibraryProvider") && it.getParameterCount() == 0)) continue;
                object2 = object3;
                break block3;
            }
            object2 = null;
        }
        Method getPackageLibraryProvider = (Method)object2;
        if (getPackageLibraryProvider != null) {
            Object object4 = getPackageLibraryProvider.invoke((Object)variant, new Object[0]);
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<out org.gradle.api.tasks.bundling.AbstractArchiveTask>");
            object = (TaskProvider)object4;
        } else {
            LibraryVariant libraryVariant = variant instanceof LibraryVariant ? (LibraryVariant)variant : null;
            object = libraryVariant != null ? libraryVariant.getPackageLibrary() : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUpDependencyResolution(@NotNull BaseVariant variant, @NotNull KotlinJvmAndroidCompilation compilation2) {
        void $this$setUpDependencyResolution_u24lambda_u248;
        Object[] $this$setUpDependencyResolution_u24lambda_u247;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)compilation2, (String)"compilation");
        Project project = compilation2.getTarget().getProject();
        AbstractKotlinTargetConfigurator.Companion.defineConfigurationsForCompilation(compilation2);
        Object[] objectArray2 = objectArray = variant.getCompileConfiguration();
        KotlinJvmAndroidCompilation kotlinJvmAndroidCompilation = compilation2;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$setUpDependencyResolution_u24lambda_u247, (String)"setUpDependencyResolution$lambda$7");
        KotlinTargetConfiguratorKt.usesPlatformOf((Configuration)$this$setUpDependencyResolution_u24lambda_u247, compilation2.getTarget());
        String string = $this$setUpDependencyResolution_u24lambda_u247.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        GradleConfigurationUtilsKt.addExtendsFromRelation$default(project, string, compilation2.getCompileDependencyConfigurationName(), false, 4, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"variant.compileConfigura\u2026figurationName)\n        }");
        kotlinJvmAndroidCompilation.setCompileDependencyFiles((FileCollection)objectArray);
        $this$setUpDependencyResolution_u24lambda_u247 = objectArray = variant.getRuntimeConfiguration();
        kotlinJvmAndroidCompilation = compilation2;
        boolean $i$a$-apply-AndroidProjectHandler$setUpDependencyResolution$32 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$setUpDependencyResolution_u24lambda_u248, (String)"setUpDependencyResolution$lambda$8");
        KotlinTargetConfiguratorKt.usesPlatformOf((Configuration)$this$setUpDependencyResolution_u24lambda_u248, compilation2.getTarget());
        String string2 = $this$setUpDependencyResolution_u24lambda_u248.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        GradleConfigurationUtilsKt.addExtendsFromRelation$default(project, string2, compilation2.getRuntimeDependencyConfigurationName(), false, 4, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"variant.runtimeConfigura\u2026figurationName)\n        }");
        kotlinJvmAndroidCompilation.setRuntimeDependencyFiles((FileCollection)objectArray);
        BuildTypeAttr buildTypeAttrValue = (BuildTypeAttr)project.getObjects().named(BuildTypeAttr.class, variant.getBuildType().getName());
        objectArray = new String[]{compilation2.getCompileDependencyConfigurationName(), compilation2.getRuntimeDependencyConfigurationName()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            Configuration configuration2 = (Configuration)project.getConfigurations().findByName(it);
            if (configuration2 == null || (configuration2 = configuration2.getAttributes()) == null) continue;
            configuration2.attribute(Attribute.of(BuildTypeAttr.class), (Object)buildTypeAttrValue);
        }
        String apiElementsConfigurationName = variant.getName() + "ApiElements";
        String runtimeElementsConfigurationName = variant.getName() + "RuntimeElements";
        if (project.getConfigurations().findByName(apiElementsConfigurationName) != null) {
            GradleConfigurationUtilsKt.addExtendsFromRelation$default(project, apiElementsConfigurationName, compilation2.getApiConfigurationName(), false, 4, null);
        }
        if (project.getConfigurations().findByName(runtimeElementsConfigurationName) != null) {
            GradleConfigurationUtilsKt.addExtendsFromRelation$default(project, runtimeElementsConfigurationName, compilation2.getImplementationConfigurationName(), false, 4, null);
            GradleConfigurationUtilsKt.addExtendsFromRelation$default(project, runtimeElementsConfigurationName, compilation2.getRuntimeOnlyConfigurationName(), false, 4, null);
        }
        Object[] $i$a$-apply-AndroidProjectHandler$setUpDependencyResolution$32 = new String[]{apiElementsConfigurationName, runtimeElementsConfigurationName};
        Iterable $this$forEach$iv2 = CollectionsKt.listOf((Object[])$i$a$-apply-AndroidProjectHandler$setUpDependencyResolution$32);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Configuration configuration3;
            String outputConfigurationName = (String)element$iv;
            boolean bl3 = false;
            if ((Configuration)project.getConfigurations().findByName(outputConfigurationName) == null) continue;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)configuration3, (String)"configuration");
            KotlinTargetConfiguratorKt.usesPlatformOf(configuration3, compilation2.getTarget());
            configuration3.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)KotlinTargetConfiguratorKt.categoryByName(project, "library"));
        }
    }

    private static final void addKotlinDependenciesToAndroidSourceSets$addDependenciesToAndroidSourceSet(Project $project, AndroidSourceSet androidSourceSet, String apiConfigurationName, String implementationConfigurationName, String compileOnlyConfigurationName, String runtimeOnlyConfigurationName) {
        if ($project.getConfigurations().findByName(androidSourceSet.getApiConfigurationName()) != null) {
            String string = androidSourceSet.getApiConfigurationName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"androidSourceSet.apiConfigurationName");
            GradleConfigurationUtilsKt.addExtendsFromRelation$default($project, string, apiConfigurationName, false, 4, null);
        } else {
            Function1 function1 = (Function1)new Function1<Dependency, Unit>(androidSourceSet){
                final /* synthetic */ AndroidSourceSet $androidSourceSet;
                {
                    this.$androidSourceSet = $androidSourceSet;
                    super(1);
                }

                public final void invoke(Dependency it) {
                    throw new InvalidUserCodeException("API dependencies are not allowed for Android source set " + this.$androidSourceSet.getName() + ". Please use an implementation dependency instead.");
                }
            };
            $project.getConfigurations().getByName(apiConfigurationName).getDependencies().all(new /* invalid duplicate definition of identical inner class */);
        }
        String string = androidSourceSet.getImplementationConfigurationName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"androidSourceSet.implementationConfigurationName");
        GradleConfigurationUtilsKt.addExtendsFromRelation$default($project, string, implementationConfigurationName, false, 4, null);
        String string2 = androidSourceSet.getCompileOnlyConfigurationName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"androidSourceSet.compileOnlyConfigurationName");
        GradleConfigurationUtilsKt.addExtendsFromRelation$default($project, string2, compileOnlyConfigurationName, false, 4, null);
        String string3 = androidSourceSet.getRuntimeOnlyConfigurationName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"androidSourceSet.runtimeOnlyConfigurationName");
        GradleConfigurationUtilsKt.addExtendsFromRelation$default($project, string3, runtimeOnlyConfigurationName, false, 4, null);
    }

    public static final /* synthetic */ void access$wireExtensionOptionsToCompilation(AndroidProjectHandler $this, Project $receiver, KotlinJvmCompilerOptions extensionCompilerOptions, KotlinJvmCompilerOptions compilationCompilerOptions) {
        $this.wireExtensionOptionsToCompilation($receiver, extensionCompilerOptions, compilationCompilerOptions);
    }

    public static final /* synthetic */ void access$preprocessVariant(AndroidProjectHandler $this, BaseVariant variantData, KotlinJvmAndroidCompilation compilation2, Project project, KotlinTasksProvider tasksProvider) {
        $this.preprocessVariant(variantData, compilation2, project, tasksProvider);
    }

    public static final /* synthetic */ KotlinConfigurationTools access$getKotlinConfigurationTools$p(AndroidProjectHandler $this) {
        return $this.kotlinConfigurationTools;
    }

    public static final /* synthetic */ void access$postprocessVariant(AndroidProjectHandler $this, BaseVariant variantData, KotlinJvmAndroidCompilation compilation2, Project project, BaseExtension androidExt, BasePlugin androidPlugin) {
        $this.postprocessVariant(variantData, compilation2, project, androidExt, androidPlugin);
    }

    public static final /* synthetic */ void access$addKotlinDependenciesToAndroidSourceSets(AndroidProjectHandler $this, Project project) {
        $this.addKotlinDependenciesToAndroidSourceSets(project);
    }
}

