/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.io;

import java.io.IOException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.Header;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HeaderIterator;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpMessage;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.io.HttpMessageWriter;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.io.SessionOutputBuffer;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.message.BasicLineFormatter;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.message.LineFormatter;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.params.HttpParams;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message2) throws IOException, HttpException {
        Args.notNull(message2, "HTTP message");
        this.writeHeadLine(message2);
        HeaderIterator it = message2.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

