/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download;

import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.util.GradleVersion;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.DownloadSpec;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.CachingHttpClientFactory;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.HttpClientFactory;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.ProgressLoggerWrapper;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.ProjectApiHelper;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.ProviderHelper;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.Header;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpEntity;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpHost;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.auth.AuthScheme;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.auth.AuthScope;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.auth.Credentials;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.auth.UsernamePasswordCredentials;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.AuthCache;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.ClientProtocolException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.CredentialsProvider;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.config.RequestConfig;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.methods.HttpGet;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.protocol.HttpClientContext;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.utils.DateUtils;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.auth.BasicScheme;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.auth.DigestScheme;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.auth.RFC2617Scheme;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.client.BasicAuthCache;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.client.BasicCredentialsProvider;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;

public class DownloadAction
implements DownloadSpec {
    private static final GradleVersion HARD_MIN_GRADLE_VERSION = GradleVersion.version((String)"2.0");
    private static final GradleVersion SOFT_MIN_GRADLE_VERSION = GradleVersion.version((String)"5.0");
    private final ProjectApiHelper projectApi;
    private final Logger logger;
    private final Object servicesOwner;
    private final boolean isOffline;
    private final List<Object> sourceObjects = new ArrayList<Object>(1);
    private List<URL> cachedSources;
    private Object destObject;
    private File cachedDest;
    private boolean quiet = false;
    private boolean overwrite = true;
    private boolean onlyIfModified = false;
    private boolean compress = true;
    private String username;
    private String password;
    private String authScheme;
    private Map<String, String> headers;
    private boolean acceptAnyCertificate = false;
    private int connectTimeoutMs = 30000;
    private int readTimeoutMs = 30000;
    private int retries = 0;
    private File downloadTaskDir;
    private boolean tempAndMove = false;
    private UseETag useETag = UseETag.FALSE;
    private File cachedETagsFile;
    private ProgressLoggerWrapper progressLogger;
    private String size;
    private long processedBytes = 0L;
    private long loggedKb = 0L;
    private int upToDate = 0;

    public DownloadAction(Project project) {
        this(project, null);
    }

    public DownloadAction(Project project, @Nullable Task task2) {
        this.projectApi = ProjectApiHelper.newInstance(project);
        this.logger = project.getLogger();
        this.servicesOwner = task2 != null ? task2 : project;
        this.isOffline = project.getGradle().getStartParameter().isOffline();
        this.downloadTaskDir = new File(project.getBuildDir(), "download-task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        if (GradleVersion.current().compareTo(HARD_MIN_GRADLE_VERSION) < 0 && !this.quiet) {
            throw new IllegalStateException("gradle-download-task requires Gradle 2.x or higher");
        }
        if (GradleVersion.current().compareTo(SOFT_MIN_GRADLE_VERSION) < 0 && !this.quiet) {
            this.logger.warn("Support for running gradle-download-task with Gradle 2.x, 3.x, and 4.x has been deprecated and will be removed in gradle-download-task 5.0.0");
        }
        if (JavaVersion.current().compareTo((Enum)JavaVersion.VERSION_1_7) < 0 && !this.quiet) {
            throw new IllegalStateException("gradle-download-task requires Java 7 or higher");
        }
        if (JavaVersion.current().compareTo((Enum)JavaVersion.VERSION_1_8) < 0 && !this.quiet) {
            this.logger.warn("Support for running gradle-download-task using Java 7 has been deprecated and will be removed in gradle-download-task 5.0.0");
        }
        if (this.sourceObjects.isEmpty()) {
            throw new IllegalArgumentException("Please provide a download source");
        }
        if (this.destObject == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        List<URL> sources2 = this.getSources();
        File dest = this.getDest();
        if (dest.equals(this.projectApi.getBuildDirectory())) {
            dest.mkdirs();
        }
        if (sources2.size() > 1 && !dest.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            } else {
                throw new IllegalArgumentException("If multiple sources are provided the destination has to be a directory.");
            }
        }
        try (CachingHttpClientFactory clientFactory = new CachingHttpClientFactory();){
            for (URL src : sources2) {
                this.execute(src, clientFactory);
            }
        }
    }

    private void execute(URL src, HttpClientFactory clientFactory) throws IOException {
        long timestamp;
        File destFile = this.makeDestFile(src);
        if (!this.overwrite && destFile.exists()) {
            if (!this.quiet) {
                this.logger.info("Destination file already exists. Skipping '" + destFile.getName() + "'");
            }
            ++this.upToDate;
            return;
        }
        if (this.isOffline) {
            if (destFile.exists()) {
                if (!this.quiet) {
                    this.logger.info("Skipping existing file '" + destFile.getName() + "' in offline mode.");
                }
                return;
            }
            throw new IllegalStateException("Unable to download file '" + src + "' in offline mode.");
        }
        long l = timestamp = this.onlyIfModified && destFile.exists() ? destFile.lastModified() : 0L;
        if (!this.quiet) {
            try {
                this.progressLogger = new ProgressLoggerWrapper(this.logger, this.servicesOwner, src.toString());
            }
            catch (Exception e) {
                this.logger.error("Unable to get progress logger. Download progress will not be displayed.");
            }
        }
        if ("file".equals(src.getProtocol())) {
            this.executeFileProtocol(src, timestamp, destFile);
        } else {
            this.executeHttpProtocol(src, clientFactory, timestamp, destFile);
        }
    }

    private void executeFileProtocol(URL src, long timestamp, File destFile) throws IOException {
        File srcFile = null;
        try {
            srcFile = new File(src.toURI());
            this.size = this.toLengthText(srcFile.length());
        }
        catch (URISyntaxException e) {
            this.logger.warn("Unable to determine file length.");
        }
        long lastModified = 0L;
        if (srcFile != null && (lastModified = srcFile.lastModified()) != 0L && timestamp >= lastModified) {
            if (!this.quiet) {
                this.logger.info("Not modified. Skipping '" + src + "'");
            }
            ++this.upToDate;
            return;
        }
        BufferedInputStream fileStream = new BufferedInputStream(src.openStream());
        this.streamAndMove(fileStream, destFile);
        if (this.onlyIfModified && lastModified > 0L) {
            destFile.setLastModified(lastModified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHttpProtocol(URL src, HttpClientFactory clientFactory, long timestamp, File destFile) throws IOException {
        HttpHost httpHost = new HttpHost(src.getHost(), src.getPort(), src.getProtocol());
        CloseableHttpClient client = clientFactory.createHttpClient(httpHost, this.acceptAnyCertificate, this.retries);
        String etag = null;
        if (this.onlyIfModified && this.useETag.enabled && destFile.exists()) {
            etag = this.getCachedETag(httpHost, src.getFile());
            if (!this.useETag.useWeakETags && this.isWeakETag(etag)) {
                etag = null;
            }
        }
        try (CloseableHttpResponse response = this.openConnection(httpHost, src.getFile(), timestamp, etag, client);){
            long lastModified = this.parseLastModified(response);
            int code = response.getStatusLine().getStatusCode();
            if (code == 304 || lastModified != 0L && timestamp >= lastModified) {
                if (!this.quiet) {
                    this.logger.info("Not modified. Skipping '" + src + "'");
                }
                ++this.upToDate;
                return;
            }
            this.performDownload(response, destFile);
        }
        long newTimestamp = this.parseLastModified(response);
        if (this.onlyIfModified && newTimestamp > 0L) {
            destFile.setLastModified(newTimestamp);
        }
        if (this.onlyIfModified && this.useETag.enabled) {
            this.storeETag(httpHost, src.getFile(), response);
        }
    }

    private void performDownload(HttpResponse response, File destFile) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        long contentLength = entity.getContentLength();
        if (contentLength >= 0L) {
            this.size = this.toLengthText(contentLength);
        }
        this.processedBytes = 0L;
        this.loggedKb = 0L;
        InputStream is = entity.getContent();
        this.streamAndMove(is, destFile);
    }

    private void moveFile(File src, File dest) throws IOException {
        if (src.renameTo(dest)) {
            return;
        }
        try (FileInputStream is = new FileInputStream(src);){
            this.stream(is, dest);
        }
        if (!src.delete()) {
            throw new IOException("Could not delete temporary file '" + src.getAbsolutePath() + "' after copying it to '" + dest.getAbsolutePath() + "'.");
        }
    }

    private void streamAndMove(InputStream is, File destFile) throws IOException {
        if (!this.tempAndMove) {
            this.stream(is, destFile);
        } else {
            this.downloadTaskDir.mkdirs();
            File tempFile = File.createTempFile(destFile.getName(), ".part", this.downloadTaskDir);
            this.stream(is, tempFile);
            if (destFile.exists() && !destFile.delete()) {
                throw new IOException("Could not delete old destination file '" + destFile.getAbsolutePath() + "'.");
            }
            try {
                this.moveFile(tempFile, destFile);
            }
            catch (IOException e) {
                throw new IOException("Failed to move temporary file '" + tempFile.getAbsolutePath() + "' to destination file '" + destFile.getAbsolutePath() + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stream(InputStream is, File destFile) throws IOException {
        try {
            this.startProgress();
            boolean finished = false;
            try (FileOutputStream os = new FileOutputStream(destFile);){
                int read;
                byte[] buf = new byte[10240];
                while ((read = is.read(buf)) >= 0) {
                    ((OutputStream)os).write(buf, 0, read);
                    this.processedBytes += (long)read;
                    this.logProgress();
                }
                os.flush();
                finished = true;
            }
            finally {
                if (!finished) {
                    destFile.delete();
                }
            }
        }
        finally {
            is.close();
            this.completeProgress();
        }
    }

    private Map<String, Object> readCachedETags() {
        Map<String, Object> cachedETags;
        File cachedETagsFile = this.getCachedETagsFile();
        if (cachedETagsFile.exists()) {
            JsonSlurper slurper = new JsonSlurper();
            cachedETags = (Map)slurper.parse(cachedETagsFile, "UTF-8");
        } else {
            cachedETags = new LinkedHashMap<String, Object>();
        }
        return cachedETags;
    }

    private String getCachedETag(HttpHost host, String file) {
        Map<String, Object> cachedETags = this.readCachedETags();
        Map hostMap = (Map)cachedETags.get(host.toURI());
        if (hostMap == null) {
            return null;
        }
        Map etagMap = (Map)hostMap.get(file);
        if (etagMap == null) {
            return null;
        }
        return (String)etagMap.get("ETag");
    }

    private void storeETag(HttpHost host, String file, HttpResponse response) throws IOException {
        File parent;
        Header etagHdr = response.getFirstHeader("ETag");
        if (etagHdr == null) {
            if (!this.quiet) {
                this.logger.warn("Server response does not include an entity tag (ETag).");
            }
            return;
        }
        String etag = etagHdr.getValue();
        if (this.isWeakETag(etag)) {
            if (this.useETag.displayWarningForWeak && !this.quiet) {
                this.logger.warn("Weak entity tag (ETag) encountered. Please make sure you want to compare resources based on weak ETags. If yes, set the 'useETag' flag to \"all\", otherwise set it to \"strongOnly\".");
            }
            if (!this.useETag.useWeakETags) {
                return;
            }
        }
        if ((parent = this.getCachedETagsFile().getParentFile()) != null) {
            parent.mkdirs();
        }
        Map<String, Object> cachedETags = this.readCachedETags();
        LinkedHashMap<String, String> etagMap = new LinkedHashMap<String, String>();
        etagMap.put("ETag", etag);
        String uri = host.toURI();
        LinkedHashMap hostMap = (LinkedHashMap)cachedETags.get(uri);
        if (hostMap == null) {
            hostMap = new LinkedHashMap();
            cachedETags.put(uri, hostMap);
        }
        hostMap.put(file, etagMap);
        String cachedETagsContents = JsonOutput.toJson(cachedETags);
        try (PrintWriter writer = new PrintWriter(this.getCachedETagsFile(), "UTF-8");){
            writer.write(cachedETagsContents);
            writer.flush();
        }
    }

    private boolean isWeakETag(String etag) {
        return etag != null && etag.startsWith("W/");
    }

    private File makeDestFile(URL src) {
        File destFile = this.getDest();
        if (destFile == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        if (destFile.isDirectory()) {
            String name2 = src.toString();
            if (name2.endsWith("/")) {
                name2 = name2.substring(0, name2.length() - 1);
            }
            name2 = name2.substring(name2.lastIndexOf(47) + 1);
            destFile = new File(destFile, name2);
        } else {
            File parent = destFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
        }
        return destFile;
    }

    private CloseableHttpResponse openConnection(HttpHost httpHost, String file, long timestamp, String etag, CloseableHttpClient client) throws IOException {
        CloseableHttpResponse response;
        int code;
        HttpClientContext context = null;
        if (this.username != null && this.password != null) {
            context = HttpClientContext.create();
            RFC2617Scheme as = "Digest".equalsIgnoreCase(this.authScheme) ? new DigestScheme() : new BasicScheme();
            UsernamePasswordCredentials c = new UsernamePasswordCredentials(this.username, this.password);
            this.addAuthentication(httpHost, c, as, context);
        }
        HttpGet get2 = new HttpGet(file);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectTimeoutMs).setConnectionRequestTimeout(this.connectTimeoutMs).setSocketTimeout(this.readTimeoutMs).setCookieSpec("standard").setContentCompressionEnabled(this.compress).build();
        get2.setConfig(config);
        String scheme = httpHost.getSchemeName();
        String proxyHost = System.getProperty(scheme + ".proxyHost");
        String proxyPort = System.getProperty(scheme + ".proxyPort");
        String proxyUser = System.getProperty(scheme + ".proxyUser");
        String proxyPassword = System.getProperty(scheme + ".proxyPassword");
        if (proxyHost != null && proxyPort != null && proxyUser != null && proxyPassword != null) {
            if (context == null) {
                context = HttpClientContext.create();
            }
            int nProxyPort = Integer.parseInt(proxyPort);
            HttpHost proxy = new HttpHost(proxyHost, nProxyPort, scheme);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            this.addAuthentication(proxy, credentials, null, context);
        }
        if (timestamp > 0L) {
            get2.setHeader("If-Modified-Since", DateUtils.formatDate(new Date(timestamp)));
        }
        if (etag != null) {
            get2.setHeader("If-None-Match", etag);
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                get2.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        if (((code = (response = client.execute(httpHost, (HttpRequest)get2, (HttpContext)context)).getStatusLine().getStatusCode()) < 200 || code > 299) && code != 304) {
            String phrase = response.getStatusLine().getReasonPhrase();
            String url = httpHost + file;
            phrase = phrase == null || phrase.isEmpty() ? "HTTP status code: " + code + ", URL: " + url : phrase + " (HTTP status code: " + code + ", URL: " + url + ")";
            response.close();
            throw new ClientProtocolException(phrase);
        }
        return response;
    }

    private void addAuthentication(HttpHost host, Credentials credentials, AuthScheme authScheme, HttpClientContext context) {
        CredentialsProvider credsProvider;
        AuthCache authCache = context.getAuthCache();
        if (authCache == null) {
            authCache = new BasicAuthCache();
            context.setAuthCache(authCache);
        }
        if ((credsProvider = context.getCredentialsProvider()) == null) {
            credsProvider = new BasicCredentialsProvider();
            context.setCredentialsProvider(credsProvider);
        }
        credsProvider.setCredentials(new AuthScope(host), credentials);
        if (authScheme != null) {
            authCache.put(host, authScheme);
        }
    }

    private String toLengthText(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    private long parseLastModified(HttpResponse response) {
        Header header = response.getLastHeader("Last-Modified");
        if (header == null) {
            return 0L;
        }
        String value = header.getValue();
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        Date date = DateUtils.parseDate(value);
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    private void startProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.started();
        }
    }

    private void completeProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.completed();
        }
    }

    private void logProgress() {
        if (this.progressLogger == null) {
            return;
        }
        long processedKb = this.processedBytes / 1024L;
        if (processedKb > this.loggedKb) {
            String msg = this.toLengthText(this.processedBytes);
            if (this.size != null) {
                msg = msg + "/" + this.size;
            }
            msg = msg + " downloaded";
            this.progressLogger.progress(msg);
            this.loggedKb = processedKb;
        }
    }

    public boolean isUpToDate() {
        return this.upToDate == this.getSources().size();
    }

    public List<File> getOutputFiles() {
        List<URL> sources2 = this.getSources();
        ArrayList<File> files = new ArrayList<File>(sources2.size());
        for (URL src : sources2) {
            files.add(this.makeDestFile(src));
        }
        return files;
    }

    @Override
    public void src(Object src) {
        this.sourceObjects.add(src);
    }

    @Override
    public void dest(Object dest) {
        this.destObject = dest;
    }

    @Override
    public void quiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void onlyIfModified(boolean onlyIfModified) {
        this.onlyIfModified = onlyIfModified;
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.onlyIfModified(onlyIfNewer);
    }

    @Override
    public void compress(boolean compress) {
        this.compress = compress;
    }

    @Override
    public void username(String username) {
        this.username = username;
    }

    @Override
    public void password(String password) {
        this.password = password;
    }

    @Override
    public void authScheme(String authScheme) {
        if (!authScheme.equalsIgnoreCase("Basic") && !authScheme.equalsIgnoreCase("Digest")) {
            throw new IllegalArgumentException("Invalid authentication scheme: '" + authScheme + "'. Valid values are 'Basic' and 'Digest'.");
        }
        this.authScheme = authScheme;
    }

    @Override
    public void headers(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        } else {
            this.headers.clear();
        }
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    @Override
    public void header(String name2, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(name2, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.acceptAnyCertificate = accept;
    }

    @Override
    public void connectTimeout(int milliseconds) {
        this.connectTimeoutMs = milliseconds;
    }

    @Override
    public void readTimeout(int milliseconds) {
        this.readTimeoutMs = milliseconds;
    }

    @Override
    public void retries(int retries) {
        this.retries = retries;
    }

    @Override
    public void downloadTaskDir(Object dir2) {
        if (dir2 instanceof Closure) {
            Closure closure = (Closure)dir2;
            dir2 = closure.call();
        }
        if ((dir2 = ProviderHelper.tryGetProvider(dir2)) instanceof CharSequence) {
            this.downloadTaskDir = this.projectApi.file(dir2.toString());
        } else if (dir2 instanceof File) {
            this.downloadTaskDir = (File)dir2;
        } else {
            throw new IllegalArgumentException("download-task directory must either be a File or a CharSequence");
        }
    }

    @Override
    public void tempAndMove(boolean tempAndMove) {
        this.tempAndMove = tempAndMove;
    }

    @Override
    public void useETag(Object useETag) {
        this.useETag = UseETag.fromValue(useETag);
    }

    @Override
    public void cachedETagsFile(Object location) {
        if (location instanceof Closure) {
            Closure closure = (Closure)location;
            location = closure.call();
        }
        if ((location = ProviderHelper.tryGetProvider(location)) instanceof CharSequence) {
            this.cachedETagsFile = this.projectApi.file(location.toString());
        } else if (location instanceof File) {
            this.cachedETagsFile = (File)location;
        } else {
            throw new IllegalArgumentException("Location for cached ETags must either be a File or a CharSequence");
        }
    }

    private List<URL> convertSource(Object src) {
        ArrayList<URL> result2 = new ArrayList<URL>();
        if (src instanceof Closure) {
            Closure closure = (Closure)src;
            src = closure.call();
        }
        if ((src = ProviderHelper.tryGetProvider(src)) instanceof CharSequence) {
            try {
                result2.add(new URL(src.toString()));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid source URL", e);
            }
        } else if (src instanceof URL) {
            result2.add((URL)src);
        } else if (src instanceof Collection) {
            Collection sc = (Collection)src;
            for (Object sco : sc) {
                result2.addAll(this.convertSource(sco));
            }
        } else if (src != null && src.getClass().isArray()) {
            int len = Array.getLength(src);
            for (int i2 = 0; i2 < len; ++i2) {
                Object sco = Array.get(src, i2);
                result2.addAll(this.convertSource(sco));
            }
        } else {
            throw new IllegalArgumentException("Download source must either be a URL, a CharSequence, a Collection or an array.");
        }
        return result2;
    }

    private List<URL> getSources() {
        if (this.cachedSources != null) {
            return this.cachedSources;
        }
        this.cachedSources = new ArrayList<URL>(this.sourceObjects.size());
        for (Object src : this.sourceObjects) {
            this.cachedSources.addAll(this.convertSource(src));
        }
        return this.cachedSources;
    }

    @Override
    public Object getSrc() {
        List<URL> sources2 = this.getSources();
        if (sources2.size() == 1) {
            return sources2.get(0);
        }
        return sources2;
    }

    @Override
    public File getDest() {
        if (this.cachedDest != null) {
            return this.cachedDest;
        }
        if (this.destObject instanceof Closure) {
            Closure closure = (Closure)this.destObject;
            this.destObject = closure.call();
        }
        this.destObject = ProviderHelper.tryGetProvider(this.destObject);
        if (this.destObject instanceof CharSequence) {
            this.cachedDest = this.projectApi.file(this.destObject.toString());
        } else if (this.destObject instanceof File) {
            this.cachedDest = (File)this.destObject;
        } else {
            throw new IllegalArgumentException("Download destination must either be a File or a CharSequence");
        }
        return this.cachedDest;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isOnlyIfModified() {
        return this.onlyIfModified;
    }

    @Override
    public boolean isOnlyIfNewer() {
        return this.isOnlyIfModified();
    }

    @Override
    public boolean isCompress() {
        return this.compress;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getAuthScheme() {
        return this.authScheme;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name2) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name2);
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeoutMs;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeoutMs;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public File getDownloadTaskDir() {
        return this.downloadTaskDir;
    }

    @Override
    public boolean isTempAndMove() {
        return this.tempAndMove;
    }

    @Override
    public Object getUseETag() {
        return this.useETag.value;
    }

    @Override
    public File getCachedETagsFile() {
        if (this.cachedETagsFile == null) {
            return new File(this.downloadTaskDir, "etags.json");
        }
        return this.cachedETagsFile;
    }

    private static enum UseETag {
        FALSE(Boolean.FALSE, false, false, false),
        TRUE(Boolean.TRUE, true, true, true),
        ALL("all", true, true, false),
        STRONG_ONLY("strongOnly", true, false, false);

        final Object value;
        final boolean enabled;
        final boolean useWeakETags;
        final boolean displayWarningForWeak;

        private UseETag(Object value, boolean useAnyETag, boolean useWeakETags, boolean displayWarningForWeak) {
            this.value = value;
            this.enabled = useAnyETag;
            this.useWeakETags = useWeakETags;
            this.displayWarningForWeak = displayWarningForWeak;
        }

        static UseETag fromValue(Object value) {
            if (UseETag.TRUE.value.equals(value)) {
                return TRUE;
            }
            if (UseETag.FALSE.value.equals(value)) {
                return FALSE;
            }
            if (value instanceof String) {
                String s = (String)value;
                if (UseETag.ALL.value.equals(s)) {
                    return ALL;
                }
                if (UseETag.STRONG_ONLY.value.equals(s)) {
                    return STRONG_ONLY;
                }
                if ("true".equalsIgnoreCase(s)) {
                    return TRUE;
                }
                if ("false".equalsIgnoreCase(s)) {
                    return TRUE;
                }
            }
            throw new IllegalArgumentException("Illegal value for 'useETag' flag");
        }
    }
}

