/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.checker;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.checker.KotlinAndroidSourceSetLayoutChecker;
import org.jetbrains.kotlin.gradle.utils.SingleWarningPerBuild;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/DiagnosticReporterImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$DiagnosticReporter;", "project", "Lorg/gradle/api/Project;", "logger", "Lorg/gradle/api/logging/Logger;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "(Lorg/gradle/api/Project;Lorg/gradle/api/logging/Logger;Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;)V", "error", "", "diagnostic", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$Diagnostic;", "warning", "", "kotlin-gradle-plugin_common"})
final class DiagnosticReporterImpl
implements KotlinAndroidSourceSetLayoutChecker.DiagnosticReporter {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final KotlinAndroidSourceSetLayout layout;

    public DiagnosticReporterImpl(@NotNull Project project, @NotNull Logger logger, @NotNull KotlinAndroidSourceSetLayout layout) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.project = project;
        this.logger = logger;
        this.layout = layout;
    }

    @Override
    @NotNull
    public Void error(@NotNull KotlinAndroidSourceSetLayoutChecker.Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        throw new KotlinAndroidSourceSetLayoutChecker.ProjectMisconfiguredException(this.layout.getName() + ": " + diagnostic.getMessage());
    }

    @Override
    public void warning(@NotNull KotlinAndroidSourceSetLayoutChecker.Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        SingleWarningPerBuild.INSTANCE.show(this.project, this.logger, "w: " + this.layout.getName() + ": " + diagnostic.getMessage() + '\n');
    }
}

