/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.statistics.BuildSession;
import org.jetbrains.kotlin.statistics.fileloggers.FileRecordLogger;
import org.jetbrains.kotlin.statistics.fileloggers.IRecordLogger;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;
import org.jetbrains.kotlin.statistics.fileloggers.NullRecordLogger;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u00010B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0006\u0010\u001f\u001a\u00020\nJ1\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\n2\b\u0010$\u001a\u0004\u0018\u00010\u00142\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010&J1\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020'2\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010\u00142\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010(J1\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020)2\u0006\u0010#\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010\u00142\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00072\b\u0010-\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u0019H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;", "Lorg/jetbrains/kotlin/statistics/metrics/IStatisticsValuesConsumer;", "rootPath", "Ljava/io/File;", "maxProfileFiles", "", "maxFileSize", "", "maxFileAge", "forceValuesValidation", "", "(Ljava/io/File;IJJZ)V", "buildSession", "Lorg/jetbrains/kotlin/statistics/BuildSession;", "metricsContainer", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "profileFileNameFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "profileFileNameSuffix", "", "statisticsFolder", "trackingFile", "Lorg/jetbrains/kotlin/statistics/fileloggers/IRecordLogger;", "closeTrackingFile", "", "finishBuildSession", "action", "failure", "", "initTrackingFile", "isBuildSessionStarted", "report", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "value", "subprojectName", "weight", "(Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;ZLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "(Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;JLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "(Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Z", "startBuildSession", "buildSinceDaemonStart", "buildStartedTime", "(JLjava/lang/Long;)V", "unlockJournalFile", "Companion", "kotlin-gradle-statistics"})
@SourceDebugExtension(value={"SMAP\nBuildSessionLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class BuildSessionLogger
implements IStatisticsValuesConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxProfileFiles;
    private final long maxFileSize;
    private final long maxFileAge;
    private final boolean forceValuesValidation;
    private final DateTimeFormatter profileFileNameFormatter;
    @NotNull
    private final String profileFileNameSuffix;
    @NotNull
    private final File statisticsFolder;
    @Nullable
    private BuildSession buildSession;
    @Nullable
    private IRecordLogger trackingFile;
    @NotNull
    private final MetricsContainer metricsContainer;
    @NotNull
    public static final String STATISTICS_FOLDER_NAME = "kotlin-profile";
    @NotNull
    public static final String STATISTICS_FILE_NAME_PATTERN = "\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{3}(.\\d+)?.profile";
    private static final int DEFAULT_MAX_PROFILE_FILES = 1000;
    private static final long DEFAULT_MAX_PROFILE_FILE_SIZE = 100000L;
    private static final long DEFAULT_MAX_FILE_AGE = 2592000000L;

    /*
     * WARNING - void declaration
     */
    public BuildSessionLogger(@NotNull File rootPath, int maxProfileFiles, long maxFileSize, long maxFileAge, boolean forceValuesValidation) {
        void it;
        File file;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.maxProfileFiles = maxProfileFiles;
        this.maxFileSize = maxFileSize;
        this.maxFileAge = maxFileAge;
        this.forceValuesValidation = forceValuesValidation;
        this.profileFileNameFormatter = DateTimeFormatter.ofPattern("YYYY-MM-dd-HH-mm-ss-SSS");
        this.profileFileNameSuffix = ".profile";
        File file2 = file = new File(rootPath, STATISTICS_FOLDER_NAME);
        BuildSessionLogger buildSessionLogger = this;
        boolean bl = false;
        it.mkdirs();
        buildSessionLogger.statisticsFolder = file;
        this.metricsContainer = new MetricsContainer(this.forceValuesValidation);
    }

    public /* synthetic */ BuildSessionLogger(File file, int n, long l, long l2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        if ((n2 & 4) != 0) {
            l = 100000L;
        }
        if ((n2 & 8) != 0) {
            l2 = 2592000000L;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(file, n, l, l2, bl);
    }

    public final synchronized void startBuildSession(long buildSinceDaemonStart, @Nullable Long buildStartedTime) {
        IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.GRADLE_BUILD_NUMBER_IN_CURRENT_DAEMON, buildSinceDaemonStart, null, null, 12, null);
        this.buildSession = new BuildSession(buildStartedTime);
        this.initTrackingFile();
    }

    public final synchronized boolean isBuildSessionStarted() {
        return this.buildSession != null;
    }

    private final synchronized void closeTrackingFile() {
        block0: {
            IRecordLogger iRecordLogger = this.trackingFile;
            if (iRecordLogger == null) break block0;
            IRecordLogger it = iRecordLogger;
            boolean bl = false;
            this.metricsContainer.flush(it);
            it.close();
            this.trackingFile = null;
        }
    }

    private final synchronized void initTrackingFile() {
        IRecordLogger iRecordLogger;
        BuildSessionLogger buildSessionLogger;
        this.closeTrackingFile();
        List list2 = Companion.listProfileFiles(this.statisticsFolder);
        if (list2 == null) {
            if (this.statisticsFolder.mkdirs()) {
                list2 = CollectionsKt.emptyList();
            } else {
                return;
            }
        }
        List fileCandidates = list2;
        Iterator<File> iterator = fileCandidates.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            long lastModified;
            int index = n++;
            File file = iterator.next();
            boolean toDelete = index < fileCandidates.size() - this.maxProfileFiles ? true : (lastModified = file.lastModified()) > 0L && System.currentTimeMillis() - this.maxFileAge > lastModified;
            if (!toDelete) continue;
            file.delete();
        }
        List<File> list3 = Companion.listProfileFiles(this.statisticsFolder);
        if ((list3 != null ? list3.size() : 0) > this.maxProfileFiles * 2) {
            this.trackingFile = new NullRecordLogger();
            return;
        }
        File file = (File)CollectionsKt.lastOrNull((List)fileCandidates);
        if (file == null) {
            file = BuildSessionLogger.initTrackingFile$newFile(this);
        }
        File lastFile = file;
        BuildSessionLogger buildSessionLogger2 = this;
        try {
            buildSessionLogger = buildSessionLogger2;
            iRecordLogger = lastFile.length() < this.maxFileSize ? new FileRecordLogger(lastFile) : new FileRecordLogger(BuildSessionLogger.initTrackingFile$newFile(this));
        }
        catch (IOException index) {
            IRecordLogger iRecordLogger2;
            try {
                buildSessionLogger = buildSessionLogger2;
                iRecordLogger2 = new FileRecordLogger(BuildSessionLogger.initTrackingFile$newFile(this));
            }
            catch (IOException toDelete) {
                buildSessionLogger = buildSessionLogger2;
                iRecordLogger2 = new NullRecordLogger();
            }
            iRecordLogger = iRecordLogger2;
        }
        buildSessionLogger.trackingFile = iRecordLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void finishBuildSession(@Nullable String action, @Nullable Throwable failure) {
        try {
            long finishTime = System.currentTimeMillis();
            BuildSession buildSession = this.buildSession;
            if (buildSession != null) {
                BuildSession buildSession2;
                BuildSession it = buildSession2 = buildSession;
                boolean bl = false;
                if (it.getBuildStartedTime() != null) {
                    IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.GRADLE_BUILD_DURATION, finishTime - it.getBuildStartedTime(), null, null, 12, null);
                }
                IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.GRADLE_EXECUTION_DURATION, finishTime - it.getProjectEvaluatedTime(), null, null, 12, null);
                IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.BUILD_FINISH_TIME, finishTime, null, null, 12, null);
                IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, BooleanMetrics.BUILD_FAILED, failure != null, null, null, 12, null);
            }
            this.buildSession = null;
        }
        finally {
            this.unlockJournalFile();
        }
    }

    private final synchronized void unlockJournalFile() {
        this.closeTrackingFile();
    }

    @Override
    public boolean report(@NotNull BooleanMetrics metric, boolean value, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.metricsContainer.report(metric, value, subprojectName, weight);
    }

    @Override
    public boolean report(@NotNull NumericalMetrics metric, long value, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.metricsContainer.report(metric, value, subprojectName, weight);
    }

    @Override
    public boolean report(@NotNull StringMetrics metric, @NotNull String value, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.metricsContainer.report(metric, value, subprojectName, weight);
    }

    private static final File initTrackingFile$newFile(BuildSessionLogger this$0) {
        String timestamp = this$0.profileFileNameFormatter.format(LocalDateTime.now());
        File result2 = new File(this$0.statisticsFolder, timestamp + this$0.profileFileNameSuffix);
        int suffixIndex = 0;
        while (result2.exists()) {
            result2 = new File(this$0.statisticsFolder, timestamp + '.' + suffixIndex++ + this$0.profileFileNameSuffix);
        }
        return result2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion;", "", "()V", "DEFAULT_MAX_FILE_AGE", "", "DEFAULT_MAX_PROFILE_FILES", "", "DEFAULT_MAX_PROFILE_FILE_SIZE", "STATISTICS_FILE_NAME_PATTERN", "", "STATISTICS_FOLDER_NAME", "listProfileFiles", "", "Ljava/io/File;", "statisticsFolder", "kotlin-gradle-statistics"})
    @SourceDebugExtension(value={"SMAP\nBuildSessionLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,167:1\n4307#2,2:168\n*E\n*S KotlinDebug\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion\n*L\n35#1,2:168\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<File> listProfileFiles(@NotNull File statisticsFolder) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)statisticsFolder, (String)"statisticsFolder");
            File[] fileArray = statisticsFolder.listFiles();
            if (fileArray != null) {
                void var3_3;
                void $this$filterTo$iv;
                File[] fileArray2 = fileArray;
                Collection destination$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void it = element$iv = $this$filterTo$iv[j];
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    CharSequence charSequence = string;
                    if (!new Regex(BuildSessionLogger.STATISTICS_FILE_NAME_PATTERN).matches(charSequence)) continue;
                    destination$iv.add(element$iv);
                }
                list2 = CollectionsKt.sorted((Iterable)((ArrayList)var3_3));
            } else {
                list2 = null;
            }
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

