/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.checker;

import com.android.build.gradle.api.AndroidSourceSet;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetInfoKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayoutKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.checker.KotlinAndroidSourceSetLayoutChecker;
import org.jetbrains.kotlin.gradle.utils.AndroidExtensionUitlsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker;", "()V", "checkCreatedSourceSet", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$DiagnosticReporter;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "V1StyleSourceDirUsageDiagnostic", "kotlin-gradle-plugin_common"})
public final class MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker
implements KotlinAndroidSourceSetLayoutChecker {
    @NotNull
    public static final MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker INSTANCE = new MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker();

    private MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker() {
    }

    @Override
    public void checkCreatedSourceSet(@NotNull KotlinAndroidSourceSetLayoutChecker.DiagnosticReporter diagnosticReporter, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        String string = KotlinAndroidSourceSetLayoutKt.getMultiplatformAndroidSourceSetLayoutV1().getNaming().kotlinSourceSetName(target2.getDisambiguationClassifier(), androidSourceSet.getName(), KotlinAndroidSourceSetInfoKt.getAndroidSourceSetInfo(kotlinSourceSet).getAndroidVariantType$kotlin_gradle_plugin_common());
        if (string == null) {
            return;
        }
        String v1kotlinSourceSetName = string;
        if (Intrinsics.areEqual((Object)v1kotlinSourceSetName, (Object)kotlinSourceSet.getName())) {
            return;
        }
        if (AndroidExtensionUitlsKt.getAndroidExtension(target2.getProject()).getSourceSets().findByName(v1kotlinSourceSetName) != null) {
            return;
        }
        File v1KotlinSourceDir = target2.getProject().file((Object)("src/" + v1kotlinSourceSetName + "/kotlin"));
        if (v1KotlinSourceDir.exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)v1KotlinSourceDir, (String)"v1KotlinSourceDir");
            File file = target2.getProject().file((Object)("src/" + kotlinSourceSet.getName() + "/kotlin"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"target.project.file(\"src\u2026nSourceSet.name}/kotlin\")");
            diagnosticReporter.warning(new V1StyleSourceDirUsageDiagnostic(layout, v1KotlinSourceDir, file));
        }
    }

    @Override
    public void checkBeforeLayoutApplied(@NotNull KotlinAndroidSourceSetLayoutChecker.DiagnosticReporter diagnosticReporter, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout) {
        KotlinAndroidSourceSetLayoutChecker.DefaultImpls.checkBeforeLayoutApplied(this, diagnosticReporter, target2, layout);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\tH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker$V1StyleSourceDirUsageDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$Diagnostic;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "v1StyleSourceDirInUse", "Ljava/io/File;", "v2StyleSourceDirToUse", "(Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;Ljava/io/File;Ljava/io/File;)V", "message", "", "getMessage", "()Ljava/lang/String;", "getV1StyleSourceDirInUse", "()Ljava/io/File;", "getV2StyleSourceDirToUse", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
    public static final class V1StyleSourceDirUsageDiagnostic
    implements KotlinAndroidSourceSetLayoutChecker.Diagnostic {
        @NotNull
        private final KotlinAndroidSourceSetLayout layout;
        @NotNull
        private final File v1StyleSourceDirInUse;
        @NotNull
        private final File v2StyleSourceDirToUse;

        public V1StyleSourceDirUsageDiagnostic(@NotNull KotlinAndroidSourceSetLayout layout, @NotNull File v1StyleSourceDirInUse, @NotNull File v2StyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            Intrinsics.checkNotNullParameter((Object)v1StyleSourceDirInUse, (String)"v1StyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)v2StyleSourceDirToUse, (String)"v2StyleSourceDirToUse");
            this.layout = layout;
            this.v1StyleSourceDirInUse = v1StyleSourceDirInUse;
            this.v2StyleSourceDirToUse = v2StyleSourceDirToUse;
        }

        @NotNull
        public final File getV1StyleSourceDirInUse() {
            return this.v1StyleSourceDirInUse;
        }

        @NotNull
        public final File getV2StyleSourceDirToUse() {
            return this.v2StyleSourceDirToUse;
        }

        @Override
        @NotNull
        public String getMessage() {
            return StringsKt.trimIndent((String)("\n                Found used source directory " + this.v1StyleSourceDirInUse + "\n                This source directory was supported by: " + KotlinAndroidSourceSetLayoutKt.getMultiplatformAndroidSourceSetLayoutV1().getName() + "\n                Current KotlinAndroidSourceSetLayout: " + this.layout.getName() + "\n                New source directory is: " + this.v2StyleSourceDirToUse + "\n            "));
        }

        private final KotlinAndroidSourceSetLayout component1() {
            return this.layout;
        }

        @NotNull
        public final File component2() {
            return this.v1StyleSourceDirInUse;
        }

        @NotNull
        public final File component3() {
            return this.v2StyleSourceDirToUse;
        }

        @NotNull
        public final V1StyleSourceDirUsageDiagnostic copy(@NotNull KotlinAndroidSourceSetLayout layout, @NotNull File v1StyleSourceDirInUse, @NotNull File v2StyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            Intrinsics.checkNotNullParameter((Object)v1StyleSourceDirInUse, (String)"v1StyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)v2StyleSourceDirToUse, (String)"v2StyleSourceDirToUse");
            return new V1StyleSourceDirUsageDiagnostic(layout, v1StyleSourceDirInUse, v2StyleSourceDirToUse);
        }

        public static /* synthetic */ V1StyleSourceDirUsageDiagnostic copy$default(V1StyleSourceDirUsageDiagnostic v1StyleSourceDirUsageDiagnostic, KotlinAndroidSourceSetLayout kotlinAndroidSourceSetLayout, File file, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                kotlinAndroidSourceSetLayout = v1StyleSourceDirUsageDiagnostic.layout;
            }
            if ((n & 2) != 0) {
                file = v1StyleSourceDirUsageDiagnostic.v1StyleSourceDirInUse;
            }
            if ((n & 4) != 0) {
                file2 = v1StyleSourceDirUsageDiagnostic.v2StyleSourceDirToUse;
            }
            return v1StyleSourceDirUsageDiagnostic.copy(kotlinAndroidSourceSetLayout, file, file2);
        }

        @NotNull
        public String toString() {
            return "V1StyleSourceDirUsageDiagnostic(layout=" + this.layout + ", v1StyleSourceDirInUse=" + this.v1StyleSourceDirInUse + ", v2StyleSourceDirToUse=" + this.v2StyleSourceDirToUse + ')';
        }

        public int hashCode() {
            int result2 = this.layout.hashCode();
            result2 = result2 * 31 + this.v1StyleSourceDirInUse.hashCode();
            result2 = result2 * 31 + this.v2StyleSourceDirToUse.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof V1StyleSourceDirUsageDiagnostic)) {
                return false;
            }
            V1StyleSourceDirUsageDiagnostic v1StyleSourceDirUsageDiagnostic = (V1StyleSourceDirUsageDiagnostic)other;
            if (!Intrinsics.areEqual((Object)this.layout, (Object)v1StyleSourceDirUsageDiagnostic.layout)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.v1StyleSourceDirInUse, (Object)v1StyleSourceDirUsageDiagnostic.v1StyleSourceDirInUse)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.v2StyleSourceDirToUse, (Object)v1StyleSourceDirUsageDiagnostic.v2StyleSourceDirToUse);
        }
    }
}

