/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionType;
import org.jetbrains.kotlin.gradle.utils.SingleWarningPerBuild;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionTypeProvider;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "propertiesProvider", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "chooseDistributionType", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "prebuiltType", "lightType", "defaultType", "getDistributionType", "version", "", "warning", "", "message", "kotlin-gradle-plugin_common"})
public final class NativeDistributionTypeProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final PropertiesProvider propertiesProvider;

    public NativeDistributionTypeProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.propertiesProvider = PropertiesProvider.Companion.invoke(this.project);
    }

    private final void warning(String message2) {
        SingleWarningPerBuild.INSTANCE.show(this.project, "Warning: " + message2);
    }

    private final NativeDistributionType chooseDistributionType(NativeDistributionType prebuiltType, NativeDistributionType lightType, NativeDistributionType defaultType) {
        NativeDistributionType nativeDistributionType;
        String string = this.propertiesProvider.getNativeDistributionType();
        String requestedByUser = string != null ? CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)string) : null;
        Boolean deprecatedRestricted = this.propertiesProvider.getNativeDeprecatedRestricted();
        if (requestedByUser == null && deprecatedRestricted != null) {
            return deprecatedRestricted != false ? lightType : defaultType;
        }
        String string2 = requestedByUser;
        if (string2 == null) {
            nativeDistributionType = defaultType;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"prebuilt")) {
            nativeDistributionType = prebuiltType;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"light")) {
            nativeDistributionType = lightType;
        } else {
            this.warning("Unknown Kotlin/Native distribution type: " + requestedByUser + ". Available values: prebuilt, light");
            nativeDistributionType = defaultType;
        }
        return nativeDistributionType;
    }

    @NotNull
    public final NativeDistributionType getDistributionType(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        if (this.propertiesProvider.getNativeDeprecatedRestricted() != null) {
            this.warning("Project property 'kotlin.native.restrictedDistribution' is deprecated. Please use 'kotlin.native.distribution.type=light' instead");
        }
        return this.chooseDistributionType(NativeDistributionType.PREBUILT, NativeDistributionType.LIGHT, NativeDistributionType.PREBUILT);
    }
}

