/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.InternalKotlinGradlePluginApi;
import org.jetbrains.kotlin.gradle.plugin.mpp.BitcodeEmbeddingMode;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.utils.XcodeUtils;
import org.jetbrains.kotlin.gradle.utils.XcodeVersion;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@InternalKotlinGradlePluginApi
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\b\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/XcodeUtils;", "", "()V", "currentVersion", "Lorg/jetbrains/kotlin/gradle/utils/XcodeVersion;", "getCurrentVersion", "()Lorg/jetbrains/kotlin/gradle/utils/XcodeVersion;", "currentVersion$delegate", "Lkotlin/Lazy;", "defaultTestDevices", "", "Lorg/jetbrains/kotlin/konan/target/Family;", "", "getDefaultTestDevices", "()Ljava/util/Map;", "defaultTestDevices$delegate", "defaultBitcodeEmbeddingMode", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/BitcodeEmbeddingMode;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "buildType", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "getDefaultTestDeviceId", "Companion", "kotlin-gradle-plugin_common"})
public final class XcodeUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy currentVersion$delegate = LazyKt.lazy((Function0)currentVersion.2.INSTANCE);
    @NotNull
    private final Lazy defaultTestDevices$delegate = LazyKt.lazy((Function0)defaultTestDevices.2.INSTANCE);
    @Nullable
    private static final XcodeUtils INSTANCE = HostManager.Companion.getHostIsMac() ? new XcodeUtils() : null;

    private XcodeUtils() {
    }

    @NotNull
    public final XcodeVersion getCurrentVersion() {
        Lazy lazy = this.currentVersion$delegate;
        return (XcodeVersion)lazy.getValue();
    }

    private final Map<Family, String> getDefaultTestDevices() {
        Lazy lazy = this.defaultTestDevices$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final String getDefaultTestDeviceId(@NotNull KonanTarget target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return this.getDefaultTestDevices().get(target2.getFamily());
    }

    @NotNull
    public final BitcodeEmbeddingMode defaultBitcodeEmbeddingMode(@NotNull KonanTarget target2, @NotNull NativeBuildType buildType) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        if (this.getCurrentVersion().getMajor() < 14) {
            Object[] objectArray = new Family[]{Family.IOS, Family.WATCHOS, Family.TVOS};
            if (CollectionsKt.listOf((Object[])objectArray).contains(target2.getFamily())) {
                objectArray = new Architecture[]{Architecture.ARM32, Architecture.ARM64};
                if (CollectionsKt.listOf((Object[])objectArray).contains(target2.getArchitecture())) {
                    switch (WhenMappings.$EnumSwitchMapping$0[buildType.ordinal()]) {
                        case 1: {
                            return BitcodeEmbeddingMode.BITCODE;
                        }
                        case 2: {
                            return BitcodeEmbeddingMode.MARKER;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return BitcodeEmbeddingMode.DISABLE;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/XcodeUtils$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/kotlin/gradle/utils/XcodeUtils;", "getINSTANCE$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/utils/XcodeUtils;", "parseFromXcodebuild", "Lorg/jetbrains/kotlin/gradle/utils/XcodeVersion;", "output", "", "parseFromXcodebuild$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final XcodeUtils getINSTANCE$kotlin_gradle_plugin_common() {
            return INSTANCE;
        }

        @Nullable
        public final XcodeVersion parseFromXcodebuild$kotlin_gradle_plugin_common(@NotNull String output2) {
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            String version2 = StringsKt.removePrefix((String)((String)StringsKt.lines((CharSequence)output2).get(0)), (CharSequence)"Xcode ");
            CharSequence charSequence = version2;
            Regex regex = new Regex("(\\s+|\\.|-)");
            int n = 0;
            List split = regex.split(charSequence, n);
            Integer n2 = StringsKt.toIntOrNull((String)((String)split.get(0)));
            if (n2 == null) {
                return null;
            }
            Object object = (String)CollectionsKt.getOrNull((List)split, (int)1);
            if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return null;
            }
            return new XcodeVersion(n2, (Integer)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildType.values().length];
            try {
                nArray[NativeBuildType.RELEASE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildType.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

