/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.entity;

import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpMessage;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.ProtocolException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.entity.ContentLengthStrategy;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message2) throws HttpException {
        long result2 = this.contentLengthStrategy.determineLength(message2);
        if (result2 == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result2;
    }
}

