/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.d8;

import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/d8/D8Platform;", "", "()V", "ARM64", "", "DARWIN", "LINUX", "WIN", "X64", "X86", "architecture", "getArchitecture", "()Ljava/lang/String;", "name", "getName", "platform", "getPlatform", "props", "Ljava/util/Properties;", "kotlin.jvm.PlatformType", "property", "kotlin-gradle-plugin_common"})
public final class D8Platform {
    @NotNull
    public static final D8Platform INSTANCE = new D8Platform();
    private static final Properties props = System.getProperties();
    @NotNull
    public static final String WIN = "win";
    @NotNull
    public static final String LINUX = "linux";
    @NotNull
    public static final String DARWIN = "mac";
    @NotNull
    public static final String ARM64 = "arm64";
    @NotNull
    public static final String X64 = "64";
    @NotNull
    public static final String X86 = "86";

    private D8Platform() {
    }

    private final String property(String name2) {
        String string = props.getProperty(name2);
        if (string == null) {
            string = System.getProperty(name2);
        }
        return string;
    }

    @NotNull
    public final String getName() {
        String string;
        String string2 = this.property("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property(\"os.name\")");
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String osName = string3;
        if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null)) {
            string = WIN;
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)DARWIN, (boolean)false, (int)2, null)) {
            string = DARWIN;
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)LINUX, (boolean)false, (int)2, null)) {
            string = LINUX;
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"freebsd", (boolean)false, (int)2, null)) {
            string = LINUX;
        } else {
            throw new IllegalArgumentException("Unsupported OS: " + osName);
        }
        return string;
    }

    @NotNull
    public final String getArchitecture() {
        String string;
        String arch = this.property("os.arch");
        if (Intrinsics.areEqual((Object)arch, (Object)"aarch64")) {
            string = ARM64;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)arch, (String)"arch");
            string = StringsKt.contains$default((CharSequence)arch, (CharSequence)X64, (boolean)false, (int)2, null) ? X64 : X86;
        }
        return string;
    }

    @NotNull
    public final String getPlatform() {
        String string;
        switch (INSTANCE.getArchitecture()) {
            case "arm64": {
                string = this.getName() + "-arm64";
                break;
            }
            case "64": {
                string = this.getName() + X64;
                break;
            }
            case "86": {
                string = this.getName() + X86;
                break;
            }
            default: {
                String architecture;
                throw new IllegalStateException(("Unexpected platform architecture " + architecture).toString());
            }
        }
        return string;
    }
}

