/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.gradle.targets.js.yarn

import org.jetbrains.kotlin.gradle.tasks.internal.CleanableStore
import java.io.File

data class YarnEnv(
    val download: Boolean,
    val downloadUrl: String,
    val cleanableStore: CleanableStore,
    val home: File,
    val executable: String,
    val ivyDependency: String,
    val ignoreScripts: Boolean,
    val yarnLockMismatchReport: YarnLockMismatchReport,
    val reportNewYarnLock: Boolean,
    val yarnLockAutoReplace: Boolean,
    val yarnResolutions: List<YarnResolution>
) {
    val standalone: Boolean
        get() = !download
}
