/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.Ordering;
import org.jetbrains.kotlin.com.google.common.collect.ReverseNaturalOrdering;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable<?>>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsFirst;
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsLast;
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable<?> left, Comparable<?> right) {
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        return left.compareTo(right);
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsFirst() {
        Ordering<@Nullable Comparable<Object>> result2 = this.nullsFirst;
        if (result2 == null) {
            result2 = this.nullsFirst = super.nullsFirst();
        }
        return result2;
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsLast() {
        Ordering<@Nullable Comparable<Object>> result2 = this.nullsLast;
        if (result2 == null) {
            result2 = this.nullsLast = super.nullsLast();
        }
        return result2;
    }

    @Override
    public <S extends Comparable<?>> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

