/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key, Object value2) {
        if (key == null) {
            String string = String.valueOf(value2);
            throw new NullPointerException(new StringBuilder(24 + String.valueOf(string).length()).append("null key in entry: null=").append(string).toString());
        }
        if (value2 == null) {
            String string = String.valueOf(key);
            throw new NullPointerException(new StringBuilder(26 + String.valueOf(string).length()).append("null value in entry: ").append(string).append("=null").toString());
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value2, String name2) {
        if (value2 < 0) {
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(name2).length()).append(name2).append(" cannot be negative but was: ").append(value2).toString());
        }
        return value2;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long value2, String name2) {
        if (value2 < 0L) {
            throw new IllegalArgumentException(new StringBuilder(49 + String.valueOf(name2).length()).append(name2).append(" cannot be negative but was: ").append(value2).toString());
        }
        return value2;
    }

    static void checkPositive(int value2, String name2) {
        if (value2 <= 0) {
            throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(name2).length()).append(name2).append(" must be positive but was: ").append(value2).toString());
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

